/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.navigator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorInput;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorStandalone;
import org.jkiss.dbeaver.ext.erd.model.DiagramLoader;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.navigator.DBNDiagram;
import org.jkiss.dbeaver.ext.erd.navigator.DBNDiagramFolder;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;
import org.jkiss.dbeaver.ui.resources.ResourceUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class ERDResourceHandler
extends AbstractResourceHandler {
    private static final Log log = Log.getLog(ERDResourceHandler.class);
    private static final String ERD_EXT = "erd";

    public static IFolder getDiagramsFolder(IProject project, boolean forceCreate) throws CoreException {
        return DBeaverCore.getInstance().getProjectRegistry().getResourceDefaultRoot(project, ERDResourceHandler.class, forceCreate);
    }

    public int getFeatures(IResource resource) {
        if (resource instanceof IFolder) {
            if (resource.getParent() instanceof IFolder) {
                return 30;
            }
            return 20;
        }
        return 11;
    }

    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        if (resource instanceof IFolder) {
            return "diagram folder";
        }
        return "diagram";
    }

    @NotNull
    public String getResourceNodeName(@NotNull IResource resource) {
        if (resource.getParent() instanceof IProject && resource.equals((Object)this.getDefaultRoot(resource.getProject()))) {
            return "ER Diagrams";
        }
        return super.getResourceNodeName(resource);
    }

    @NotNull
    public DBNResource makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) throws CoreException, DBException {
        if (resource instanceof IFile) {
            return new DBNDiagram(parentNode, resource, (DBPResourceHandler)this);
        }
        return new DBNDiagramFolder(parentNode, resource, (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) throws CoreException, DBException {
        if (!(resource instanceof IFile)) {
            return;
        }
        ERDEditorInput erdInput = new ERDEditorInput((IFile)resource);
        DBeaverUI.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)erdInput, ERDEditorStandalone.class.getName());
    }

    public static IFile createDiagram(final EntityDiagram copyFrom, final String title, IFolder folder, DBRProgressMonitor monitor) throws DBException {
        if (folder == null) {
            try {
                folder = ERDResourceHandler.getDiagramsFolder(DBeaverCore.getInstance().getProjectRegistry().getActiveProject(), true);
            }
            catch (CoreException e) {
                throw new DBException("Can't obtain folder for diagram", (Throwable)e);
            }
        }
        if (folder == null) {
            throw new DBException("Can't detect folder for diagram");
        }
        ResourceUtils.checkFolderExists((IFolder)folder, (DBRProgressMonitor)monitor);
        final IFile file = ContentUtils.getUniqueFile((IFolder)folder, (String)CommonUtils.escapeFileName((String)title), (String)ERD_EXT);
        try {
            DBRRunnableWithProgress runnable = new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        EntityDiagram newDiagram = copyFrom == null ? new EntityDiagram(null, "<Diagram>") : copyFrom.copy();
                        newDiagram.setName(title);
                        newDiagram.setLayoutManualAllowed(true);
                        newDiagram.setLayoutManualDesired(true);
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        DiagramLoader.save(monitor, null, newDiagram, false, buffer);
                        ByteArrayInputStream data = new ByteArrayInputStream(buffer.toByteArray());
                        file.create((InputStream)data, true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            if (monitor == null) {
                DBeaverUI.runInProgressService((DBRRunnableWithProgress)runnable);
            } else {
                runnable.run((Object)monitor);
            }
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error creating diagram", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return file;
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources(IResource resource) {
        if (resource instanceof IFile) {
            try {
                return DiagramLoader.extractContainers((IFile)resource);
            }
            catch (Exception e) {
                log.error((Object)e);
                return null;
            }
        }
        return super.getAssociatedDataSources(resource);
    }
}

