/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.ERDMessages;
import org.jkiss.dbeaver.ext.erd.action.DiagramLayoutAction;
import org.jkiss.dbeaver.ext.erd.action.DiagramRefreshAction;
import org.jkiss.dbeaver.ext.erd.action.DiagramToggleGridAction;
import org.jkiss.dbeaver.ext.erd.directedit.StatusLineValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.dnd.DataEditDropTargetListener;
import org.jkiss.dbeaver.ext.erd.dnd.NodeDropTargetListener;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeStyle;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditPartFactory;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorContextMenuProvider;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.editor.ERDOutlinePage;
import org.jkiss.dbeaver.ext.erd.editor.ERDPalettePreferences;
import org.jkiss.dbeaver.ext.erd.editor.ERDPaletteViewerProvider;
import org.jkiss.dbeaver.ext.erd.editor.tools.ChangeZOrderAction;
import org.jkiss.dbeaver.ext.erd.editor.tools.SetPartColorAction;
import org.jkiss.dbeaver.ext.erd.export.ERDExportFormatHandler;
import org.jkiss.dbeaver.ext.erd.export.ERDExportFormatRegistry;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.model.DBPDataSourceUser;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectSearcher;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ERDEditorPart
extends GraphicalEditorWithFlyoutPalette
implements DBPDataSourceUser,
ISearchContextProvider,
IRefreshablePart {
    protected ProgressControl progressControl;
    private PropertySheetPage undoablePropertySheetPage;
    private ScalableFreeformRootEditPart rootPart;
    private List<String> editPartActionIDs = new ArrayList<String>();
    private ERDOutlinePage outlinePage;
    private DefaultEditDomain editDomain;
    private boolean isDirty;
    private boolean isLoaded;
    protected LoadingJob<EntityDiagram> diagramLoadingJob;
    private IPropertyChangeListener configPropertyListener;
    private PaletteRoot paletteRoot;

    protected ERDEditorPart() {
    }

    protected ERDGraphicalViewer getGraphicalViewer() {
        return (ERDGraphicalViewer)super.getGraphicalViewer();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(this.editDomain);
        super.init(site, input);
        this.configPropertyListener = new ConfigPropertyListener();
        ERDActivator.getDefault().getPreferenceStore().addPropertyChangeListener(this.configPropertyListener);
    }

    public void createPartControl(Composite parent) {
        this.progressControl = new ProgressControl(parent, 0x10000000);
        this.progressControl.setShowDivider(true);
        Composite contentContainer = this.progressControl.createContentContainer();
        super.createPartControl(contentContainer);
        this.progressControl.createProgressPanel();
    }

    public void commandStackChanged(EventObject event) {
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.ext.erd.editor.canUndo");
        ActionUtils.evaluatePropertyState((String)"org.jkiss.dbeaver.ext.erd.editor.canRedo");
        this.setDirty(this.getCommandStack().isDirty());
        super.commandStackChanged(event);
    }

    public void dispose() {
        ERDActivator.getDefault().getPreferenceStore().removePropertyChangeListener(this.configPropertyListener);
        if (this.diagramLoadingJob != null) {
            this.diagramLoadingJob.cancel();
            this.diagramLoadingJob = null;
        }
        this.getActionRegistry().dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == GraphicalViewer.class || adapter == EditPartViewer.class) {
            return this.getGraphicalViewer();
        }
        if (adapter == CommandStack.class) {
            return this.getCommandStack();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOverviewOutlinePage();
        }
        if (adapter == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return new WorkbenchAdapter(){

                public String getLabel(Object o) {
                    return "ERD Editor";
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        this.saveDiagramAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return !this.isReadOnly() && this.isDirty;
    }

    public abstract boolean isReadOnly();

    public CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public EntityDiagram getDiagram() {
        return this.getDiagramPart().getDiagram();
    }

    public DiagramPart getDiagramPart() {
        return this.rootPart == null ? null : (DiagramPart)this.rootPart.getContents();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new ERDPaletteViewerProvider((EditDomain)this.editDomain);
    }

    public GraphicalViewer getViewer() {
        return super.getGraphicalViewer();
    }

    protected void createGraphicalViewer(Composite parent) {
        GraphicalViewer viewer = this.createViewer(parent);
        this.setGraphicalViewer(viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        viewer.setContents((Object)new EntityDiagram(null, "empty"));
        ERDEditorContextMenuProvider provider = new ERDEditorContextMenuProvider(this);
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(String.valueOf(ERDEditorPart.class.getName()) + ".EditorContext", (MenuManager)provider, (ISelectionProvider)viewer);
    }

    private GraphicalViewer createViewer(Composite parent) {
        StatusLineValidationMessageHandler validationMessageHandler = new StatusLineValidationMessageHandler(this.getEditorSite());
        ERDGraphicalViewer viewer = new ERDGraphicalViewer(this, validationMessageHandler);
        viewer.createControl(parent);
        viewer.getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        this.rootPart = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)this.rootPart);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)viewer));
        viewer.addDropTargetListener((TransferDropTargetListener)new DataEditDropTargetListener((EditPartViewer)viewer));
        viewer.addDropTargetListener((TransferDropTargetListener)new NodeDropTargetListener((EditPartViewer)viewer));
        viewer.setEditPartFactory(new ERDEditPartFactory());
        return viewer;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().getControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        ERDGraphicalViewer graphicalViewer = this.getGraphicalViewer();
        IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
        graphicalViewer.setProperty("SnapToGrid.isEnabled", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.isVisible", store.getBoolean("erd.grid.enabled"));
        graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
        this.createActions();
        ZoomManager zoomManager = this.rootPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomManager.setZoomLevelContributions(zoomLevels);
        zoomManager.setZoomLevels(new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0});
        ZoomInAction zoomIn = new ZoomInAction(zoomManager);
        ZoomOutAction zoomOut = new ZoomOutAction(zoomManager);
        this.addAction((IAction)zoomIn);
        this.addAction((IAction)zoomOut);
        graphicalViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            String status = selection.isEmpty() ? "" : (selection.size() == 1 ? CommonUtils.toString((Object)selection.getFirstElement()) : String.valueOf(String.valueOf(selection.size())) + " objects");
            this.progressControl.setInfo(status);
            this.updateActions(this.editPartActionIDs);
        });
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
        UIUtils.registerKeyBinding((IServiceLocator)this.getSite(), (IAction)action);
    }

    protected void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (action == null || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected ERDOutlinePage getOverviewOutlinePage() {
        RootEditPart rootEditPart;
        if (this.outlinePage == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.outlinePage = new ERDOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.outlinePage;
    }

    protected PropertySheetPage getPropertySheetPage() {
        if (this.undoablePropertySheetPage == null) {
            this.undoablePropertySheetPage = new PropertySheetPage();
            this.undoablePropertySheetPage.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(this.getCommandStack()));
        }
        return this.undoablePropertySheetPage;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new ERDPalettePreferences();
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    public PaletteRoot createPaletteRoot() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.setLabel("Entity Diagram");
        PaletteDrawer controls = new PaletteDrawer("Tools", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        paletteRoot.add((PaletteEntry)controls);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        controls.add((PaletteEntry)selectionTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
        controls.add((PaletteEntry)new MarqueeToolEntry());
        if (!this.isReadOnly()) {
            PaletteSeparator separator = new PaletteSeparator("tools");
            separator.setUserModificationPermission(1);
            controls.add((PaletteEntry)separator);
            ImageDescriptor connectImage = ERDActivator.getImageDescriptor("icons/connect.png");
            controls.add((PaletteEntry)new ConnectionCreationToolEntry("Connection", "Create Connection", null, connectImage, connectImage));
            ImageDescriptor noteImage = ERDActivator.getImageDescriptor("icons/note.png");
            controls.add((PaletteEntry)new CreationToolEntry("Note", "Create Note", new CreationFactory(){

                public Object getNewObject() {
                    return new ERDNote("Note");
                }

                public Object getObjectType() {
                    return "create child";
                }
            }, noteImage, noteImage));
        }
        return paletteRoot;
    }

    protected FlyoutPaletteComposite createPaletteComposite(Composite parent) {
        FlyoutPaletteComposite paletteComposite = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
        paletteComposite.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
        return paletteComposite;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void refreshDiagram(boolean force, boolean refreshMetadata) {
        if (this.isLoaded && force) {
            this.loadDiagram(refreshMetadata);
        }
    }

    public void refreshPart(Object source, boolean force) {
        this.refreshDiagram(force, true);
    }

    public void saveDiagramAs() {
        List<ERDExportFormatRegistry.FormatDescriptor> allFormats = ERDExportFormatRegistry.getInstance().getFormats();
        String[] extensions = new String[allFormats.size()];
        String[] filterNames = new String[allFormats.size()];
        int i = 0;
        while (i < allFormats.size()) {
            extensions[i] = "*." + allFormats.get(i).getExtension();
            filterNames[i] = String.valueOf(allFormats.get(i).getLabel()) + " (" + extensions[i] + ")";
            ++i;
        }
        Shell shell = this.getSite().getShell();
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setFilterExtensions(extensions);
        saveDialog.setFilterNames(filterNames);
        String filePath = DialogUtils.openFileDialog((FileDialog)saveDialog);
        if (filePath == null || filePath.trim().length() == 0) {
            return;
        }
        File outFile = new File(filePath);
        if (outFile.exists() && !UIUtils.confirmAction((Shell)shell, (String)"Overwrite file", (String)("File '" + filePath + "' already exists.\nOverwrite?"))) {
            return;
        }
        int divPos = filePath.lastIndexOf(46);
        if (divPos == -1) {
            DBUserInterface.getInstance().showError("ERD export", "No file extension was specified");
            return;
        }
        String ext = filePath.substring(divPos + 1);
        ERDExportFormatRegistry.FormatDescriptor targetFormat = null;
        for (ERDExportFormatRegistry.FormatDescriptor format : allFormats) {
            if (!format.getExtension().equals(ext)) continue;
            targetFormat = format;
            break;
        }
        if (targetFormat == null) {
            DBUserInterface.getInstance().showError("ERD export", "No export format correspond to file extension '" + ext + "'");
            return;
        }
        try {
            ERDExportFormatHandler formatHandler = targetFormat.getInstance();
            IFigure figure = this.rootPart.getLayer((Object)"Printable Layers");
            formatHandler.exportDiagram(this.getDiagram(), figure, this.getDiagramPart(), outFile);
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("ERD export failed", null, (Throwable)e);
        }
    }

    public void fillAttributeVisibilityMenu(IMenuManager menu) {
        MenuManager asMenu = new MenuManager("Attribute Styles");
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDAttributeStyle.ICONS));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDAttributeStyle.TYPES));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDAttributeStyle.NULLABILITY));
        asMenu.add((IAction)new ChangeAttributePresentationAction(ERDAttributeStyle.COMMENTS));
        menu.add((IContributionItem)asMenu);
        MenuManager avMenu = new MenuManager("Show Attributes");
        avMenu.add((IAction)new ChangeAttributeVisibilityAction(ERDAttributeVisibility.ALL));
        avMenu.add((IAction)new ChangeAttributeVisibilityAction(ERDAttributeVisibility.KEYS));
        avMenu.add((IAction)new ChangeAttributeVisibilityAction(ERDAttributeVisibility.PRIMARY));
        avMenu.add((IAction)new ChangeAttributeVisibilityAction(ERDAttributeVisibility.NONE));
        menu.add((IContributionItem)avMenu);
    }

    public void fillPartContextMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        menu.add((IAction)new ChangeZOrderAction(this, selection, true));
        menu.add((IAction)new ChangeZOrderAction(this, selection, false));
        menu.add((IAction)new SetPartColorAction(this, selection));
    }

    public void printDiagram() {
        IFigure rootFigure;
        ERDGraphicalViewer viewer = this.getGraphicalViewer();
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null && (rootFigure = this.rootPart.getLayer((Object)"Printable Layers")) != null) {
            PrintFigureOperation printOp = new PrintFigureOperation(new Printer(data), rootFigure);
            IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
            printOp.setPrintMode(store.getInt("erd.print.page-mode"));
            printOp.setPrintMargin(new Insets(store.getInt("erd.print.margin-top"), store.getInt("erd.print.margin-left"), store.getInt("erd.print.margin-bottom"), store.getInt("erd.print.margin-right")));
            printOp.run("Print ER diagram");
        }
    }

    public boolean isSearchPossible() {
        return true;
    }

    public boolean isSearchEnabled() {
        return this.progressControl != null && this.progressControl.isSearchEnabled();
    }

    public boolean performSearch(ISearchContextProvider.SearchType searchType) {
        return this.progressControl != null && this.progressControl.performSearch(searchType);
    }

    protected abstract void loadDiagram(boolean var1);

    private class ChangeAttributePresentationAction
    extends Action {
        private final ERDAttributeStyle style;

        public ChangeAttributePresentationAction(ERDAttributeStyle style) {
            super("Show " + style.getTitle(), 2);
            this.style = style;
        }

        public boolean isChecked() {
            return ArrayUtils.contains((Object[])ERDAttributeStyle.getDefaultStyles(ERDActivator.getDefault().getPreferenceStore()), (Object)((Object)this.style));
        }

        public void run() {
            ERDEditorPart.this.getDiagram().setAttributeStyle(this.style, !this.isChecked());
            ERDEditorPart.this.refreshDiagram(true, false);
        }
    }

    private class ChangeAttributeVisibilityAction
    extends Action {
        private final ERDAttributeVisibility visibility;

        private ChangeAttributeVisibilityAction(ERDAttributeVisibility visibility) {
            super(visibility.getTitle(), 8);
            this.visibility = visibility;
        }

        public boolean isChecked() {
            return this.visibility == ERDEditorPart.this.getDiagram().getAttributeVisibility();
        }

        public void run() {
            ERDEditorPart.this.getDiagram().setAttributeVisibility(this.visibility);
            ERDEditorPart.this.refreshDiagram(true, false);
        }
    }

    private class ConfigPropertyListener
    implements IPropertyChangeListener {
        private ConfigPropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ERDGraphicalViewer graphicalViewer = ERDEditorPart.this.getGraphicalViewer();
            if (graphicalViewer == null) {
                return;
            }
            if ("erd.grid.enabled".equals(event.getProperty())) {
                Boolean enabled = Boolean.valueOf(event.getNewValue().toString());
                graphicalViewer.setProperty("SnapToGrid.isEnabled", enabled);
                graphicalViewer.setProperty("SnapToGrid.isVisible", enabled);
            } else if ("erd.grid.width".equals(event.getProperty()) || "erd.grid.height".equals(event.getProperty())) {
                IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
                graphicalViewer.setProperty("SnapToGrid.GridSpacing", new Dimension(store.getInt("erd.grid.width"), store.getInt("erd.grid.height")));
            }
        }
    }

    protected class ProgressControl
    extends ProgressPageControl {
        private Searcher searcher;
        private ZoomComboContributionItem zoomCombo;

        private ProgressControl(Composite parent, int style) {
            super(parent, style);
            this.searcher = new Searcher();
        }

        protected boolean cancelProgress() {
            if (ERDEditorPart.this.diagramLoadingJob != null) {
                ERDEditorPart.this.diagramLoadingJob.cancel();
                return true;
            }
            return false;
        }

        public ProgressPageControl.ProgressVisualizer<EntityDiagram> createLoadVisualizer() {
            ERDEditorPart.this.getGraphicalControl().setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
            return new LoadVisualizer();
        }

        protected void fillCustomActions(IContributionManager toolBarManager) {
            ZoomManager zoomManager = ERDEditorPart.this.rootPart.getZoomManager();
            String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
            this.zoomCombo = new ZoomComboContributionItem(new IPartService(){

                public void addPartListener(IPartListener listener) {
                }

                public void addPartListener(IPartListener2 listener) {
                }

                public IWorkbenchPart getActivePart() {
                    return ERDEditorPart.this;
                }

                public IWorkbenchPartReference getActivePartReference() {
                    return null;
                }

                public void removePartListener(IPartListener listener) {
                }

                public void removePartListener(IPartListener2 listener) {
                }
            }, zoomStrings);
            toolBarManager.add((IContributionItem)this.zoomCombo);
            toolBarManager.add((IAction)new ZoomInAction(zoomManager));
            toolBarManager.add((IAction)new ZoomOutAction(zoomManager));
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IAction)new DiagramLayoutAction(ERDEditorPart.this));
            toolBarManager.add((IAction)new DiagramToggleGridAction());
            toolBarManager.add((IAction)new DiagramRefreshAction(ERDEditorPart.this));
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)ERDEditorPart.this.getSite(), (String)"org.eclipse.ui.file.saveAs", (String)ERDMessages.erd_editor_control_action_save_external_format, (DBPImage)UIIcon.PICTURE_SAVE));
            toolBarManager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)ERDEditorPart.this.getSite(), (String)"org.eclipse.ui.file.print", (String)ERDMessages.erd_editor_control_action_print_diagram, (DBPImage)UIIcon.PRINT));
            Action configAction = new Action(ERDMessages.erd_editor_control_action_configuration){

                public void run() {
                    UIUtils.showPreferencesFor((Shell)ERDEditorPart.this.getSite().getShell(), (Object)((Object)ERDEditorPart.this), (String[])new String[]{"org.jkiss.dbeaver.preferences.erd.general"});
                }
            };
            configAction.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
            toolBarManager.add((IAction)configAction);
        }

        protected ISearchExecutor getSearchRunner() {
            return this.searcher;
        }

        private class LoadVisualizer
        extends ProgressPageControl.ProgressVisualizer<EntityDiagram> {
            private LoadVisualizer() {
                super((ProgressPageControl)ProgressControl.this);
            }

            public void visualizeLoading() {
                super.visualizeLoading();
            }

            public void completeLoading(EntityDiagram entityDiagram) {
                super.completeLoading((Object)entityDiagram);
                Control graphicalControl = ERDEditorPart.this.getGraphicalControl();
                if (graphicalControl == null) {
                    return;
                }
                graphicalControl.setBackground(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.background"));
                ERDEditorPart.this.isLoaded = true;
                Control control = ERDEditorPart.this.getGraphicalViewer().getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (entityDiagram != null) {
                    List<String> errorMessages = entityDiagram.getErrorMessages();
                    if (!errorMessages.isEmpty()) {
                        ArrayList<Status> messageStatuses = new ArrayList<Status>(errorMessages.size());
                        for (String error : errorMessages) {
                            messageStatuses.add(new Status(4, DBeaverCore.getCorePluginID(), error));
                        }
                        MultiStatus status = new MultiStatus(DBeaverCore.getCorePluginID(), 0, messageStatuses.toArray(new IStatus[messageStatuses.size()]), null, null);
                        DBUserInterface.getInstance().showError("Diagram loading errors", "Error(s) occurred during diagram loading. If these errors are recoverable then fix errors and then refresh/reopen diagram", (IStatus)status);
                    }
                    ProgressControl.this.setInfo(String.valueOf(entityDiagram.getEntityCount()) + " objects");
                } else {
                    ProgressControl.this.setInfo("Empty diagram due to error (see error log)");
                }
                ERDEditorPart.this.getCommandStack().flush();
                ERDEditorPart.this.getGraphicalViewer().setContents(entityDiagram);
                ProgressControl.this.zoomCombo.setZoomManager(ERDEditorPart.this.rootPart.getZoomManager());
            }
        }
    }

    private class Searcher
    extends ObjectSearcher<DBPNamedObject> {
        private Searcher() {
        }

        protected void setInfo(String message) {
            ERDEditorPart.this.progressControl.setInfo(message);
        }

        protected Collection<DBPNamedObject> getContent() {
            return ERDEditorPart.this.getDiagramPart().getChildren();
        }

        protected void selectObject(DBPNamedObject object) {
            if (object == null) {
                ERDEditorPart.this.getGraphicalViewer().deselectAll();
            } else {
                ERDEditorPart.this.getGraphicalViewer().select((EditPart)object);
            }
        }

        protected void updateObject(DBPNamedObject object) {
        }

        protected void revealObject(DBPNamedObject object) {
            ERDEditorPart.this.getGraphicalViewer().reveal((EditPart)object);
        }
    }
}

