/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.ide.ui.texteditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.ide.core.DBeaverIDECore;

public class DatabaseMarkerAnnotationModel
extends ResourceMarkerAnnotationModel {
    private static final String[] ATTRIBUTE_NAMES = new String[]{"org.jkiss.dbeaver.runtime.ide.core.datasourceId", "org.jkiss.dbeaver.runtime.ide.core.nodePath"};
    private final DBSObject databaseObject;
    private final DBNNode node;
    private final String datasourceId;
    private final String nodeItemPath;

    public DatabaseMarkerAnnotationModel(DBSObject databaseObject, DBNDatabaseNode node, IResource resource) {
        super(resource);
        this.databaseObject = databaseObject;
        this.node = node;
        this.datasourceId = databaseObject.getDataSource().getContainer().getId();
        this.nodeItemPath = node.getNodeItemPath();
    }

    protected DBSObject getDatabaseObject() {
        return this.databaseObject;
    }

    protected DBNNode getNode() {
        return this.node;
    }

    protected boolean isAcceptable(IMarker marker) {
        Object[] attributes;
        block4: {
            boolean acceptable = super.isAcceptable(marker);
            if (!acceptable) {
                return false;
            }
            try {
                attributes = marker.getAttributes(ATTRIBUTE_NAMES);
                if (this.datasourceId.equals(attributes[0])) break block4;
                return false;
            }
            catch (CoreException e) {
                DBeaverIDECore.log((IStatus)e.getStatus());
                return false;
            }
        }
        return this.nodeItemPath.equals(attributes[1]);
    }
}

