/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui;

import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mssql.SQLServerActivator;
import org.jkiss.dbeaver.ext.mssql.SQLServerMessages;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class SQLServerConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Label userNameLabel;
    private Text userNameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button windowsAuthenticationButton;
    private Button showAllSchemas;
    private boolean activated;
    private static ImageDescriptor MSSQL_LOGO_IMG = SQLServerActivator.getImageDescriptor("icons/mssql_logo.png");
    private static ImageDescriptor SYBASE_LOGO_IMG = SQLServerActivator.getImageDescriptor("icons/sybase_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        Composite settingsGroup = new Composite(composite, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        settingsGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        settingsGroup.setLayoutData((Object)gd);
        Label hostLabel = new Label(settingsGroup, 0);
        hostLabel.setText(SQLServerMessages.dialog_connection_host_label);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        Label portLabel = new Label(settingsGroup, 0);
        portLabel.setText(SQLServerMessages.dialog_connection_port_label);
        portLabel.setLayoutData((Object)new GridData(128));
        this.portText = new Text(settingsGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 60;
        this.portText.setLayoutData((Object)gd);
        Label dbLabel = new Label(settingsGroup, 0);
        dbLabel.setText(SQLServerMessages.dialog_connection_database_schema_label);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        if (SQLServerUtils.isDriverSqlServer(this.getSite().getDriver())) {
            this.windowsAuthenticationButton = UIUtils.createLabelCheckbox((Composite)settingsGroup, (String)SQLServerMessages.dialog_connection_windows_authentication_button, (boolean)false);
            this.windowsAuthenticationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SQLServerConnectionPage.this.enableTexts();
                }
            });
            this.createEmptyLabel(settingsGroup, 1);
        }
        this.userNameLabel = new Label(settingsGroup, 0);
        this.userNameLabel.setText(SQLServerMessages.dialog_connection_user_name_label);
        this.userNameLabel.setLayoutData((Object)new GridData(128));
        this.userNameText = new Text(settingsGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.userNameText.setLayoutData((Object)gd);
        this.createEmptyLabel(settingsGroup, 1);
        this.passwordLabel = new Label(settingsGroup, 0);
        this.passwordLabel.setText(SQLServerMessages.dialog_connection_password_label);
        this.passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text(settingsGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.createEmptyLabel(settingsGroup, 1);
        Group secureGroup = new Group(settingsGroup, 0);
        secureGroup.setText(SQLServerMessages.dialog_setting_connection_settings);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        secureGroup.setLayoutData((Object)gd);
        secureGroup.setLayout((Layout)new GridLayout(2, false));
        this.showAllSchemas = UIUtils.createCheckbox((Composite)secureGroup, (String)SQLServerMessages.dialog_setting_show_all_schemas, (String)SQLServerMessages.dialog_setting_show_all_schemas_tip, (boolean)true, (int)2);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    private void enableTexts() {
        boolean isWindowsAuth = this.windowsAuthenticationButton != null && this.windowsAuthenticationButton.getSelection();
        this.userNameLabel.setEnabled(!isWindowsAuth);
        this.userNameText.setEnabled(!isWindowsAuth);
        this.passwordLabel.setEnabled(!isWindowsAuth);
        this.passwordText.setEnabled(!isWindowsAuth);
    }

    private void createEmptyLabel(Composite parent, int verticalSpan) {
        Label emptyLabel = new Label(parent, 0);
        GridData gd = new GridData(128);
        gd.horizontalSpan = 2;
        gd.verticalSpan = verticalSpan;
        gd.widthHint = 0;
        emptyLabel.setLayoutData((Object)gd);
    }

    public boolean isComplete() {
        return this.hostText != null && !CommonUtils.isEmpty((String)this.hostText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        boolean isSqlServer = SQLServerUtils.isDriverSqlServer(this.getSite().getDriver());
        if (!this.activated) {
            this.setImageDescriptor(isSqlServer ? MSSQL_LOGO_IMG : SYBASE_LOGO_IMG);
        }
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText("localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = this.getSite().isNew() ? "master" : "";
            }
            this.dbText.setText(databaseName);
        }
        if (this.userNameText != null) {
            this.userNameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        if (this.windowsAuthenticationButton != null) {
            this.windowsAuthenticationButton.setSelection(SQLServerUtils.isWindowsAuth(connectionInfo));
            this.enableTexts();
        }
        this.showAllSchemas.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-show-all-schemas@")));
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.userNameText != null) {
            connectionInfo.setUserName(this.userNameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        if (this.windowsAuthenticationButton != null) {
            connectionInfo.getProperties().put("integratedSecurity", String.valueOf(this.windowsAuthenticationButton.getSelection()));
        }
        if (this.showAllSchemas != null) {
            connectionInfo.setProviderProperty("@dbeaver-show-all-schemas@", String.valueOf(this.showAllSchemas.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

