/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ExasolCreateSchemaDialog
extends BaseDialog {
    private List<ExasolGrantee> grantees;
    private String name;
    private ExasolDataSource datasource;
    private ExasolGrantee owner;

    public ExasolCreateSchemaDialog(Shell parentShell, ExasolDataSource datasource) {
        super(parentShell, "Create schema", null);
        this.datasource = datasource;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)"Schema Name", (String)"");
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExasolCreateSchemaDialog.this.name = nameText.getText();
                ExasolCreateSchemaDialog.this.getButton(0).setEnabled(!ExasolCreateSchemaDialog.this.name.isEmpty());
            }
        });
        final Combo userCombo = UIUtils.createLabelCombo((Composite)group, (String)"Owner", (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolCreateSchemaDialog.this.owner = (ExasolGrantee)ExasolCreateSchemaDialog.this.grantees.get(userCombo.getSelectionIndex());
            }
        });
        new AbstractJob("Load users"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    ExasolCreateSchemaDialog.this.grantees = new ArrayList<ExasolGrantee>(ExasolCreateSchemaDialog.this.datasource.getAllGrantees(monitor));
                    DBeaverUI.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (ExasolGrantee grantee : ExasolCreateSchemaDialog.this.grantees) {
                                String name = grantee.getName();
                                userCombo.add(name);
                            }
                        }
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public ExasolGrantee getOwner() {
        return this.owner;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

