/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools.maintenance;

import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.impl.local.LocalResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.sql.GenerateMultiSQLDialog;
import org.jkiss.dbeaver.ui.dialogs.sql.SQLScriptProgressListener;
import org.jkiss.dbeaver.ui.dialogs.sql.SQLScriptStatusDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ExasolBaseTableToolDialog
extends GenerateMultiSQLDialog<ExasolTableBase> {
    private static final String VARIABLE_DATE = "date";
    private static final String VARIABLE_TABLE = "table";
    private static final String VARIABLE_SCHEMA = "schema";

    ExasolBaseTableToolDialog(IWorkbenchPartSite partSite, String title, Collection<ExasolTableBase> objects) {
        super(partSite, title, objects, true);
    }

    protected int getNumberExtraResultingColumns() {
        return 0;
    }

    protected String replaceVars(String input, final ExasolTableBase table) {
        String outString = GeneralUtils.replaceVariables((String)input, (GeneralUtils.IVariableResolver)new GeneralUtils.IVariableResolver(){

            public String get(String name) {
                switch (name) {
                    case "table": {
                        return table.getName();
                    }
                    case "schema": {
                        return ((ExasolSchema)table.getContainer()).getName();
                    }
                    case "date": {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        Calendar cal = Calendar.getInstance();
                        return dateFormat.format(cal.getTime());
                    }
                }
                System.getProperty(name);
                return null;
            }
        });
        return outString;
    }

    protected SQLScriptProgressListener<ExasolTableBase> getScriptListener() {
        final int nbExtraColumns = this.getNumberExtraResultingColumns();
        return new SQLScriptStatusDialog<ExasolTableBase>(String.valueOf(this.getTitle()) + " " + ExasolMessages.dialog_table_tools_progress, null){

            protected void createStatusColumns(Tree objectTree) {
                TreeColumn msgColumn = new TreeColumn(objectTree, 0);
                msgColumn.setText(ExasolMessages.dialog_table_tools_result);
                int i = 0;
                while (i < nbExtraColumns) {
                    new TreeColumn(objectTree, 0);
                    ++i;
                }
            }

            public void endObjectProcessing(@NotNull ExasolTableBase exasolTable, Exception exception) {
                TreeItem treeItem = this.getTreeItem(exasolTable);
                if (exception == null) {
                    treeItem.setText(1, ExasolMessages.dialog_table_tools_success_title);
                } else {
                    treeItem.setText(1, exception.getMessage());
                }
                UIUtils.packColumns((Tree)treeItem.getParent(), (boolean)false, null);
            }

            public void processObjectResults(@NotNull ExasolTableBase exasolTable, @Nullable DBCStatement statement, @Nullable DBCResultSet resultSet) throws DBCException {
                if (resultSet == null) {
                    return;
                }
                DBCResultSetMetaData rsMetaData = resultSet.getMeta();
                try {
                    TreeItem treeItem = this.getTreeItem(exasolTable);
                    Font f = UIUtils.makeBoldFont((Font)treeItem.getFont());
                    if (treeItem != null) {
                        TreeItem subItem = null;
                        subItem = new TreeItem(treeItem, 0);
                        subItem.setFont(f);
                        for (DBCAttributeMetaData column : rsMetaData.getAttributes()) {
                            subItem.setText(column.getOrdinalPosition(), column.getName());
                            subItem.setGrayed(true);
                        }
                        while (resultSet.nextRow()) {
                            subItem = new TreeItem(treeItem, 0);
                            int i = 0;
                            while (i < rsMetaData.getAttributes().size()) {
                                subItem.setText(i, CommonUtils.toString((Object)resultSet.getAttributeValue(i)));
                                ++i;
                                ++i;
                            }
                        }
                        treeItem.setExpanded(true);
                    }
                }
                catch (Exception e) {
                    throw new DBCException(e.getMessage());
                }
            }
        };
    }

    protected void executeSQL() {
        final String jobName = this.getShell().getText();
        final SQLScriptProgressListener<ExasolTableBase> scriptListener = this.getScriptListener();
        final List objects = this.getCheckedObjects();
        final LinkedHashMap objectsSQL = new LinkedHashMap();
        for (ExasolTableBase object : objects) {
            ArrayList lines = new ArrayList();
            this.generateObjectCommand(lines, object);
            objectsSQL.put(object, lines);
        }
        DataSourceJob job = new DataSourceJob(jobName, this.getExecutionContext()){
            public Exception objectProcessingError;

            protected IStatus run(DBRProgressMonitor monitor) {
                final 3 curJob = this;
                DBeaverUI.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        scriptListener.beginScriptProcessing((Job)curJob, (Collection)objects);
                    }
                });
                monitor.beginTask(jobName, objects.size());
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, jobName);){
                        int i = 0;
                        while (i < objects.size()) {
                            block30: {
                                if (monitor.isCanceled()) {
                                    break;
                                }
                                final int objectNumber = i;
                                final ExasolTableBase object = (ExasolTableBase)objects.get(i);
                                monitor.subTask("Process " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
                                this.objectProcessingError = null;
                                DBeaverUI.asyncExec((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        scriptListener.beginObjectProcessing((DBSObject)object, objectNumber);
                                    }
                                });
                                try {
                                    try {
                                        List lines = (List)objectsSQL.get(object);
                                        for (String line : lines) {
                                            Throwable throwable2 = null;
                                            Object var13_17 = null;
                                            try {
                                                Statement statement = ((JDBCSession)session).getOriginal().createStatement();
                                                try {
                                                    int affectedRows = statement.executeUpdate(line);
                                                    Object[] resultSetData = new Integer[]{affectedRows};
                                                    final LocalResultSet resultSet = new LocalResultSet(session, (DBCStatement)new JDBCStatementImpl((JDBCSession)session, statement, true));
                                                    resultSet.addColumn("ROWS_AFFECTED", DBPDataKind.NUMERIC);
                                                    resultSet.addRow(resultSetData);
                                                    DBeaverUI.syncExec((Runnable)new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            try {
                                                                scriptListener.processObjectResults((DBSObject)object, null, (DBCResultSet)resultSet);
                                                            }
                                                            catch (DBCException e) {
                                                                objectProcessingError = e;
                                                            }
                                                        }
                                                    });
                                                    if (this.objectProcessingError == null) continue;
                                                    break;
                                                }
                                                catch (Throwable throwable3) {
                                                    throw throwable3;
                                                }
                                                finally {
                                                    if (statement != null) {
                                                        statement.close();
                                                    }
                                                    break;
                                                }
                                            }
                                            catch (Throwable throwable4) {
                                                if (throwable2 == null) {
                                                    throwable2 = throwable4;
                                                } else if (throwable2 != throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                                throw throwable2;
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        this.objectProcessingError = e;
                                        DBeaverUI.asyncExec((Runnable)new Runnable(scriptListener, object){
                                            private final /* synthetic */ SQLScriptProgressListener val$scriptListener;
                                            private final /* synthetic */ ExasolTableBase val$object;
                                            {
                                                this.val$scriptListener = sQLScriptProgressListener;
                                                this.val$object = exasolTableBase;
                                            }

                                            @Override
                                            public void run() {
                                                this.val$scriptListener.endObjectProcessing((DBSObject)this.val$object, objectProcessingError);
                                            }
                                        });
                                        break block30;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    DBeaverUI.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                                    throw throwable5;
                                }
                                DBeaverUI.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    DBeaverUI.asyncExec((Runnable)new Runnable(scriptListener){
                        private final /* synthetic */ SQLScriptProgressListener val$scriptListener;
                        {
                            this.val$scriptListener = sQLScriptProgressListener;
                        }

                        @Override
                        public void run() {
                            this.val$scriptListener.endScriptProcessing();
                        }
                    });
                    throw throwable;
                }
                monitor.done();
                DBeaverUI.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
            }
        });
        job.schedule();
    }
}

