/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.app.ExasolServerSession;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolUtils {
    private static final String TABLE_QUERY_COLUMNS = "SELECT * FROM EXA_ALL_COLUMNS WHERE COLUMN_SCHEMA='%s' AND COLUMN_TABLE='%s' ORDER BY COLUMN_ORDINAL_POSITION";
    private static final String SESS_DBA_QUERY = "select * from exa_dba_sessions";
    private static final String SESS_ALL_QUERY = "select * from exa_ALL_sessions";
    private static final Log LOG = Log.getLog(ExasolUtils.class);

    public static String quoteString(String input) {
        return input.replaceAll("'", "''");
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf((si ? "kMGTPE" : "KMGTPE").charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String generateDDLforTable(DBRProgressMonitor monitor, ExasolDataSource dataSource, ExasolTable exasolTable) throws DBException {
        StringBuilder ddlOutput = new StringBuilder();
        ddlOutput.append("CREATE TABLE \"" + exasolTable.getSchema().getName() + "\".\"" + exasolTable.getName() + "\" (");
        try {
            String string;
            block35: {
                Throwable throwable = null;
                Object var5_7 = null;
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Get Table DDL");
                try {
                    Collection<ExasolTableForeignKey> fks;
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        JDBCResultSet rs = dbStat.executeQuery(String.format(TABLE_QUERY_COLUMNS, ExasolUtils.quoteString(exasolTable.getSchema().getName()), ExasolUtils.quoteString(exasolTable.getName())));
                        ArrayList<String> columns = new ArrayList<String>();
                        ArrayList<String> distKey = new ArrayList<String>();
                        while (rs.next()) {
                            StringBuilder columnString = new StringBuilder("");
                            columnString.append("\n\t\t\"" + rs.getString("COLUMN_NAME") + "\" " + rs.getString("COLUMN_TYPE") + " ");
                            if (rs.getString("COLUMN_DEFAULT") != null) {
                                columnString.append("DEFAULT " + rs.getString("COLUMN_DEFAULT") + " ");
                            }
                            if (rs.getBigDecimal("COLUMN_IDENTITY") != null) {
                                columnString.append("IDENTITY " + rs.getBigDecimal("COLUMN_IDENTITY").toString() + " ");
                            }
                            if (!rs.getBoolean("COLUMN_IS_NULLABLE")) {
                                columnString.append("NOT NULL ");
                            }
                            if (rs.getString("COLUMN_COMMENT") != null) {
                                columnString.append("COMMENT IS '" + rs.getString("COLUMN_COMMENT").replaceAll("'", "''") + "'");
                            }
                            if (rs.getBoolean("COLUMN_IS_DISTRIBUTION_KEY")) {
                                distKey.add(rs.getString("COLUMN_NAME"));
                            }
                            columns.add(columnString.toString());
                        }
                        ddlOutput.append(CommonUtils.joinStrings((String)",", columns));
                        if (distKey.size() > 0) {
                            ddlOutput.append(",\n\t\t DISTRIBUTE BY " + CommonUtils.joinStrings((String)",", distKey));
                        }
                        ddlOutput.append("\n);\n");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    Collection<ExasolTableUniqueKey> pks = exasolTable.getConstraints(monitor);
                    if (pks != null & pks.size() > 0) {
                        ExasolTableUniqueKey pk = null;
                        pk = pks.iterator().next();
                        ddlOutput.append("\n" + ExasolUtils.getPKDdl(pk, monitor) + ";\n");
                    }
                    if ((fks = exasolTable.getAssociations(monitor)) != null & fks.size() > 0) {
                        for (ExasolTableForeignKey fk : fks) {
                            ddlOutput.append("\n" + ExasolUtils.getFKDdl(fk, monitor) + ";\n");
                        }
                    }
                    string = ddlOutput.toString();
                    if (session == null) break block35;
                }
                catch (Throwable throwable4) {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        try {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new DBException((Throwable)e, (DBPDataSource)dataSource);
                        }
                    }
                }
                session.close();
            }
            monitor.done();
            return string;
        }
        catch (Throwable throwable) {
            monitor.done();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getFKDdl(ExasolTableForeignKey fk, DBRProgressMonitor monitor) throws DBException {
        void var5_11;
        ExasolTable exasolTable = (ExasolTable)fk.getTable();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> refColumns = new ArrayList<String>();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getAttributeReferences(monitor)) {
            columns.add(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttributeRef.getAttribute()));
        }
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getReferencedConstraint().getAttributeReferences(monitor)) {
            refColumns.add(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttributeRef.getAttribute()));
        }
        String string = " DISABLE ";
        if (fk.getEnabled().booleanValue()) {
            String string2 = " ENABLE ";
        }
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)exasolTable, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)fk) + " FOREIGN KEY (" + CommonUtils.joinStrings((String)",", columns) + ") REFERENCES " + DBUtils.getObjectFullName((DBPNamedObject)fk.getAssociatedEntity(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " (" + CommonUtils.joinStrings((String)",", refColumns) + ")" + (String)var5_11;
    }

    public static String getPKDdl(ExasolTableUniqueKey pk, DBRProgressMonitor monitor) throws DBException {
        ExasolTable exasolTable = pk.getTable();
        ArrayList<String> columns = new ArrayList<String>();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : pk.getAttributeReferences(monitor)) {
            columns.add("\"" + dBSEntityAttributeRef.getAttribute().getName() + "\"");
        }
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)exasolTable, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)pk) + " PRIMARY KEY (" + CommonUtils.joinStrings((String)",", columns) + ") " + (pk.getEnabled() != false ? " ENABLE " : " DISABLE ");
    }

    public static String getConnectionDdl(ExasolConnection con, DBRProgressMonitor monitor) throws DBException {
        String userInfo = "";
        if (con.getUserName() != null) {
            userInfo = " USER '" + con.getUserName() + "' IDENTIFIED BY '<password>' ";
        }
        return "CREATE CONNECTION \"" + con.getName() + "\" to '" + con.getConnectionString() + "'" + userInfo + ";";
    }

    private ExasolUtils() {
    }

    public static ExasolTable findTableBySchemaNameAndName(DBRProgressMonitor monitor, ExasolDataSource dataSource, String exasolSchemaName, String exasolTableName) throws DBException {
        ExasolSchema exasolSchema = dataSource.getSchema(monitor, exasolSchemaName);
        if (exasolSchema == null) {
            return null;
        }
        return exasolSchema.getTable(monitor, exasolTableName);
    }

    public static Collection<ExasolServerSession> readSessions(DBRProgressMonitor progressMonitor, JDBCSession session) throws SQLException {
        LOG.debug((Object)"read sessions");
        ArrayList<ExasolServerSession> listSessions = new ArrayList<ExasolServerSession>();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable2 = null;
                Object var7_17 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(SESS_DBA_QUERY);){
                    while (dbResult.next()) {
                        listSessions.add(new ExasolServerSession((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            Throwable throwable = null;
            Object var4_9 = null;
            try (JDBCStatement dbStat = session.createStatement();){
                Throwable throwable5 = null;
                Object var7_19 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery(SESS_ALL_QUERY);){
                    while (dbResult.next()) {
                        listSessions.add(new ExasolServerSession((ResultSet)dbResult));
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable5 == null) {
                        throwable5 = throwable6;
                    } else if (throwable5 != throwable6) {
                        throwable5.addSuppressed(throwable6);
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        return listSessions;
    }

    public static String generateDDLforSchema(DBRProgressMonitor monitor, ExasolSchema exasolSchema) {
        String retStr = "CREATE SCHEMA " + exasolSchema.getName() + ";\n" + "ALTER SCHEMA " + exasolSchema.getName() + " CHANGE OWNER " + exasolSchema.getOwner() + ";\n";
        return retStr;
    }
}

