/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableKeyColumn;
import org.jkiss.dbeaver.ext.exasol.model.cache.ExasolTableCache;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public final class ExasolTableForeignKeyCache
extends JDBCCompositeCache<ExasolSchema, ExasolTable, ExasolTableForeignKey, ExasolTableKeyColumn> {
    private static final String SQL_FK_TAB = "select\r\n\t\tCONSTRAINT_NAME,CONSTRAINT_TABLE,CONSTRAINT_SCHEMA,constraint_owner,c.constraint_enabled,constraint_Type,cc.column_name,cc.ordinal_position,cc.referenced_schema,cc.referenced_table,cc.referenced_column,PK.CONSTRAINT_NAME AS REF_PK_NAME\r\n\tfrom\r\n\t\t\tEXA_ALL_CONSTRAINTS c\r\n\t\tinner join\r\n\t\t\tEXA_ALL_CONSTRAINT_COLUMNS cc\r\n\tusing\r\n\t\t\t(\r\n\t\t\t\tCONSTRAINT_SCHEMA, CONSTRAINT_TABLE, CONSTRAINT_NAME, CONSTRAINT_OWNER, CONSTRAINT_TYPE\r\n\t\t\t)\r\n\t\tinner join \r\n\t\t\tEXA_ALL_CONSTRAINTS pk\r\n    on REFERENCED_SCHEMA = PK.CONSTRAINT_SCHEMA AND REFERENCED_TABLE = PK.CONSTRAINT_TABLE AND PK.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\twhere\r\n\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\tCONSTRAINT_TYPE = 'FOREIGN KEY'AND CONSTRAINT_TABLE = '%s' \r\n\torder by\r\n\t\tORDINAL_POSITION";
    private static final String SQL_FK_ALL = "select\r\n\t\tCONSTRAINT_NAME,CONSTRAINT_TABLE,CONSTRAINT_SCHEMA,constraint_owner,c.constraint_enabled,constraint_Type,cc.column_name,cc.ordinal_position,cc.referenced_schema,cc.referenced_table,cc.referenced_column,PK.CONSTRAINT_NAME AS REF_PK_NAME\r\n\tfrom\r\n\t\t\tEXA_ALL_CONSTRAINTS c\r\n\t\tinner join\r\n\t\t\tEXA_ALL_CONSTRAINT_COLUMNS cc\r\n\tusing\r\n\t\t\t(\r\n\t\t\t\tCONSTRAINT_SCHEMA, CONSTRAINT_TABLE, CONSTRAINT_NAME, CONSTRAINT_OWNER, CONSTRAINT_TYPE\r\n\t\t\t)\r\n\t\tinner join \r\n\t\t\tEXA_ALL_CONSTRAINTS pk\r\n    on REFERENCED_SCHEMA = PK.CONSTRAINT_SCHEMA AND REFERENCED_TABLE = PK.CONSTRAINT_TABLE AND PK.CONSTRAINT_TYPE = 'PRIMARY KEY'\r\n\twhere\r\n\t\tCONSTRAINT_SCHEMA = '%s' and\r\n\t\tCONSTRAINT_TYPE = 'FOREIGN KEY' \r\n\torder by\r\n\t\tORDINAL_POSITION";

    public ExasolTableForeignKeyCache(ExasolTableCache tableCache) {
        super((JDBCStructCache)tableCache, ExasolTable.class, (Object)"CONSTRAINT_TABLE", (Object)"CONSTRAINT_NAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(JDBCSession session, ExasolSchema exasolSchema, ExasolTable forTable) throws SQLException {
        String sql = forTable != null ? String.format(SQL_FK_TAB, ExasolUtils.quoteString(exasolSchema.getName()), ExasolUtils.quoteString(forTable.getName())) : String.format(SQL_FK_ALL, ExasolUtils.quoteString(exasolSchema.getName()));
        JDBCStatement dbStat = session.createStatement();
        ((JDBCStatementImpl)dbStat).setQueryString(sql);
        return dbStat;
    }

    @Nullable
    protected ExasolTableForeignKey fetchObject(JDBCSession session, ExasolSchema ExasolSchema2, ExasolTable ExasolTable2, String constName, JDBCResultSet dbResult) throws SQLException, DBException {
        return new ExasolTableForeignKey(session.getProgressMonitor(), ExasolTable2, (ResultSet)dbResult);
    }

    @Nullable
    protected ExasolTableKeyColumn[] fetchObjectRow(JDBCSession session, ExasolTable ExasolTable2, ExasolTableForeignKey object, JDBCResultSet dbResult) throws SQLException, DBException {
        String colName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
        ExasolTableColumn tableColumn = ExasolTable2.getAttribute(session.getProgressMonitor(), colName);
        if (tableColumn == null) {
            log.info((Object)("ExasolTableForeignKeyCache : Column '" + colName + "' not found in table '" + ExasolTable2.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        return new ExasolTableKeyColumn[]{new ExasolTableKeyColumn((AbstractTableConstraint<ExasolTable>)object, tableColumn, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ORDINAL_POSITION"))};
    }

    protected void cacheChildren(DBRProgressMonitor monitor, ExasolTableForeignKey constraint, List<ExasolTableKeyColumn> rows) {
        constraint.setColumns(rows);
    }
}

