/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager.security;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolGrantee;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ExasolUser
extends ExasolGrantee
implements DBAUser,
DBPSaveableObject,
DBPNamedObject2,
DBPRefreshableObject {
    private ExasolDataSource dataSource;
    private String userName;
    private String description;
    private String dn;
    private String password;
    private String priority;
    private Timestamp created;

    public ExasolUser(ExasolDataSource dataSource, ResultSet resultSet) {
        super(dataSource, resultSet);
        this.dataSource = dataSource;
        if (resultSet != null) {
            this.userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_NAME");
            this.description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_COMMENT");
            this.dn = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"DISTINGUISHED_NAME");
            this.password = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"PASSWORD");
            this.priority = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USER_PRIORITY");
            this.created = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CREATED");
        } else {
            this.userName = "user";
            this.description = "";
            this.dn = "";
            this.password = "";
            this.priority = "";
            this.created = null;
        }
    }

    public ExasolUser(ExasolDataSource datasource, String name, String description, String dn, String password) {
        super(datasource, false);
        this.dataSource = datasource;
        this.userName = name;
        this.description = description;
        this.dn = dn;
        this.password = password;
        this.priority = "";
    }

    @Property(viewable=true, updatable=true, editable=true, order=100)
    public String getDescription() {
        return this.description;
    }

    @Property(viewable=true, editable=true, updatable=true, order=20)
    public String getPassword() {
        return this.password;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public String getDn() {
        return this.dn;
    }

    @Property(viewable=true, order=40)
    public String getPriority() {
        return this.priority;
    }

    @Property(viewable=true, order=50)
    public Timestamp getCreated() {
        return this.created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @Override
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.userName;
    }

    public void setName(String newName) {
        this.userName = newName;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
        this.dn = "";
    }

    public void setDN(String dn) {
        this.dn = dn;
        this.password = "";
    }

    @Override
    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public String toString() {
        return "User " + this.getName();
    }
}

