/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolCreateSchemaDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;

public class ExasolSchemaManager
extends SQLObjectEditor<ExasolSchema, ExasolDataSource>
implements DBEObjectRenamer<ExasolSchema> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<? extends DBSObject, ExasolSchema> getObjectsCache(ExasolSchema object) {
        ExasolDataSource source = (ExasolDataSource)object.getDataSource();
        return source.getSchemaCache();
    }

    protected ExasolSchema createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final ExasolDataSource parent, Object copyFrom) throws DBException {
        return (ExasolSchema)new UITask<ExasolSchema>(){

            protected ExasolSchema runTask() {
                ExasolCreateSchemaDialog dialog = new ExasolCreateSchemaDialog(DBeaverUI.getActiveWorkbenchShell(), parent);
                if (dialog.open() != 0) {
                    return null;
                }
                return new ExasolSchema(parent, dialog.getName(), dialog.getOwner().getName());
            }
        }.execute();
    }

    private void changeOwner(List<DBEPersistAction> actions, ExasolSchema schema, String owner) {
        String script = "ALTER SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " CHANGE OWNER  " + owner;
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set schema Owner", script));
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolSchema schema = (ExasolSchema)command.getObject();
        String script = "CREATE SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create schema", script));
        String owner = schema.getOwner();
        if (owner != null) {
            this.changeOwner(actions, schema, owner);
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        int result = (Integer)new UITask<Integer>(){

            protected Integer runTask() {
                ConfirmationDialog dialog = new ConfirmationDialog(DBeaverUI.getActiveWorkbenchShell(), ExasolMessages.dialog_schema_drop_title, null, ExasolMessages.dialog_schema_drop_message, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, ExasolMessages.dialog_general_continue, false);
                return dialog.open();
            }
        }.execute();
        if (result != 2) {
            throw new IllegalStateException("User abort");
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop schema", "DROP SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " CASCADE"));
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolSchema obj = (ExasolSchema)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Schema", "RENAME SCHEMA " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    public void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolSchema schema = (ExasolSchema)command.getObject();
        if (command.getProperties().size() >= 1) {
            if (command.getProperties().containsKey("description")) {
                String script = "COMMENT ON SCHEMA " + DBUtils.getQuotedIdentifier((DBSObject)schema) + " IS '" + ExasolUtils.quoteString(schema.getDescription()) + "'";
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Change comment on Schema", script));
            }
            if (command.getProperties().containsKey("owner")) {
                this.changeOwner(actionList, schema, schema.getOwner());
            }
        }
    }

    public void renameObject(DBECommandContext commandContext, ExasolSchema object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }
}

