/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.metadata;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataParams;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataResult;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SearchMetadataQuery
implements ISearchQuery {
    private static final Log log = Log.getLog(SearchMetadataQuery.class);
    private final DBSStructureAssistant structureAssistant;
    private final SearchMetadataParams params;
    private SearchMetadataResult searchResult;

    private SearchMetadataQuery(DBSStructureAssistant structureAssistant, SearchMetadataParams params) {
        this.structureAssistant = structureAssistant;
        this.params = params;
    }

    public String getLabel() {
        return this.params.getObjectNameMask();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new SearchMetadataResult(this);
        }
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            List<DBSObjectType> objectTypes = this.params.getObjectTypes();
            String objectNameMask = this.params.getObjectNameMask();
            if (this.params.getMatchType() == 0) {
                if (!objectNameMask.endsWith("%")) {
                    objectNameMask = String.valueOf(objectNameMask) + "%";
                }
            } else if (this.params.getMatchType() == 1) {
                if (!objectNameMask.startsWith("%")) {
                    objectNameMask = "%" + objectNameMask;
                }
                if (!objectNameMask.endsWith("%")) {
                    objectNameMask = String.valueOf(objectNameMask) + "%";
                }
            }
            DBNModel navigatorModel = DBeaverCore.getInstance().getNavigatorModel();
            DBRProgressMonitor localMonitor = RuntimeUtils.makeMonitor((IProgressMonitor)monitor);
            List objects = this.structureAssistant.findObjectsByMask(localMonitor, this.params.getParentObject(), objectTypes.toArray(new DBSObjectType[objectTypes.size()]), objectNameMask, this.params.isCaseSensitive(), true, this.params.getMaxResults());
            for (DBSObjectReference reference : objects) {
                if (monitor.isCanceled()) break;
                try {
                    DBNDatabaseNode node;
                    DBSObject object = reference.resolveObject(localMonitor);
                    if (object == null || (node = navigatorModel.getNodeByObject(localMonitor, object, false)) == null) continue;
                    this.searchResult.addObjects(Collections.singletonList(node));
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            return Status.OK_STATUS;
        }
        catch (DBException e) {
            return GeneralUtils.makeExceptionStatus((Throwable)e);
        }
    }

    public static SearchMetadataQuery createQuery(DBPDataSource dataSource, SearchMetadataParams params) throws DBException {
        DBSStructureAssistant assistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
        if (dataSource == null || assistant == null) {
            throw new DBException("Can't obtain database structure assistance from [" + dataSource + "]");
        }
        return new SearchMetadataQuery(assistant, params);
    }
}

