/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarkStorage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DBNBookmark
extends DBNResource {
    private BookmarkStorage storage;

    public DBNBookmark(DBNNode parentNode, IResource resource, DBPResourceHandler handler) throws DBException, CoreException {
        super(parentNode, resource, handler);
        this.storage = new BookmarkStorage((IFile)resource, true);
    }

    protected void dispose(boolean reflect) {
        this.storage.dispose();
        super.dispose(reflect);
    }

    public String getNodeName() {
        return this.storage.getTitle();
    }

    public String getNodeDescription() {
        String dsInfo = "";
        Collection<DBPDataSourceContainer> dataSources = this.getAssociatedDataSources();
        if (!CommonUtils.isEmpty(dataSources)) {
            DBPDataSourceContainer dataSource = dataSources.iterator().next();
            dsInfo = " ('" + dataSource.getName() + "' - " + dataSource.getDriver().getName() + ")";
        }
        return String.valueOf(this.storage.getDescription()) + dsInfo;
    }

    public DBPImage getNodeIcon() {
        return this.storage.getImage();
    }

    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        IFile file = (IFile)this.getResource();
        if (file != null) {
            try {
                this.storage.setTitle(newName);
                ByteArrayInputStream data = this.storage.serialize();
                file.setContents((InputStream)data, true, false, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
            }
            catch (Exception e) {
                throw new DBException("Can't rename bookmark", (Throwable)e);
            }
        }
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        DataSourceDescriptor dataSource;
        DataSourceRegistry dataSourceRegistry;
        IResource resource = this.getResource();
        if (resource != null && (dataSourceRegistry = DBeaverCore.getInstance().getProjectRegistry().getDataSourceRegistry(resource.getProject())) != null && (dataSource = dataSourceRegistry.getDataSource(this.storage.getDataSourceId())) != null) {
            return Collections.singleton(dataSource);
        }
        return null;
    }
}

