/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.sql.SQLFormatterConfigurationRegistry;
import org.jkiss.dbeaver.registry.sql.SQLFormatterDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageSQLFormat
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.format";
    private static final String FORMAT_FILE_NAME = "format_preview.sql";
    private Button acSingleQuotesCheck;
    private Button acDoubleQuotesCheck;
    private Button acBracketsCheck;
    private Button afKeywordCase;
    private Button afExtractFromSource;
    private Combo formatterSelector;
    private Combo keywordCaseCombo;
    private Text externalCmdText;
    private Button externalUseFile;
    private Spinner externalTimeout;
    private SQLEditorBase sqlViewer;
    private Composite defaultGroup;
    private Composite externalGroup;
    private List<SQLFormatterDescriptor> formatters;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("SQLEditor.closeSingleQuotes") || store.contains("SQLEditor.closeDoubleQuotes") || store.contains("SQLEditor.closeBrackets") || store.contains("SQLEditor.format.keywordCaseAuto") || store.contains("SQLEditor.format.extractFromSource") || store.contains("sql.format.formatter") || store.contains("sql.format.keywordCase") || store.contains("sql.format.external.cmd") || store.contains("sql.format.external.file") || store.contains("sql.format.external.timeout");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 2, 5);
        Group acGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_format_group_auto_close, 1, 770, 0);
        this.acSingleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, CoreMessages.pref_page_sql_format_label_single_quotes, false);
        this.acDoubleQuotesCheck = UIUtils.createCheckbox((Composite)acGroup, CoreMessages.pref_page_sql_format_label_double_quotes, false);
        this.acBracketsCheck = UIUtils.createCheckbox((Composite)acGroup, CoreMessages.pref_page_sql_format_label_brackets, false);
        Group afGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_format_group_auto_format, 1, 770, 0);
        this.afKeywordCase = UIUtils.createCheckbox((Composite)afGroup, CoreMessages.pref_page_sql_format_label_convert_keyword_case, CoreMessages.pref_page_sql_format_label_convert_keyword_case_tip, false, 1);
        this.afExtractFromSource = UIUtils.createCheckbox((Composite)afGroup, CoreMessages.pref_page_sql_format_label_extract_sql_from_source_code, CoreMessages.pref_page_sql_format_label_extract_sql_from_source_code_tip, false, 1);
        Group formatterGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_format_group_formatter, 1, 1808, 0);
        ((GridData)formatterGroup.getLayoutData()).horizontalSpan = 2;
        Composite formatterPanel = UIUtils.createPlaceholder((Composite)formatterGroup, 2);
        formatterPanel.setLayoutData((Object)new GridData(768));
        this.formatterSelector = UIUtils.createLabelCombo(formatterPanel, CoreMessages.pref_page_sql_format_label_formatter, 12);
        this.formatters = SQLFormatterConfigurationRegistry.getInstance().getFormatters();
        for (SQLFormatterDescriptor formatterDesc2 : this.formatters) {
            this.formatterSelector.add(DBPIdentifierCase.capitalizeCaseName((String)formatterDesc2.getLabel()));
        }
        this.formatterSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLFormat.this.showFormatterSettings();
                PrefPageSQLFormat.this.performApply();
            }
        });
        this.formatterSelector.setLayoutData((Object)new GridData(32));
        this.defaultGroup = UIUtils.createPlaceholder((Composite)formatterGroup, 2, 0);
        this.defaultGroup.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo = UIUtils.createLabelCombo(this.defaultGroup, CoreMessages.pref_page_sql_format_label_keyword_case, 12);
        this.keywordCaseCombo.setLayoutData((Object)new GridData(32));
        this.keywordCaseCombo.add("Database");
        DBPIdentifierCase[] dBPIdentifierCaseArray = DBPIdentifierCase.values();
        int n = dBPIdentifierCaseArray.length;
        int formatterDesc2 = 0;
        while (formatterDesc2 < n) {
            DBPIdentifierCase c = dBPIdentifierCaseArray[formatterDesc2];
            this.keywordCaseCombo.add(DBPIdentifierCase.capitalizeCaseName((String)c.name()));
            ++formatterDesc2;
        }
        this.keywordCaseCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLFormat.this.performApply();
            }
        });
        this.externalGroup = UIUtils.createPlaceholder((Composite)formatterGroup, 2, 5);
        this.externalGroup.setLayoutData((Object)new GridData(800));
        this.externalCmdText = UIUtils.createLabelText(this.externalGroup, CoreMessages.pref_page_sql_format_label_external_command_line, "");
        this.externalCmdText.setLayoutData((Object)new GridData(768));
        UIUtils.installContentProposal((Control)this.externalCmdText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"file")}));
        UIUtils.setContentProposalToolTip((Control)this.externalCmdText, CoreMessages.pref_page_sql_format_label_external_set_content_tool_tip, "file");
        this.externalUseFile = UIUtils.createLabelCheckbox(this.externalGroup, CoreMessages.pref_page_sql_format_label_external_use_temp_file, String.valueOf(CoreMessages.pref_page_sql_format_label_external_use_temp_file_tip) + GeneralUtils.variablePattern((String)"file"), false);
        this.externalTimeout = UIUtils.createLabelSpinner(this.externalGroup, CoreMessages.pref_page_sql_format_label_external_exec_timeout, CoreMessages.pref_page_sql_format_label_external_exec_timeout_tip, 100, 100, 10000);
        Composite previewGroup = new Composite((Composite)formatterGroup, 2048);
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setLayout((Layout)new FillLayout());
        this.sqlViewer = new SQLEditorBase(){

            @Override
            public DBCExecutionContext getExecutionContext() {
                DBPDataSource dataSource;
                DBPDataSourceContainer container = PrefPageSQLFormat.this.getDataSourceContainer();
                if (container != null && (dataSource = container.getDataSource()) != null) {
                    return dataSource.getDefaultContext(false);
                }
                return null;
            }
        };
        try {
            Throwable formatterDesc2 = null;
            Object var6_7 = null;
            try (InputStream sqlStream = ((Object)((Object)this)).getClass().getResourceAsStream(FORMAT_FILE_NAME);){
                String sqlText = ContentUtils.readToString((InputStream)sqlStream, (String)"UTF-8");
                SubEditorSite subSite = new SubEditorSite(DBeaverUI.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
                StringEditorInput sqlInput = new StringEditorInput("SQL preview", sqlText, true, GeneralUtils.getDefaultFileEncoding());
                this.sqlViewer.init(subSite, sqlInput);
            }
            catch (Throwable throwable) {
                if (formatterDesc2 == null) {
                    formatterDesc2 = throwable;
                } else if (formatterDesc2 != throwable) {
                    formatterDesc2.addSuppressed(throwable);
                }
                throw formatterDesc2;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.sqlViewer.createPartControl(previewGroup);
        Control text = this.sqlViewer.getAdapter(Control.class);
        if (text instanceof StyledText) {
            ((StyledText)text).setWordWrap(true);
        }
        this.sqlViewer.reloadSyntaxRules();
        previewGroup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PrefPageSQLFormat.this.sqlViewer.dispose();
            }
        });
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        String caseName;
        this.acSingleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeSingleQuotes"));
        this.acDoubleQuotesCheck.setSelection(store.getBoolean("SQLEditor.closeDoubleQuotes"));
        this.acBracketsCheck.setSelection(store.getBoolean("SQLEditor.closeBrackets"));
        this.afKeywordCase.setSelection(store.getBoolean("SQLEditor.format.keywordCaseAuto"));
        this.afExtractFromSource.setSelection(store.getBoolean("SQLEditor.format.extractFromSource"));
        String formatterId = store.getString("sql.format.formatter");
        int i = 0;
        while (i < this.formatters.size()) {
            if (this.formatters.get(i).getId().equalsIgnoreCase(formatterId)) {
                this.formatterSelector.select(i);
                break;
            }
            ++i;
        }
        if (this.formatterSelector.getSelectionIndex() < 0) {
            this.formatterSelector.select(0);
        }
        if (CommonUtils.isEmpty((String)(caseName = store.getString("sql.format.keywordCase")))) {
            this.keywordCaseCombo.select(0);
        } else {
            UIUtils.setComboSelection(this.keywordCaseCombo, DBPIdentifierCase.capitalizeCaseName((String)caseName));
        }
        this.externalCmdText.setText(store.getString("sql.format.external.cmd"));
        this.externalUseFile.setSelection(store.getBoolean("sql.format.external.file"));
        this.externalTimeout.setSelection(store.getInt("sql.format.external.timeout"));
        this.formatSQL();
        this.showFormatterSettings();
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("SQLEditor.closeSingleQuotes", this.acSingleQuotesCheck.getSelection());
        store.setValue("SQLEditor.closeDoubleQuotes", this.acDoubleQuotesCheck.getSelection());
        store.setValue("SQLEditor.closeBrackets", this.acBracketsCheck.getSelection());
        store.setValue("SQLEditor.format.keywordCaseAuto", this.afKeywordCase.getSelection());
        store.setValue("SQLEditor.format.extractFromSource", this.afExtractFromSource.getSelection());
        store.setValue("sql.format.formatter", this.formatters.get(this.formatterSelector.getSelectionIndex()).getId().toUpperCase(Locale.ENGLISH));
        String caseName = this.keywordCaseCombo.getSelectionIndex() == 0 ? "" : this.keywordCaseCombo.getText().toUpperCase(Locale.ENGLISH);
        store.setValue("sql.format.keywordCase", caseName);
        store.setValue("sql.format.external.cmd", this.externalCmdText.getText());
        store.setValue("sql.format.external.file", this.externalUseFile.getSelection());
        store.setValue("sql.format.external.timeout", this.externalTimeout.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("SQLEditor.closeSingleQuotes");
        store.setToDefault("SQLEditor.closeDoubleQuotes");
        store.setToDefault("SQLEditor.closeBrackets");
        store.setToDefault("SQLEditor.format.keywordCaseAuto");
        store.setToDefault("SQLEditor.format.extractFromSource");
        store.setToDefault("sql.format.formatter");
        store.setToDefault("sql.format.keywordCase");
        store.setToDefault("sql.format.external.cmd");
    }

    @Override
    protected void performApply() {
        super.performApply();
        this.formatSQL();
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    private void showFormatterSettings() {
        SQLFormatterDescriptor selFormatter = this.formatters.get(this.formatterSelector.getSelectionIndex());
        boolean isExternal = selFormatter.getId().equalsIgnoreCase("EXTERNAL");
        this.defaultGroup.setVisible(!isExternal);
        this.externalGroup.setVisible(isExternal);
        ((GridData)this.defaultGroup.getLayoutData()).exclude = isExternal;
        ((GridData)this.externalGroup.getLayoutData()).exclude = !isExternal;
        this.defaultGroup.getParent().layout();
    }

    private void formatSQL() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream sqlStream = ((Object)((Object)this)).getClass().getResourceAsStream(FORMAT_FILE_NAME);){
                String sqlText = ContentUtils.readToString((InputStream)sqlStream, (String)"UTF-8");
                this.sqlViewer.setInput(new StringEditorInput("SQL preview", sqlText, true, GeneralUtils.getDefaultFileEncoding()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.sqlViewer.getTextViewer().doOperation(15);
        this.sqlViewer.reloadSyntaxRules();
    }
}

