/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLEditor
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqleditor";
    public static final String TEXT_EDITOR_PAGE_ID = "org.eclipse.ui.preferencePages.GeneralTextEditor";
    private Button editorSeparateConnectionCheck;
    private Button connectOnActivationCheck;
    private Button connectOnExecuteCheck;
    private Button saveOnQueryExecution;
    private Button autoSaveOnClose;
    private Button deleteEmptyCheck;
    private Button autoFoldersCheck;
    private Button connectionFoldersCheck;
    private Text scriptTitlePattern;
    private Button closeTabOnErrorCheck;
    private Combo resultsOrientationCombo;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.editor.separate.connection") || store.contains("database.editor.connect.on.activate") || store.contains("database.editor.connect.on.execute") || store.contains("SQLEditor.autoSaveOnClose") || store.contains("SQLEditor.autoSaveOnExecute") || store.contains("script.delete.empty") || store.contains("script.auto.folders") || store.contains("SQLEditor.resultSet.closeOnError") || store.contains("SQLEditor.resultSet.orientation");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1);
        Group connectionsGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_editor_group_connections, 1, 770, 0);
        this.editorSeparateConnectionCheck = UIUtils.createCheckbox((Composite)connectionsGroup, CoreMessages.pref_page_sql_editor_label_separate_connection_each_editor, false);
        this.connectOnActivationCheck = UIUtils.createCheckbox((Composite)connectionsGroup, CoreMessages.pref_page_sql_editor_label_connect_on_editor_activation, false);
        this.connectOnExecuteCheck = UIUtils.createCheckbox((Composite)connectionsGroup, CoreMessages.pref_page_sql_editor_label_connect_on_query_execute, false);
        connectionsGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_editor_group_auto_save, 1, 768, 0);
        this.autoSaveOnClose = UIUtils.createCheckbox((Composite)connectionsGroup, CoreMessages.pref_page_sql_editor_label_auto_save_on_close, false);
        this.saveOnQueryExecution = UIUtils.createCheckbox((Composite)connectionsGroup, CoreMessages.pref_page_sql_editor_label_save_on_query_execute, false);
        Group scriptsGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_editor_group_resources, 2, 768, 0);
        ((GridData)scriptsGroup.getLayoutData()).horizontalSpan = 2;
        this.deleteEmptyCheck = UIUtils.createCheckbox((Composite)scriptsGroup, CoreMessages.pref_page_sql_editor_checkbox_delete_empty_scripts, null, false, 2);
        this.autoFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, CoreMessages.pref_page_sql_editor_checkbox_put_new_scripts, null, false, 2);
        this.connectionFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, CoreMessages.pref_page_sql_editor_checkbox_create_script_folders, null, false, 2);
        this.scriptTitlePattern = UIUtils.createLabelText((Composite)scriptsGroup, CoreMessages.pref_page_sql_editor_title_pattern, "");
        UIUtils.installContentProposal((Control)this.scriptTitlePattern, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"connectionName"), GeneralUtils.variablePattern((String)"driverName"), GeneralUtils.variablePattern((String)"fileName"), GeneralUtils.variablePattern((String)"fileExt")}));
        UIUtils.setContentProposalToolTip((Control)this.scriptTitlePattern, "Output file name patterns", "connectionName", "driverName", "fileName", "fileExt");
        Group layoutGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_editor_group_result_view, 2, 768, 0);
        ((GridData)layoutGroup.getLayoutData()).horizontalSpan = 2;
        this.closeTabOnErrorCheck = UIUtils.createCheckbox((Composite)layoutGroup, CoreMessages.pref_page_sql_editor_label_close_results_tab_on_error, null, false, 2);
        this.resultsOrientationCombo = UIUtils.createLabelCombo((Composite)layoutGroup, CoreMessages.pref_page_sql_editor_label_results_orientation, CoreMessages.pref_page_sql_editor_label_results_orientation_tip, 12);
        ((GridData)this.resultsOrientationCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
        int n = resultSetOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
            if (orientation.isSupported()) {
                this.resultsOrientationCombo.add(orientation.getLabel());
            }
            ++n2;
        }
        new PreferenceLinkArea(composite, 0, TEXT_EDITOR_PAGE_ID, "<a>''{0}''</a>" + CoreMessages.pref_page_sql_editor_link_text_editor, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.editorSeparateConnectionCheck.setSelection(store.getBoolean("database.editor.separate.connection"));
            this.connectOnActivationCheck.setSelection(store.getBoolean("database.editor.connect.on.activate"));
            this.connectOnExecuteCheck.setSelection(store.getBoolean("database.editor.connect.on.execute"));
            this.autoSaveOnClose.setSelection(store.getBoolean("SQLEditor.autoSaveOnClose"));
            this.saveOnQueryExecution.setSelection(store.getBoolean("SQLEditor.autoSaveOnExecute"));
            this.deleteEmptyCheck.setSelection(store.getBoolean("script.delete.empty"));
            this.autoFoldersCheck.setSelection(store.getBoolean("script.auto.folders"));
            this.connectionFoldersCheck.setSelection(store.getBoolean("script.auto.connection.folders"));
            this.scriptTitlePattern.setText(store.getString("script.title.pattern"));
            this.closeTabOnErrorCheck.setSelection(store.getBoolean("SQLEditor.resultSet.closeOnError"));
            SQLEditor.ResultSetOrientation orientation = SQLEditor.ResultSetOrientation.valueOf(store.getString("SQLEditor.resultSet.orientation"));
            this.resultsOrientationCombo.setText(orientation.getLabel());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.editor.separate.connection", this.editorSeparateConnectionCheck.getSelection());
            store.setValue("database.editor.connect.on.activate", this.connectOnActivationCheck.getSelection());
            store.setValue("database.editor.connect.on.execute", this.connectOnExecuteCheck.getSelection());
            store.setValue("SQLEditor.autoSaveOnClose", this.autoSaveOnClose.getSelection());
            store.setValue("SQLEditor.autoSaveOnExecute", this.saveOnQueryExecution.getSelection());
            store.setValue("script.delete.empty", this.deleteEmptyCheck.getSelection());
            store.setValue("script.auto.folders", this.autoFoldersCheck.getSelection());
            store.setValue("script.auto.connection.folders", this.connectionFoldersCheck.getSelection());
            store.setValue("script.title.pattern", this.scriptTitlePattern.getText());
            store.setValue("SQLEditor.resultSet.closeOnError", this.closeTabOnErrorCheck.getSelection());
            String orientationLabel = this.resultsOrientationCombo.getText();
            SQLEditor.ResultSetOrientation[] resultSetOrientationArray = SQLEditor.ResultSetOrientation.values();
            int n = resultSetOrientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQLEditor.ResultSetOrientation orientation = resultSetOrientationArray[n2];
                if (orientationLabel.equals(orientation.getLabel())) {
                    store.setValue("SQLEditor.resultSet.orientation", orientation.name());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.editor.separate.connection");
        store.setToDefault("database.editor.connect.on.activate");
        store.setToDefault("database.editor.connect.on.execute");
        store.setToDefault("SQLEditor.autoSaveOnClose");
        store.setToDefault("SQLEditor.autoSaveOnExecute");
        store.setToDefault("script.delete.empty");
        store.setToDefault("script.auto.folders");
        store.setToDefault("script.auto.connection.folders");
        store.setToDefault("script.title.pattern");
        store.setToDefault("SQLEditor.resultSet.closeOnError");
        store.setToDefault("SQLEditor.resultSet.orientation");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

