/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageResultSetMain
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.resultset";
    private Button autoFetchNextSegmentCheck;
    private Spinner resultSetSize;
    private Button resultSetUseSQLCheck;
    private Button serverSideOrderingCheck;
    private Button readQueryMetadata;
    private Button readQueryReferences;
    private Spinner queryCancelTimeout;
    private Button keepStatementOpenCheck;
    private Button alwaysUseAllColumns;
    private Button newRowsAfter;
    private Button refreshAfterUpdate;
    private Button advUseFetchSize;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("resultset.autofetch.next.segment") || store.contains("resultset.maxrows") || store.contains("resultset.maxrows.sql") || store.contains("resultset.read.metadata") || store.contains("resultset.cancel.timeout") || store.contains("resultset.edit.key.use_all_columns") || store.contains("resultset.edit.new.row.after") || store.contains("resultset.edit.refreshAfterUpdate") || store.contains("keep.statement.open") || store.contains("resultset.order.serverSide") || store.contains("resultset.fetch.size");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 2, 5);
        Group queriesGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_database_general_group_queries, 2, 0, 0);
        queriesGroup.setLayoutData((Object)new GridData(2));
        this.resultSetSize = UIUtils.createLabelSpinner((Composite)queriesGroup, CoreMessages.pref_page_database_general_label_result_set_max_size, "", 0, 0, 0x100000);
        this.autoFetchNextSegmentCheck = UIUtils.createCheckbox((Composite)queriesGroup, CoreMessages.pref_page_database_resultsets_label_auto_fetch_segment, null, true, 2);
        this.resultSetUseSQLCheck = UIUtils.createCheckbox((Composite)queriesGroup, CoreMessages.pref_page_database_resultsets_label_use_sql, null, false, 2);
        this.serverSideOrderingCheck = UIUtils.createCheckbox((Composite)queriesGroup, CoreMessages.pref_page_database_resultsets_label_server_side_order, null, false, 2);
        this.readQueryMetadata = UIUtils.createCheckbox((Composite)queriesGroup, CoreMessages.pref_page_database_resultsets_label_read_metadata, CoreMessages.pref_page_database_resultsets_label_read_metadata_tip, false, 2);
        this.readQueryReferences = UIUtils.createCheckbox((Composite)queriesGroup, CoreMessages.pref_page_database_resultsets_label_read_references, CoreMessages.pref_page_database_resultsets_label_read_references_tip, false, 2);
        this.queryCancelTimeout = UIUtils.createLabelSpinner((Composite)queriesGroup, CoreMessages.pref_page_database_general_label_result_set_cancel_timeout, CoreMessages.pref_page_database_general_label_result_set_cancel_timeout_tip, 0, 0, Integer.MAX_VALUE);
        this.queryCancelTimeout.setEnabled(false);
        this.readQueryMetadata.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageResultSetMain.this.updateOptionsEnablement();
            }
        });
        Group miscGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_sql_editor_group_misc, 1, 2, 0);
        this.keepStatementOpenCheck = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.pref_page_database_general_checkbox_keep_cursor, false);
        this.alwaysUseAllColumns = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.pref_page_content_editor_checkbox_keys_always_use_all_columns, false);
        this.newRowsAfter = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.pref_page_content_editor_checkbox_new_rows_after, false);
        this.refreshAfterUpdate = UIUtils.createCheckbox((Composite)miscGroup, CoreMessages.pref_page_content_editor_checkbox_refresh_after_update, false);
        Group advGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_results_group_advanced, 1, 2, 0);
        this.advUseFetchSize = UIUtils.createCheckbox((Composite)advGroup, CoreMessages.pref_page_database_resultsets_label_fetch_size, CoreMessages.pref_page_database_resultsets_label_fetch_size_tip, false, 1);
        return composite;
    }

    private void updateOptionsEnablement() {
        this.readQueryReferences.setEnabled(this.readQueryMetadata.isEnabled() && this.readQueryMetadata.getSelection());
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.autoFetchNextSegmentCheck.setSelection(store.getBoolean("resultset.autofetch.next.segment"));
            this.resultSetSize.setSelection(store.getInt("resultset.maxrows"));
            this.resultSetUseSQLCheck.setSelection(store.getBoolean("resultset.maxrows.sql"));
            this.serverSideOrderingCheck.setSelection(store.getBoolean("resultset.order.serverSide"));
            this.readQueryMetadata.setSelection(store.getBoolean("resultset.read.metadata"));
            this.readQueryReferences.setSelection(store.getBoolean("resultset.read.references"));
            this.queryCancelTimeout.setSelection(store.getInt("resultset.cancel.timeout"));
            this.keepStatementOpenCheck.setSelection(store.getBoolean("keep.statement.open"));
            this.alwaysUseAllColumns.setSelection(store.getBoolean("resultset.edit.key.use_all_columns"));
            this.newRowsAfter.setSelection(store.getBoolean("resultset.edit.new.row.after"));
            this.refreshAfterUpdate.setSelection(store.getBoolean("resultset.edit.refreshAfterUpdate"));
            this.advUseFetchSize.setSelection(store.getBoolean("resultset.fetch.size"));
            this.updateOptionsEnablement();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("resultset.autofetch.next.segment", this.autoFetchNextSegmentCheck.getSelection());
            store.setValue("resultset.maxrows", this.resultSetSize.getSelection());
            store.setValue("resultset.maxrows.sql", this.resultSetUseSQLCheck.getSelection());
            store.setValue("resultset.order.serverSide", this.serverSideOrderingCheck.getSelection());
            store.setValue("resultset.read.metadata", this.readQueryMetadata.getSelection());
            store.setValue("resultset.read.references", this.readQueryReferences.getSelection());
            store.setValue("resultset.cancel.timeout", this.queryCancelTimeout.getSelection());
            store.setValue("keep.statement.open", this.keepStatementOpenCheck.getSelection());
            store.setValue("resultset.edit.key.use_all_columns", this.alwaysUseAllColumns.getSelection());
            store.setValue("resultset.edit.new.row.after", this.newRowsAfter.getSelection());
            store.setValue("resultset.edit.refreshAfterUpdate", this.refreshAfterUpdate.getSelection());
            store.setValue("resultset.fetch.size", this.advUseFetchSize.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("resultset.autofetch.next.segment");
        store.setToDefault("resultset.maxrows");
        store.setToDefault("resultset.maxrows.sql");
        store.setToDefault("resultset.order.serverSide");
        store.setToDefault("resultset.read.metadata");
        store.setToDefault("resultset.read.references");
        store.setToDefault("resultset.cancel.timeout");
        store.setToDefault("keep.statement.open");
        store.setToDefault("resultset.edit.key.use_all_columns");
        store.setToDefault("resultset.edit.new.row.after");
        store.setToDefault("resultset.edit.refreshAfterUpdate");
        store.setToDefault("resultset.fetch.size");
        this.updateOptionsEnablement();
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

