/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageErrorHandle
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.errorHandle";
    private Button rollbackOnErrorCheck;
    private Button connectionAutoRecoverEnabled;
    private Spinner connectionAutoRecoverRetryCount;

    @Override
    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("query.rollback-on-error") || store.contains("execute.recover.enabled") || store.contains("execute.recover.retryCount");
    }

    @Override
    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @Override
    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 2, 5);
        Group errorGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_error_handle_group_execute_title, 2, 2, 0);
        this.rollbackOnErrorCheck = UIUtils.createCheckbox((Composite)errorGroup, CoreMessages.pref_page_database_general_checkbox_rollback_on_error, null, false, 2);
        this.connectionAutoRecoverEnabled = UIUtils.createCheckbox((Composite)errorGroup, CoreMessages.pref_page_error_handle_recover_enabled_label, CoreMessages.pref_page_error_handle_recover_enabled_tip, false, 2);
        this.connectionAutoRecoverRetryCount = UIUtils.createLabelSpinner((Composite)errorGroup, CoreMessages.pref_page_error_handle_recover_retry_count_label, CoreMessages.pref_page_error_handle_recover_retry_count_tip, 0, 0, Integer.MAX_VALUE);
        return composite;
    }

    @Override
    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.rollbackOnErrorCheck.setSelection(store.getBoolean("query.rollback-on-error"));
            this.connectionAutoRecoverEnabled.setSelection(store.getBoolean("execute.recover.enabled"));
            this.connectionAutoRecoverRetryCount.setSelection(store.getInt("execute.recover.retryCount"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    @Override
    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("query.rollback-on-error", this.rollbackOnErrorCheck.getSelection());
            store.setValue("execute.recover.enabled", this.connectionAutoRecoverEnabled.getSelection());
            store.setValue("execute.recover.retryCount", this.connectionAutoRecoverRetryCount.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    @Override
    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("query.rollback-on-error");
        store.setToDefault("execute.recover.enabled");
        store.setToDefault("execute.recover.retryCount");
    }

    @Override
    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

