/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.encode.EncryptionException;
import org.jkiss.dbeaver.registry.encode.SecuredPasswordEncrypter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDrivers
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(PrefPageDrivers.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.drivers";
    private Button versionUpdateCheck;
    private List sourceList;
    private Text proxyHostText;
    private Spinner proxyPortSpinner;
    private Text proxyUserText;
    private Text proxyPasswordText;
    private SecuredPasswordEncrypter encrypter;
    private Text customDriversHome;

    public void init(IWorkbench workbench) {
        try {
            this.encrypter = new SecuredPasswordEncrypter();
        }
        catch (EncryptionException e) {
            log.warn((Object)e);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1, 5);
        Group settings = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_settings, 2, 768, 300);
        this.versionUpdateCheck = UIUtils.createCheckbox((Composite)settings, CoreMessages.pref_page_ui_general_check_new_driver_versions, false);
        Group proxyObjects = UIUtils.createControlGroup(composite, CoreMessages.pref_page_ui_general_group_http_proxy, 4, 770, 300);
        this.proxyHostText = UIUtils.createLabelText((Composite)proxyObjects, CoreMessages.pref_page_ui_general_label_proxy_host, null);
        this.proxyPortSpinner = UIUtils.createLabelSpinner((Composite)proxyObjects, CoreMessages.pref_page_ui_general_spinner_proxy_port, 0, 0, 65535);
        this.proxyUserText = UIUtils.createLabelText((Composite)proxyObjects, CoreMessages.pref_page_ui_general_label_proxy_user, null);
        this.proxyPasswordText = UIUtils.createLabelText((Composite)proxyObjects, CoreMessages.pref_page_ui_general_label_proxy_password, null, 0x400800);
        Group drivers = UIUtils.createControlGroup(composite, CoreMessages.pref_page_drivers_group_location, 2, 768, 300);
        this.customDriversHome = DialogUtils.createOutputFolderChooser((Composite)drivers, CoreMessages.pref_page_drivers_local_folder, null);
        Group repoGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_drivers_group_file_repositories, 2, 768, 300);
        this.sourceList = new List((Composite)repoGroup, 2052);
        this.sourceList.setLayoutData((Object)new GridData(1808));
        Composite buttonsPH = UIUtils.createPlaceholder((Composite)repoGroup, 1);
        UIUtils.createToolButton(buttonsPH, CoreMessages.pref_page_drivers_button_add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = EnterNameDialog.chooseName(PrefPageDrivers.this.getShell(), CoreMessages.pref_page_drivers_label_enter_drivers_location_url, "http://");
                if (url != null) {
                    PrefPageDrivers.this.sourceList.add(url);
                }
            }
        });
        final Button removeButton = UIUtils.createToolButton(buttonsPH, CoreMessages.pref_page_drivers_button_remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageDrivers.this.sourceList.remove(PrefPageDrivers.this.sourceList.getSelectionIndices());
                PrefPageDrivers.this.sourceList.notifyListeners(13, new Event());
            }
        });
        removeButton.setEnabled(false);
        this.sourceList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageDrivers.this.sourceList.getSelectionIndex() >= 0) {
                    removeButton.setEnabled(PrefPageDrivers.this.sourceList.getItemCount() > 1);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.versionUpdateCheck.setSelection(store.getBoolean("ui.drivers.version.update"));
        this.proxyHostText.setText(store.getString("ui.proxy.host"));
        this.proxyPortSpinner.setSelection(store.getInt("ui.proxy.port"));
        this.proxyUserText.setText(store.getString("ui.proxy.user"));
        String passwordString = store.getString("ui.proxy.password");
        if (!CommonUtils.isEmpty((String)passwordString) && this.encrypter != null) {
            try {
                passwordString = this.encrypter.decrypt(passwordString);
            }
            catch (EncryptionException e) {
                log.warn((Object)e);
            }
        }
        this.proxyPasswordText.setText(passwordString);
        this.customDriversHome.setText(DriverDescriptor.getCustomDriversHome().getAbsolutePath());
        String[] stringArray = DriverDescriptor.getDriversSources();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String source = stringArray[n2];
            this.sourceList.add(source);
            ++n2;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("ui.drivers.version.update", this.versionUpdateCheck.getSelection());
        store.setValue("ui.proxy.host", this.proxyHostText.getText());
        store.setValue("ui.proxy.port", this.proxyPortSpinner.getSelection());
        store.setValue("ui.proxy.user", this.proxyUserText.getText());
        String password = this.proxyPasswordText.getText();
        if (!CommonUtils.isEmpty((String)password) && this.encrypter != null) {
            try {
                password = this.encrypter.encrypt(password);
            }
            catch (EncryptionException e) {
                log.warn((Object)e);
            }
        }
        store.setValue("ui.proxy.password", password);
        store.setValue("ui.drivers.home", this.customDriversHome.getText());
        StringBuilder sources = new StringBuilder();
        String[] stringArray = this.sourceList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (sources.length() > 0) {
                sources.append('|');
            }
            sources.append(item);
            ++n2;
        }
        store.setValue("ui.drivers.sources", sources.toString());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

