/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseNavigator
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.navigator";
    private Button expandOnConnectCheck;
    private Button showObjectTipsCheck;
    private Button sortCaseInsensitiveCheck;
    private Button sortFoldersFirstCheck;
    private Button groupByDriverCheck;
    private Button syncEditorDataSourceWithNavigator;
    private Combo dsDoubleClickBehavior;
    private Combo objDoubleClickBehavior;
    private Button showGeneralToolbarEverywhere;

    public PrefPageDatabaseNavigator() {
        this.setPreferenceStore(new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1, 5);
        Group navigatorGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_database_general_group_navigator, 2, 0, 0);
        this.expandOnConnectCheck = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_expand_navigator_tree, "", false, 2);
        this.showObjectTipsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_show_tips_in_tree, CoreMessages.pref_page_database_general_label_show_tips_in_tree_tip, false, 2);
        this.sortCaseInsensitiveCheck = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_order_elements_alphabetically, "", false, 2);
        this.sortFoldersFirstCheck = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_folders_first, CoreMessages.pref_page_database_general_label_folders_first_tip, false, 2);
        this.groupByDriverCheck = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_group_database_by_driver, "", false, 2);
        this.groupByDriverCheck.setEnabled(false);
        this.syncEditorDataSourceWithNavigator = UIUtils.createCheckbox((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator, CoreMessages.pref_page_database_general_label_sync_editor_connection_with_navigator_tip, false, 2);
        this.objDoubleClickBehavior = UIUtils.createLabelCombo((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_double_click_node, 12);
        this.objDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_node_open_properties, 0);
        this.objDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_node_expand_collapse, 1);
        this.dsDoubleClickBehavior = UIUtils.createLabelCombo((Composite)navigatorGroup, CoreMessages.pref_page_database_general_label_double_click_connection, 12);
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_open_properties, NavigatorViewBase.DoubleClickBehavior.EDIT.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_conn_disconn, NavigatorViewBase.DoubleClickBehavior.CONNECT.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_open_sqleditor, NavigatorViewBase.DoubleClickBehavior.SQL_EDITOR.ordinal());
        this.dsDoubleClickBehavior.add(CoreMessages.pref_page_database_general_label_double_click_connection_expand_collapse, NavigatorViewBase.DoubleClickBehavior.EXPAND.ordinal());
        Group toolbarsGroup = UIUtils.createControlGroup(composite, CoreMessages.pref_page_database_general_group_toolbars, 2, 0, 0);
        this.showGeneralToolbarEverywhere = UIUtils.createCheckbox((Composite)toolbarsGroup, CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere, CoreMessages.pref_page_database_general_label_show_general_toolbar_everywhere_tip, false, 2);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        this.expandOnConnectCheck.setSelection(store.getBoolean("navigator.expand.on.connect"));
        this.showObjectTipsCheck.setSelection(store.getBoolean("navigator.show.objects.tips"));
        this.sortCaseInsensitiveCheck.setSelection(store.getBoolean("navigator.sort.case.insensitive"));
        this.sortFoldersFirstCheck.setSelection(store.getBoolean("navigator.sort.forlers.first"));
        this.groupByDriverCheck.setSelection(store.getBoolean("navigator.group.by.driver"));
        this.syncEditorDataSourceWithNavigator.setSelection(store.getBoolean("navigator.sync.editor.datasource"));
        NavigatorViewBase.DoubleClickBehavior objDCB = NavigatorViewBase.DoubleClickBehavior.valueOf(store.getString("navigator.object.doubleClick"));
        this.objDoubleClickBehavior.select(objDCB == NavigatorViewBase.DoubleClickBehavior.EXPAND ? 1 : 0);
        this.dsDoubleClickBehavior.select(NavigatorViewBase.DoubleClickBehavior.valueOf(store.getString("navigator.connection.doubleClick")).ordinal());
        this.showGeneralToolbarEverywhere.setSelection(store.getBoolean("toolbars.show.general.always"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBeaverCore.getGlobalPreferenceStore();
        store.setValue("navigator.expand.on.connect", this.expandOnConnectCheck.getSelection());
        store.setValue("navigator.show.objects.tips", this.showObjectTipsCheck.getSelection());
        store.setValue("navigator.sort.case.insensitive", this.sortCaseInsensitiveCheck.getSelection());
        store.setValue("navigator.sort.forlers.first", this.sortFoldersFirstCheck.getSelection());
        store.setValue("navigator.group.by.driver", this.groupByDriverCheck.getSelection());
        store.setValue("navigator.sync.editor.datasource", this.syncEditorDataSourceWithNavigator.getSelection());
        NavigatorViewBase.DoubleClickBehavior objDCB = NavigatorViewBase.DoubleClickBehavior.EXPAND;
        if (this.objDoubleClickBehavior.getSelectionIndex() == 0) {
            objDCB = NavigatorViewBase.DoubleClickBehavior.EDIT;
        }
        store.setValue("navigator.object.doubleClick", objDCB.name());
        store.setValue("navigator.connection.doubleClick", ((NavigatorViewBase.DoubleClickBehavior)CommonUtils.fromOrdinal(NavigatorViewBase.DoubleClickBehavior.class, (int)this.dsDoubleClickBehavior.getSelectionIndex())).name());
        store.setValue("toolbars.show.general.always", this.showGeneralToolbarEverywhere.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

