/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class PrefPageConnectionTypes
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.connectionTypes";
    private Table typeTable;
    private Text typeName;
    private Text typeDescription;
    private ColorSelector colorPicker;
    private Button autocommitCheck;
    private Button confirmCheck;
    private ToolItem deleteButton;
    private DBPConnectionType selectedType;
    private Map<DBPConnectionType, DBPConnectionType> changedInfo = new HashMap<DBPConnectionType, DBPConnectionType>();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder(parent, 1, 5);
        this.typeTable = new Table(composite, 67588);
        this.typeTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn(this.typeTable, 16384, CoreMessages.pref_page_connection_types_label_table_column_name);
        UIUtils.createTableColumn(this.typeTable, 16384, CoreMessages.pref_page_connection_types_label_table_column_description);
        this.typeTable.setHeaderVisible(true);
        this.typeTable.setLayoutData((Object)new GridData(1808));
        this.typeTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.showSelectedType(PrefPageConnectionTypes.this.getSelectedType());
            }
        });
        ToolBar toolbar = new ToolBar(composite, 0x800100);
        ToolItem newButton = new ToolItem(toolbar, 0);
        newButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_ADD));
        this.deleteButton = new ToolItem(toolbar, 0);
        this.deleteButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ROW_DELETE));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name;
                int i = 1;
                while (true) {
                    name = "Type" + i;
                    boolean hasName = false;
                    for (DBPConnectionType type : PrefPageConnectionTypes.this.changedInfo.keySet()) {
                        if (!type.getName().equals(name)) continue;
                        hasName = true;
                        break;
                    }
                    if (!hasName) break;
                    ++i;
                }
                DBPConnectionType newType = new DBPConnectionType(SecurityUtils.generateUniqueId(), name, "255,255,255", "New type", true, false);
                PrefPageConnectionTypes.this.addTypeToTable(newType, newType);
                PrefPageConnectionTypes.this.typeTable.select(PrefPageConnectionTypes.this.typeTable.getItemCount() - 1);
                PrefPageConnectionTypes.this.typeTable.showSelection();
                PrefPageConnectionTypes.this.showSelectedType(newType);
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPConnectionType connectionType = PrefPageConnectionTypes.this.getSelectedType();
                if (!UIUtils.confirmAction(PrefPageConnectionTypes.this.getShell(), CoreMessages.pref_page_connection_types_label_delete_connection_type, NLS.bind((String)CoreMessages.pref_page_connection_types_label_delete_connection_type_description, (Object)connectionType.getName(), (Object)DBPConnectionType.DEFAULT_TYPE.getName()))) {
                    return;
                }
                PrefPageConnectionTypes.this.changedInfo.remove(connectionType);
                int index = PrefPageConnectionTypes.this.typeTable.getSelectionIndex();
                PrefPageConnectionTypes.this.typeTable.remove(index);
                if (index > 0) {
                    --index;
                }
                PrefPageConnectionTypes.this.typeTable.select(index);
                PrefPageConnectionTypes.this.showSelectedType(PrefPageConnectionTypes.this.getSelectedType());
            }
        });
        Group groupSettings = UIUtils.createControlGroup(composite, CoreMessages.pref_page_connection_types_group_settings, 2, 2, 300);
        groupSettings.setLayoutData((Object)new GridData(1808));
        this.typeName = UIUtils.createLabelText((Composite)groupSettings, CoreMessages.pref_page_connection_types_label_name, null);
        this.typeName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setName(PrefPageConnectionTypes.this.typeName.getText());
                PrefPageConnectionTypes.this.updateTableInfo();
            }
        });
        this.typeDescription = UIUtils.createLabelText((Composite)groupSettings, CoreMessages.pref_page_connection_types_label_description, null);
        this.typeDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setDescription(PrefPageConnectionTypes.this.typeDescription.getText());
                PrefPageConnectionTypes.this.updateTableInfo();
            }
        });
        UIUtils.createControlLabel((Composite)groupSettings, CoreMessages.pref_page_connection_types_label_color);
        this.colorPicker = new ColorSelector((Composite)groupSettings);
        this.colorPicker.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PrefPageConnectionTypes.this.getSelectedType().setColor(StringConverter.asString((RGB)PrefPageConnectionTypes.this.colorPicker.getColorValue()));
                PrefPageConnectionTypes.this.updateTableInfo();
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.autocommitCheck = UIUtils.createCheckbox((Composite)groupSettings, CoreMessages.pref_page_connection_types_label_auto_commit_by_default, false);
        this.autocommitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setAutocommit(PrefPageConnectionTypes.this.autocommitCheck.getSelection());
            }
        });
        this.autocommitCheck.setLayoutData((Object)gd);
        this.confirmCheck = UIUtils.createCheckbox((Composite)groupSettings, CoreMessages.pref_page_connection_types_label_confirm_sql_execution, false);
        this.confirmCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionTypes.this.getSelectedType().setConfirmExecute(PrefPageConnectionTypes.this.confirmCheck.getSelection());
            }
        });
        this.confirmCheck.setLayoutData((Object)gd);
        this.performDefaults();
        return composite;
    }

    private DBPConnectionType getSelectedType() {
        return (DBPConnectionType)this.typeTable.getItem(this.typeTable.getSelectionIndex()).getData();
    }

    private void showSelectedType(DBPConnectionType connectionType) {
        Color connectionTypeColor = UIUtils.getConnectionTypeColor(connectionType);
        if (connectionTypeColor != null) {
            this.colorPicker.setColorValue(connectionTypeColor.getRGB());
        }
        this.typeName.setText(connectionType.getName());
        this.typeDescription.setText(connectionType.getDescription());
        this.autocommitCheck.setSelection(connectionType.isAutocommit());
        this.confirmCheck.setSelection(connectionType.isConfirmExecute());
        this.deleteButton.setEnabled(!connectionType.isPredefined());
    }

    private void updateTableInfo() {
        DBPConnectionType connectionType = this.getSelectedType();
        TableItem[] tableItemArray = this.typeTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() == connectionType) {
                item.setText(0, connectionType.getName());
                item.setText(1, connectionType.getDescription());
                Color connectionColor = UIUtils.getConnectionTypeColor(connectionType);
                item.setBackground(0, connectionColor);
                item.setBackground(1, connectionColor);
                break;
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        this.typeTable.removeAll();
        for (DBPConnectionType source : DataSourceProviderRegistry.getInstance().getConnectionTypes()) {
            this.addTypeToTable(source, new DBPConnectionType(source));
        }
        this.typeTable.select(0);
        if (this.selectedType != null) {
            int i = 0;
            while (i < this.typeTable.getItemCount()) {
                if (this.typeTable.getItem(i).getData().equals(this.selectedType)) {
                    this.typeTable.select(i);
                    break;
                }
                ++i;
            }
        }
        this.showSelectedType(this.getSelectedType());
        this.typeTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns(PrefPageConnectionTypes.this.typeTable, true);
            }
        });
        super.performDefaults();
    }

    private void addTypeToTable(DBPConnectionType source, DBPConnectionType connectionType) {
        this.changedInfo.put(connectionType, source);
        TableItem item = new TableItem(this.typeTable, 16384);
        item.setText(0, connectionType.getName());
        item.setText(1, CommonUtils.toString((Object)connectionType.getDescription()));
        if (connectionType.getColor() != null) {
            Color connectionColor = UIUtils.getConnectionTypeColor(connectionType);
            item.setBackground(0, connectionColor);
            item.setBackground(1, connectionColor);
            if (connectionColor != null) {
                this.colorPicker.setColorValue(connectionColor.getRGB());
            }
        }
        item.setData((Object)connectionType);
    }

    public boolean performOk() {
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        ArrayList<DBPConnectionType> toRemove = new ArrayList<DBPConnectionType>();
        for (DBPConnectionType type : registry.getConnectionTypes()) {
            if (this.changedInfo.values().contains(type)) continue;
            toRemove.add(type);
        }
        for (DBPConnectionType connectionType : toRemove) {
            registry.removeConnectionType(connectionType);
        }
        for (DBPConnectionType changed : this.changedInfo.keySet()) {
            DBPConnectionType source = this.changedInfo.get(changed);
            if (source == changed) {
                registry.addConnectionType(changed);
                continue;
            }
            source.setName(changed.getName());
            source.setDescription(changed.getDescription());
            source.setAutocommit(changed.isAutocommit());
            source.setConfirmExecute(changed.isConfirmExecute());
            source.setColor(changed.getColor());
        }
        registry.saveConnectionTypes();
        return super.performOk();
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
        this.selectedType = (DBPConnectionType)element.getAdapter(DBPConnectionType.class);
    }
}

