/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class CheckboxTreeManager
implements ICheckStateListener {
    private static final Log log = Log.getLog(CheckboxTreeManager.class);
    private final CheckboxTreeViewer viewer;
    private final Class<?>[] targetTypes;
    private Object[] checkedElements;
    private final ViewerFilter[] filters;

    public CheckboxTreeManager(CheckboxTreeViewer viewer, Class<?>[] targetTypes) {
        this.viewer = viewer;
        this.targetTypes = targetTypes;
        this.filters = viewer.getFilters();
        viewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.updateElementsCheck(new Object[]{event.getElement()}, event.getChecked(), true);
    }

    private void updateElementsCheck(final Object[] elements, final boolean checked, final boolean change) {
        this.checkedElements = this.viewer.getCheckedElements();
        try {
            DBeaverUI.runInProgressService(new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Load sources tree", 100 * elements.length);
                    try {
                        try {
                            Object[] objectArray = elements;
                            int n = elements.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                CheckboxTreeManager.this.updateElementHierarchy(monitor, element, checked, change);
                                if (change && element instanceof DBNDatabaseNode) {
                                    DBNNode node = ((DBNDatabaseNode)element).getParentNode();
                                    while (node != null) {
                                        if (node instanceof DBNDatabaseNode) {
                                            CheckboxTreeManager.this.updateElementHierarchy(monitor, node, checked, false);
                                        }
                                        if (node instanceof DBNDataSource) break;
                                        node = node.getParentNode();
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Error updating checkbox state", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void updateElementHierarchy(DBRProgressMonitor monitor, final Object element, final boolean checked, final boolean change) throws DBException {
        final ArrayList<DBNDatabaseNode> targetChildren = new ArrayList<DBNDatabaseNode>();
        final ArrayList<DBNDatabaseNode> targetContainers = new ArrayList<DBNDatabaseNode>();
        try {
            this.collectChildren(monitor, element, targetChildren, targetContainers, !change);
        }
        catch (DBException e) {
            log.warn((Object)"Error collecting child elements", (Throwable)e);
        }
        DBeaverUI.syncExec(new Runnable(){

            @Override
            public void run() {
                if (change) {
                    for (DBNDatabaseNode child : targetChildren) {
                        CheckboxTreeManager.this.viewer.setChecked((Object)child, checked);
                    }
                }
                for (DBNDatabaseNode container : change ? targetContainers : Collections.singletonList((DBNDatabaseNode)element)) {
                    try {
                        DBNDatabaseNode[] directChildren = container.getChildren((DBRProgressMonitor)new VoidProgressMonitor());
                        if (directChildren == null) continue;
                        boolean missingOne = false;
                        boolean missingAll = true;
                        DBNDatabaseNode[] dBNDatabaseNodeArray = directChildren;
                        int n = directChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DBNDatabaseNode node = dBNDatabaseNodeArray[n2];
                            if (!CheckboxTreeManager.this.viewer.getChecked((Object)node)) {
                                missingOne = true;
                            } else {
                                missingAll = false;
                            }
                            ++n2;
                        }
                        CheckboxTreeManager.this.viewer.setChecked((Object)container, change ? checked : !missingAll);
                        CheckboxTreeManager.this.viewer.setGrayed((Object)container, missingOne);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private boolean collectChildren(DBRProgressMonitor monitor, Object element, List<DBNDatabaseNode> targetChildren, List<DBNDatabaseNode> targetContainers, boolean onlyChecked) throws DBException {
        if (element instanceof DBNDatabaseNode) {
            ViewerFilter[] viewerFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!filter.select((Viewer)this.viewer, (Object)((DBNDatabaseNode)element).getParentNode(), element)) {
                    return false;
                }
                ++n2;
            }
            boolean isChecked = ArrayUtils.contains((Object[])this.checkedElements, (Object)element);
            Class<?>[] classArray = this.targetTypes;
            int n3 = this.targetTypes.length;
            n = 0;
            while (n < n3) {
                Class<?> type = classArray[n];
                if (type.isInstance(((DBNDatabaseNode)element).getObject())) {
                    if (!onlyChecked || isChecked) {
                        targetChildren.add((DBNDatabaseNode)element);
                    }
                    return true;
                }
                ++n;
            }
            ((DBNDatabaseNode)element).initializeNode(monitor, null);
            Object[] children = ((DBNDatabaseNode)element).getChildren(monitor);
            if (!ArrayUtils.isEmpty((Object[])children)) {
                boolean foundChild = false;
                Object[] objectArray = children;
                int n4 = children.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object child = objectArray[n5];
                    if (this.collectChildren(monitor, child, targetChildren, targetContainers, onlyChecked)) {
                        foundChild = true;
                    }
                    ++n5;
                }
                if (foundChild && (!onlyChecked || isChecked)) {
                    targetContainers.add((DBNDatabaseNode)element);
                }
                return foundChild;
            }
        }
        return false;
    }

    public void updateCheckStates() {
        LinkedHashSet<DBNDatabaseNode> parentList = new LinkedHashSet<DBNDatabaseNode>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            DBNNode node = ((DBNDatabaseNode)element).getParentNode();
            while (node != null) {
                if (node instanceof DBNDatabaseNode) {
                    parentList.add((DBNDatabaseNode)node);
                    this.viewer.setChecked((Object)node, true);
                }
                node = node.getParentNode();
            }
            ++n2;
        }
        this.updateElementsCheck(parentList.toArray(), true, false);
    }
}

