/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.util.AbstractSQLEditorTextHover;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLWordFinder;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static final Log log = Log.getLog(SQLAnnotationHover.class);
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private SQLEditorBase editor;
    private IHyperlinkDetector[] hyperlinkDetectors;

    public SQLAnnotationHover(SQLEditorBase editor) {
        this.setEditor(editor);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo2 = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo2 == null ? null : hoverInfo2.toString();
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.hyperlinkDetectors == null) {
            this.hyperlinkDetectors = this.editor.getViewerConfiguration().getHyperlinkDetectors((ISourceViewer)this.editor.getViewer());
        }
        return null;
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return SQLWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        if (this.annotations.size() == 0) {
            this.findAnnotations(-1, sourceViewer.getAnnotationModel(), sourceViewer.getDocument(), lineNumber);
        }
        return null;
    }

    private void findAnnotations(int offset, IAnnotationModel model, IDocument document, int lineNumber) {
        this.annotations.clear();
        if (model == null && this.editor != null) {
            SQLEditorBase editor = this.editor;
            model = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        }
        if (model == null) {
            return;
        }
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation = (Annotation)it.next();
            Position position = model.getPosition(annotation);
            if (position == null) {
                return;
            }
            try {
                if (!position.overlapsWith(offset, 1) && (document == null || document.getLineOfOffset(position.offset) != lineNumber)) continue;
                this.annotations.add(annotation);
            }
            catch (BadLocationException e) {
                log.error((Object)e);
            }
        }
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.editor = (SQLEditorBase)editor;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                DefaultInformationControl control = new DefaultInformationControl(parent, true);
                control.setSizeConstraints(60, 10);
                return control;
            }
        };
    }
}

