/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.templates.AbstractTemplatesPage;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ProxyPageSite;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeDriver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContextTypeProvider;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplateCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesRegistry;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;

public class SQLTemplatesPage
extends AbstractTemplatesPage {
    private static final Log log = Log.getLog(SQLTemplatesPage.class);
    private static final String PREFERENCE_PAGE_ID = "org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesPage";
    private SQLEditorBase sqlEditor;

    public SQLTemplatesPage(SQLEditorBase sqlEditor) {
        super((ITextEditor)sqlEditor, (ISourceViewer)sqlEditor.getViewer());
        this.sqlEditor = sqlEditor;
        ProxyPageSite ps = new ProxyPageSite(sqlEditor.getSite());
        this.init(ps);
    }

    public void insertTemplate(Template template, IDocument document) {
        String savedText;
        if (!this.sqlEditor.validateEditorInputState()) {
            return;
        }
        SourceViewer contextViewer = this.sqlEditor.getViewer();
        ITextSelection textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
        if (!this.isValidTemplate(document, template, textSelection.getOffset(), textSelection.getLength())) {
            return;
        }
        this.beginCompoundChange((ISourceViewer)contextViewer);
        try {
            savedText = document.get(textSelection.getOffset(), textSelection.getLength());
            if (savedText.length() == 0) {
                String prefix = this.getIdentifierPart(document, template, textSelection.getOffset(), textSelection.getLength());
                if (prefix.length() > 0 && !template.getName().startsWith(prefix)) {
                    return;
                }
                if (prefix.length() > 0) {
                    contextViewer.setSelectedRange(textSelection.getOffset() - prefix.length(), prefix.length());
                    textSelection = (ITextSelection)contextViewer.getSelectionProvider().getSelection();
                }
            }
            document.replace(textSelection.getOffset(), textSelection.getLength(), template.getName().substring(0, 1));
        }
        catch (BadLocationException e) {
            this.endCompoundChange((ISourceViewer)contextViewer);
            return;
        }
        Region region = new Region(textSelection.getOffset(), 0);
        textSelection = new TextSelection(textSelection.getOffset(), 1);
        contextViewer.getSelectionProvider().setSelection((ISelection)textSelection);
        SQLContext context = this.getContext(document, template, textSelection.getOffset(), textSelection.getLength());
        context.setVariable("selection", savedText);
        if (context.getKey().length() == 0) {
            try {
                document.replace(textSelection.getOffset(), 1, savedText);
            }
            catch (BadLocationException e) {
                this.endCompoundChange((ISourceViewer)contextViewer);
                return;
            }
        }
        SQLTemplateCompletionProposal proposal = new SQLTemplateCompletionProposal(template, (TemplateContext)context, (IRegion)region, null);
        this.sqlEditor.getSite().getPage().activate((IWorkbenchPart)this.sqlEditor);
        proposal.apply((ITextViewer)this.sqlEditor.getViewer(), ' ', 0, region.getOffset());
        Point selection = proposal.getSelection(document);
        if (selection != null) {
            this.sqlEditor.getViewer().setSelectedRange(selection.x, selection.y);
            this.sqlEditor.getViewer().revealRange(selection.x, selection.y);
        }
        this.endCompoundChange((ISourceViewer)contextViewer);
    }

    protected ContextTypeRegistry getContextTypeRegistry() {
        return SQLTemplatesRegistry.getInstance().getTemplateContextRegistry();
    }

    protected IPreferenceStore getTemplatePreferenceStore() {
        return new PreferenceStoreDelegate(DBeaverCore.getGlobalPreferenceStore());
    }

    public TemplateStore getTemplateStore() {
        return SQLTemplatesRegistry.getInstance().getTemplateStore();
    }

    protected boolean isValidTemplate(IDocument document, Template template, int offset, int length) {
        String[] contextIds;
        String[] stringArray = contextIds = this.getContextTypeIds(document, offset);
        int n = contextIds.length;
        int n2 = 0;
        while (n2 < n) {
            String contextId = stringArray[n2];
            if (contextId.equals(template.getContextTypeId())) {
                SQLContext context = this.getContext(document, template, offset, length);
                return context.canEvaluate(template) || this.isTemplateAllowed(context, template);
            }
            ++n2;
        }
        return false;
    }

    protected SourceViewer createPatternViewer(Composite parent) {
        Document document = new Document();
        SQLEditorSourceViewer viewer = new SQLEditorSourceViewer(parent, null, null, false, 768);
        SQLEditorSourceViewerConfiguration configuration = new SQLEditorSourceViewerConfiguration(this.sqlEditor, EditorsPlugin.getDefault().getPreferenceStore());
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Control control = viewer.getControl();
        GridData data = new GridData(1296);
        control.setLayoutData((Object)data);
        viewer.setEditable(false);
        return viewer;
    }

    protected Image getImage(Template template) {
        return DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT);
    }

    protected void updatePatternViewer(Template template) {
        if (template == null) {
            this.getPatternViewer().getDocument().set("");
            return;
        }
        IDocument doc = this.getPatternViewer().getDocument();
        String start = "";
        doc.set(String.valueOf(start) + template.getPattern());
        int startLen = start.length();
        this.getPatternViewer().setDocument(doc, startLen, doc.getLength() - startLen);
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    private void endCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().endCompoundChange();
        }
    }

    private void beginCompoundChange(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).getRewriteTarget().beginCompoundChange();
        }
    }

    private boolean isTemplateAllowed(DocumentTemplateContext context, Template template) {
        int offset = context.getCompletionOffset();
        try {
            return template != null && offset > 0 && !this.isTemplateNamePart(context.getDocument().getChar(offset - 1));
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return false;
        }
    }

    private boolean isTemplateNamePart(char ch) {
        return !Character.isWhitespace(ch) && ch != '(' && ch != ')' && ch != '{' && ch != '}' && ch != ';';
    }

    private SQLContext getContext(IDocument document, Template template, int offset, int length) {
        return new SQLContext(this.getContextTypeRegistry().getContextType(template.getContextTypeId()), document, new Position(offset, length), this.sqlEditor);
    }

    protected String[] getContextTypeIds(IDocument document, int offset) {
        DBPDataSource dataSource = this.sqlEditor.getDataSource();
        if (dataSource == null) {
            return new String[]{"sql"};
        }
        DriverDescriptor driver = (DriverDescriptor)dataSource.getContainer().getDriver();
        return new String[]{"sql", SQLContextTypeProvider.getTypeId(driver.getProviderDescriptor()), SQLContextTypeDriver.getTypeId(driver)};
    }

    private String getIdentifierPart(IDocument document, Template template, int offset, int length) {
        return this.getContext(document, template, offset, length).getKey();
    }
}

