/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLAnnotationHover;
import org.jkiss.dbeaver.ui.perspective.AbstractPartListener;
import org.jkiss.utils.ArrayUtils;

public class SQLInformationProvider
implements IInformationProvider,
IInformationProviderExtension,
IInformationProviderExtension2 {
    protected SQLEditorBase editor;
    protected IPartListener partListener;
    protected String currentPerspective;
    protected SQLAnnotationHover implementation;
    protected IInformationControlCreator informationControlCreator;

    public SQLInformationProvider(SQLEditorBase editor) {
        this.editor = editor;
        this.implementation = new SQLAnnotationHover(editor);
        if (this.editor != null) {
            this.partListener = new EditorWatcher();
            IWorkbenchWindow window = this.editor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.partListener);
            this.update();
        }
    }

    protected void update() {
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = this.editor.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (perspective = page.getPerspective()) != null) {
            String perspectiveId = perspective.getId();
            if (this.currentPerspective == null || !this.currentPerspective.equals(perspectiveId)) {
                this.currentPerspective = perspectiveId;
                this.implementation.setEditor(this.editor);
            }
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        Point selectedRange = textViewer.getSelectedRange();
        if (selectedRange.y > 1) {
            return new Region(selectedRange.x, selectedRange.y);
        }
        if (this.implementation != null) {
            return this.implementation.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        Object information = this.getInformation2(textViewer, subject);
        return information == null ? null : information.toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        Object s;
        if (this.implementation != null && (s = this.implementation.getHoverInfo2(textViewer, subject)) != null) {
            return s;
        }
        SQLContextInformer informer = new SQLContextInformer(this.editor, this.editor.getSyntaxManager());
        informer.searchInformation(subject);
        DBSObject object = null;
        if (informer.hasObjects()) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            DBSObjectReference objectRef = informer.getObjectReferences().get(0);
            try {
                object = objectRef.resolveObject((DBRProgressMonitor)monitor);
            }
            catch (DBException e) {
                return e.getMessage();
            }
        } else if (ArrayUtils.isEmpty((Object[])informer.getKeywords())) {
            return null;
        }
        return SQLContextInformer.readAdditionalProposalInfo(null, this.editor.getDataSource(), object, informer.getKeywords(), informer.getKeywordType());
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.informationControlCreator == null) {
            this.informationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new DefaultInformationControl(shell, true);
                }
            };
        }
        return this.informationControlCreator;
    }

    class EditorWatcher
    extends AbstractPartListener {
        EditorWatcher() {
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (part == SQLInformationProvider.this.editor) {
                SQLInformationProvider.this.editor.getSite().getWorkbenchWindow().getPartService().removePartListener(SQLInformationProvider.this.partListener);
                SQLInformationProvider.this.partListener = null;
            }
        }

        @Override
        public void partActivated(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }

        @Override
        public void partBroughtToTop(IWorkbenchPart part) {
            SQLInformationProvider.this.update();
        }
    }
}

