/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.indent;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jkiss.dbeaver.ui.editors.sql.indent.SQLHeuristicScanner;

public class SQLIndenter {
    private IDocument document;
    private int indent;
    private int position;
    private int token;
    private int line;
    private SQLHeuristicScanner scanner;

    public SQLIndenter(IDocument document, SQLHeuristicScanner scanner) {
        assert (document != null);
        assert (scanner != null);
        this.document = document;
        this.scanner = scanner;
    }

    public String getReferenceIndentation(int offset) {
        int unit = this.findReferencePosition(offset);
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public String computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public String computeIndentation(int offset, boolean assumeOpening) {
        this.indent = 1;
        StringBuilder indent = this.createIndent(this.indent);
        if (this.indent < 0) {
            this.unindent(indent);
        }
        if (indent == null) {
            return null;
        }
        indent.append(this.getReferenceIndentation(offset));
        return indent.toString();
    }

    private String getLeadingWhitespace(int offset) {
        int nonWS;
        int lineOffset;
        block5: {
            IRegion line;
            block4: {
                try {
                    line = this.document.getLineInformationOfOffset(offset);
                    lineOffset = line.getOffset();
                    if (!this.scanner.endsWithDelimiter(lineOffset, lineOffset + line.getLength())) break block4;
                    return "";
                }
                catch (BadLocationException e) {
                    return "";
                }
            }
            nonWS = this.scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            if (nonWS >= 0) break block5;
            return "";
        }
        return this.document.get(lineOffset, nonWS - lineOffset);
    }

    private void unindent(StringBuilder indent) {
        StringBuilder oneIndent = this.createIndent();
        int i = indent.lastIndexOf(oneIndent.toString());
        if (i != -1) {
            indent.delete(i, i + oneIndent.length());
        }
    }

    private StringBuilder createIndent(int indent) {
        StringBuilder oneIndent = this.createIndent();
        StringBuilder ret = new StringBuilder();
        while (indent-- > 0) {
            ret.append((CharSequence)oneIndent);
        }
        return ret;
    }

    private StringBuilder createIndent() {
        StringBuilder oneIndent = new StringBuilder();
        oneIndent.append('\t');
        return oneIndent;
    }

    public int findReferencePosition(int offset) {
        this.indent = 0;
        this.position = offset;
        this.nextToken();
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.line;
        int startPosition = this.position;
        while (true) {
            this.nextToken();
            if (this.line < startLine) {
                try {
                    int lineOffset = this.document.getLineOffset(startLine);
                    int bound = Math.min(this.document.getLength(), startPosition + 1);
                    int n = this.scanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return startPosition;
            }
            switch (this.token) {
                case -1: {
                    return 0;
                }
            }
        }
    }

    private void nextToken() {
        this.nextToken(this.position);
    }

    public void nextToken(int start) {
        this.token = this.scanner.previousToken(start - 1, -2);
        this.position = this.scanner.getPosition() + 1;
        try {
            this.line = this.document.getLineOfOffset(this.position);
        }
        catch (BadLocationException e) {
            this.line = -1;
        }
    }
}

