/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.IErrorVisualizer;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorContributor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorControl;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.SQLMarkerAnnotationAccess;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLPartitionScanner;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLVariableRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLToken;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesPage;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLSymbolInserter;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class SQLEditorBase
extends BaseTextEditor
implements IErrorVisualizer {
    protected static final Log log = Log.getLog(SQLEditorBase.class);
    @NotNull
    private final SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
    @NotNull
    private final SQLRuleManager ruleManager = new SQLRuleManager(this.syntaxManager);
    private ProjectionSupport projectionSupport;
    private ProjectionAnnotationModel annotationModel;
    private IAnnotationAccess annotationAccess;
    private boolean hasVerticalRuler = true;
    private SQLTemplatesPage templatesPage;
    private IPropertyChangeListener themeListener = new IPropertyChangeListener(){
        long lastUpdateTime = 0L;

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().startsWith("org.jkiss.dbeaver.sql.editor")) {
                if (this.lastUpdateTime > 0L && System.currentTimeMillis() - this.lastUpdateTime < 500L) {
                    return;
                }
                this.lastUpdateTime = System.currentTimeMillis();
                SQLEditorBase.this.reloadSyntaxRules();
                SQLEditorBase.this.getSourceViewer().configure(SQLEditorBase.this.getSourceViewerConfiguration());
            }
        }
    };

    static {
        IPreferenceStore editorStore = EditorsUI.getPreferenceStore();
        editorStore.setDefault("SQLEditor.matchingBrackets", true);
        editorStore.setDefault("SQLEditor.matchingBracketsColor", "128,128,128");
    }

    public SQLEditorBase() {
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new SQLEditorSourceViewerConfiguration(this, this.getPreferenceStore()));
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql"});
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#SQLEditorContext");
        this.setRulerContextMenuId("#SQLRulerContext");
    }

    @Nullable
    public abstract DBCExecutionContext getExecutionContext();

    public final DBPDataSource getDataSource() {
        DBCExecutionContext context = this.getExecutionContext();
        return context == null ? null : context.getDataSource();
    }

    public DBPPreferenceStore getActivePreferenceStore() {
        DBPDataSourceContainer container;
        if (this instanceof IDataSourceContainerProvider && (container = ((IDataSourceContainerProvider)this).getDataSourceContainer()) != null) {
            return container.getPreferenceStore();
        }
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? DBeaverCore.getGlobalPreferenceStore() : dataSource.getContainer().getPreferenceStore();
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource instanceof SQLDataSource) {
            return ((SQLDataSource)dataSource).getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    public boolean hasAnnotations() {
        return false;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    @NotNull
    public SQLRuleManager getRuleManager() {
        return this.ruleManager;
    }

    public ProjectionAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public SQLEditorSourceViewerConfiguration getViewerConfiguration() {
        return (SQLEditorSourceViewerConfiguration)super.getSourceViewerConfiguration();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        super.createPartControl(new SQLEditorControl(parent, this));
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
        SQLSymbolInserter symbolInserter = new SQLSymbolInserter(this);
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        boolean closeSingleQuotes = preferenceStore.getBoolean("SQLEditor.closeSingleQuotes");
        boolean closeDoubleQuotes = preferenceStore.getBoolean("SQLEditor.closeDoubleQuotes");
        boolean closeBrackets = preferenceStore.getBoolean("SQLEditor.closeBrackets");
        symbolInserter.setCloseSingleQuotesEnabled(closeSingleQuotes);
        symbolInserter.setCloseDoubleQuotesEnabled(closeDoubleQuotes);
        symbolInserter.setCloseBracketsEnabled(closeBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)symbolInserter);
        }
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.hasVerticalRuler ? super.createVerticalRuler() : new VerticalRuler(0);
    }

    public void setHasVerticalRuler(boolean hasVerticalRuler) {
        this.hasVerticalRuler = hasVerticalRuler;
    }

    protected ISharedTextColors getSharedColors() {
        return DBeaverUI.getSharedTextColors();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SQLEditorSourceViewer sourceViewer = this.createSourceViewer(parent, ruler, styles, this.fOverviewRuler);
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        return sourceViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        DefaultCharacterPairMatcher matcher;
        char[] matchChars = new char[]{'(', ')', '[', ']', '{', '}'};
        try {
            matcher = new DefaultCharacterPairMatcher(matchChars, "___sql_partitioning", true);
        }
        catch (Throwable e) {
            matcher = new DefaultCharacterPairMatcher(matchChars, "___sql_partitioning");
        }
        support.setCharacterPairMatcher((ICharacterPairMatcher)matcher);
        support.setMatchingCharacterPainterPreferenceKeys("SQLEditor.matchingBrackets", "SQLEditor.matchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    @NotNull
    protected SQLEditorSourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler overviewRuler) {
        return new SQLEditorSourceViewer(parent, ruler, overviewRuler, true, styles);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new SQLMarkerAnnotationAccess();
    }

    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return (T)adapter;
        }
        if (ITemplatesPage.class.equals(required)) {
            return (T)((Object)this.getTemplatesPage());
        }
        return (T)super.getAdapter(required);
    }

    public SQLTemplatesPage getTemplatesPage() {
        if (this.templatesPage == null) {
            this.templatesPage = new SQLTemplatesPage(this);
        }
        return this.templatesPage;
    }

    @Override
    public void dispose() {
        if (this.themeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
            this.themeListener = null;
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = DBeaverActivator.getCoreResourceBundle();
        TextOperationAction a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistProposal"), (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistTip"), (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistInfo"), (ITextEditor)this, 16);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.setAction("ContentAssistInfo", (IAction)a);
        a = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentFormatProposal"), (ITextEditor)this, 15);
        a.setActionDefinitionId("org.jkiss.dbeaver.ui.editors.text.content.format");
        this.setAction("ContentFormatProposal", (IAction)a);
        this.setAction("Preferences.ContextAction", (IAction)new Action("Preferences..."){

            public void run() {
                Shell shell = SQLEditorBase.this.getSourceViewer().getTextWidget().getShell();
                String[] preferencePages = SQLEditorBase.this.collectContextMenuPreferencePages();
                if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)preferencePages[0], (String[])preferencePages, (Object)SQLEditorBase.this.getEditorInput()).open();
                }
            }
        });
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator("content"));
        this.addAction(menu, "sql.extras", "ContentAssistProposal");
        this.addAction(menu, "sql.extras", "ContentAssistTip");
        this.addAction(menu, "sql.extras", "ContentAssistInfo");
        menu.insertBefore("additions", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), "org.jkiss.dbeaver.ui.editors.sql.navigate.object"));
        MenuManager formatMenu = new MenuManager("Format", "format");
        IAction formatAction = this.getAction("ContentFormatProposal");
        if (formatAction != null) {
            formatMenu.add(formatAction);
        }
        formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), "org.jkiss.dbeaver.ui.editors.sql.morph.delimited.list"));
        formatMenu.add(this.getAction("UpperCase"));
        formatMenu.add(this.getAction("LowerCase"));
        formatMenu.add((IContributionItem)new Separator());
        formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), "org.jkiss.dbeaver.ui.editors.sql.word.wrap"));
        formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), "org.jkiss.dbeaver.ui.editors.sql.comment.single"));
        formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), "org.jkiss.dbeaver.ui.editors.sql.comment.multi"));
        menu.insertAfter("sql.additions", (IContributionItem)formatMenu);
    }

    public void reloadSyntaxRules() {
        IVerticalRuler verticalRuler;
        SQLDialect dialect = this.getSQLDialect();
        this.syntaxManager.init(dialect, this.getActivePreferenceStore());
        this.ruleManager.refreshRules(this.getDataSource(), this.getEditorInput());
        Document document = this.getDocument();
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(dialect), SQLPartitionScanner.SQL_CONTENT_TYPES);
            partitioner.connect((IDocument)document);
            try {
                document.setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
            }
            catch (Throwable e) {
                log.warn((Object)"Error setting SQL partitioner", e);
            }
            ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
            if (projectionViewer != null && projectionViewer.getAnnotationModel() != null && document.getLength() > 0) {
                try {
                    projectionViewer.reinitializeProjection();
                }
                catch (Throwable ex) {
                    log.warn((Object)"Can't initialize SQL syntax projection", ex);
                }
            }
        }
        if (this.getSourceViewerConfiguration() instanceof SQLEditorSourceViewerConfiguration) {
            ((SQLEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).onDataSourceChange();
        }
        if ((verticalRuler = this.getVerticalRuler()) != null) {
            verticalRuler.update();
        }
    }

    public boolean hasActiveQuery() {
        Document document = this.getDocument();
        if (document == null) {
            return false;
        }
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        String selText = selection.getText();
        if (CommonUtils.isEmpty((String)selText) && selection.getOffset() >= 0 && selection.getOffset() < document.getLength()) {
            try {
                IRegion lineRegion = document.getLineInformationOfOffset(selection.getOffset());
                selText = document.get(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return false;
            }
        }
        return !CommonUtils.isEmptyTrimmed((String)selText);
    }

    @Nullable
    protected SQLScriptElement extractActiveQuery() {
        SQLScriptElement parsedElement;
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        String selText = selection.getText();
        if (this.getActivePreferenceStore().getBoolean("script.sql.query.remove.trailing.delimiter")) {
            selText = SQLUtils.trimQueryStatement((SQLSyntaxManager)this.getSyntaxManager(), (String)selText, (!this.syntaxManager.getDialect().isDelimiterAfterQuery() ? 1 : 0) != 0);
        }
        Object element = !CommonUtils.isEmpty((String)selText) ? ((parsedElement = this.parseQuery((IDocument)this.getDocument(), selection.getOffset(), selection.getOffset() + selection.getLength(), selection.getOffset(), false, false)) instanceof SQLControlCommand ? parsedElement : new SQLQuery(this.getDataSource(), selText, selection.getOffset(), selection.getLength())) : (selection.getOffset() >= 0 ? this.extractQueryAtPos(selection.getOffset()) : null);
        if (element == null || CommonUtils.isEmpty((String)element.getText())) {
            return null;
        }
        if (element instanceof SQLQuery && this.getActivePreferenceStore().getBoolean("sql.parameter.enabled")) {
            ((SQLQuery)element).setParameters(this.parseParameters((IDocument)this.getDocument(), (SQLQuery)element));
        }
        return element;
    }

    public SQLScriptElement extractQueryAtPos(int currentPos) {
        int currentLine;
        String[] statementDelimiters;
        boolean useBlankLines;
        int startPos;
        IDocumentPartitioner partitioner;
        Document document;
        block12: {
            block13: {
                document = this.getDocument();
                if (document == null || document.getLength() == 0) {
                    return null;
                }
                int docLength = document.getLength();
                partitioner = document.getDocumentPartitioner("___sql_partitioning");
                if (partitioner != null) {
                    while (currentPos < docLength && SQLEditorBase.isMultiCommentPartition(partitioner, currentPos)) {
                        ++currentPos;
                    }
                }
                startPos = 0;
                useBlankLines = this.syntaxManager.isBlankLineDelimiter();
                statementDelimiters = this.syntaxManager.getStatementDelimiters();
                currentLine = document.getLineOfOffset(currentPos);
                if (!useBlankLines || !TextUtils.isEmptyLine((IDocument)document, currentLine)) break block12;
                if (currentLine != 0) break block13;
                return null;
            }
            if (!TextUtils.isEmptyLine((IDocument)document, --currentLine)) break block12;
            return null;
        }
        try {
            int lineOffset = document.getLineOffset(currentLine);
            int firstLine = currentLine;
            while (firstLine > 0) {
                if (useBlankLines) {
                    if (TextUtils.isEmptyLine((IDocument)document, firstLine) && SQLEditorBase.isDefaultPartition(partitioner, document.getLineOffset(firstLine))) {
                        break;
                    }
                } else {
                    String[] stringArray = statementDelimiters;
                    int n = statementDelimiters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String delim = stringArray[n2];
                        int offset = TextUtils.getOffsetOf((IDocument)document, firstLine, delim);
                        if (offset >= 0 && SQLEditorBase.isDefaultPartition(partitioner, offset)) break;
                        ++n2;
                    }
                }
                --firstLine;
            }
            startPos = document.getLineOffset(firstLine);
            currentPos = lineOffset;
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
        return this.parseQuery((IDocument)document, startPos, document.getLength(), currentPos, false, false);
    }

    public SQLScriptElement extractNextQuery(boolean next) {
        int curPos;
        block16: {
            ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
            int offset = selection.getOffset();
            SQLScriptElement curElement = this.extractQueryAtPos(offset);
            if (curElement == null) {
                return null;
            }
            Document document = this.getDocument();
            if (document == null) {
                return null;
            }
            try {
                int docLength = document.getLength();
                if (next) {
                    String[] statementDelimiters = this.syntaxManager.getStatementDelimiters();
                    curPos = curElement.getOffset() + curElement.getLength();
                    while (curPos < docLength) {
                        char c = document.getChar(curPos);
                        if (!Character.isWhitespace(c)) {
                            boolean isDelimiter = false;
                            String[] stringArray = statementDelimiters;
                            int n = statementDelimiters.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String delim = stringArray[n2];
                                if (delim.indexOf(c) != -1) {
                                    isDelimiter = true;
                                }
                                ++n2;
                            }
                            if (!isDelimiter) break;
                        }
                        ++curPos;
                    }
                } else {
                    curPos = curElement.getOffset() - 1;
                    while (curPos >= 0) {
                        char c = document.getChar(curPos);
                        if (Character.isWhitespace(c)) {
                            --curPos;
                            continue;
                        }
                        break;
                    }
                }
                if (curPos > 0 && curPos < docLength) break block16;
                return null;
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return null;
            }
        }
        return this.extractQueryAtPos(curPos);
    }

    private static boolean isDefaultPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner == null || "__dftl_partition_content_type".equals(partitioner.getContentType(currentPos));
    }

    private static boolean isMultiCommentPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner != null && "sql_multiline_comment".equals(partitioner.getContentType(currentPos));
    }

    private void startScriptEvaluation() {
        this.ruleManager.startEval();
    }

    private void endScriptEvaluation() {
        this.ruleManager.endEval();
    }

    public List<SQLScriptElement> extractScriptQueries(int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        ArrayList<SQLScriptElement> queryList = new ArrayList<SQLScriptElement>();
        Document document = this.getDocument();
        if (document == null) {
            return queryList;
        }
        this.startScriptEvaluation();
        try {
            SQLScriptElement query;
            int queryOffset = startOffset;
            while ((query = this.parseQuery((IDocument)document, queryOffset, startOffset + length, queryOffset, scriptMode, keepDelimiters)) != null) {
                queryList.add(query);
                queryOffset = query.getOffset() + query.getLength();
            }
        }
        finally {
            this.endScriptEvaluation();
        }
        if (parseParameters && this.getActivePreferenceStore().getBoolean("sql.parameter.enabled")) {
            for (SQLScriptElement query : queryList) {
                if (!(query instanceof SQLQuery)) continue;
                ((SQLQuery)query).setParameters(this.parseParameters((IDocument)this.getDocument(), (SQLQuery)query));
            }
        }
        return queryList;
    }

    /*
     * Exception decompiling
     */
    protected SQLScriptElement parseQuery(IDocument document, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int countLineFeeds(IDocument document, int offset, int length) {
        int lfCount = 0;
        try {
            int i = offset;
            while (i < offset + length) {
                if (document.getChar(i) == '\n') {
                    ++lfCount;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return lfCount;
    }

    protected List<SQLQueryParameter> parseParameters(IDocument document, int queryOffset, int queryLength) {
        SQLDialect sqlDialect = this.getSQLDialect();
        boolean supportParamsInDDL = this.getActivePreferenceStore().getBoolean("sql.parameter.ddl.enabled");
        boolean execQuery = false;
        ArrayList<SQLQueryParameter> parameters = null;
        this.ruleManager.setRange(document, queryOffset, queryLength);
        boolean firstKeyword = true;
        while (true) {
            IToken token = this.ruleManager.nextToken();
            int tokenOffset = this.ruleManager.getTokenOffset();
            int tokenLength = this.ruleManager.getTokenLength();
            if (token.isEOF() || tokenOffset > queryOffset + queryLength) break;
            int tokenType = 1000;
            if (token instanceof SQLToken) {
                tokenType = ((SQLToken)token).getType();
            }
            if (token.isWhitespace() || tokenType == 1005) continue;
            if (!supportParamsInDDL && firstKeyword) {
                String tokenText;
                block21: {
                    tokenText = document.get(tokenOffset, tokenLength);
                    if (!ArrayUtils.containsIgnoreCase((String[])sqlDialect.getDDLKeywords(), (String)tokenText)) break block21;
                    return null;
                }
                try {
                    execQuery = ArrayUtils.containsIgnoreCase((String[])sqlDialect.getExecuteKeywords(), (String)tokenText);
                }
                catch (BadLocationException e) {
                    log.warn((Object)e);
                }
                firstKeyword = false;
            }
            if (tokenType != 1009 || tokenLength <= 0) continue;
            try {
                String paramName = document.get(tokenOffset, tokenLength);
                if (execQuery && paramName.equals("?")) continue;
                if (parameters == null) {
                    parameters = new ArrayList<SQLQueryParameter>();
                }
                SQLQueryParameter parameter = new SQLQueryParameter(parameters.size(), paramName, tokenOffset - queryOffset, tokenLength);
                SQLQueryParameter previous = null;
                if (parameter.isNamed()) {
                    int i = parameters.size();
                    while (i > 0) {
                        if (((SQLQueryParameter)parameters.get(i - 1)).getName().equals(paramName)) {
                            previous = (SQLQueryParameter)parameters.get(i - 1);
                            break;
                        }
                        --i;
                    }
                }
                parameter.setPrevious(previous);
                parameters.add(parameter);
            }
            catch (BadLocationException e) {
                log.warn((Object)"Can't extract query parameter", (Throwable)e);
            }
        }
        if (this.syntaxManager.isVariablesEnabled()) {
            try {
                String query = document.get(queryOffset, queryLength);
                Matcher matcher = SQLVariableRule.VARIABLE_PATTERN.matcher(query);
                int position = 0;
                while (matcher.find(position)) {
                    int start = matcher.start();
                    int orderPos = 0;
                    SQLQueryParameter param = null;
                    if (parameters != null) {
                        for (SQLQueryParameter p : parameters) {
                            if (p.getTokenOffset() == start) {
                                param = p;
                                break;
                            }
                            if (p.getTokenOffset() >= start) continue;
                            ++orderPos;
                        }
                    }
                    if (param == null) {
                        param = new SQLQueryParameter(orderPos, matcher.group(0), start, matcher.end() - matcher.start());
                        if (parameters == null) {
                            parameters = new ArrayList();
                        }
                        parameters.add(param.getOrdinalPosition(), param);
                    }
                    position = matcher.end();
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)"Error parsing variables", (Throwable)e);
            }
        }
        return parameters;
    }

    protected List<SQLQueryParameter> parseParameters(IDocument document, SQLQuery query) {
        return this.parseParameters(document, query.getOffset(), query.getLength());
    }

    protected List<SQLQueryParameter> parseParameters(String query) {
        return this.parseParameters((IDocument)new Document(query), 0, query.length());
    }

    public boolean isDisposed() {
        return this.getSourceViewer() == null || this.getSourceViewer().getTextWidget() == null || this.getSourceViewer().getTextWidget().isDisposed();
    }

    @Override
    @Nullable
    public ICommentsSupport getCommentsSupport() {
        final SQLDialect dialect = this.getSQLDialect();
        return new ICommentsSupport(){

            @Override
            @Nullable
            public Pair<String, String> getMultiLineComments() {
                return dialect.getMultiLineComments();
            }

            @Override
            public String[] getSingleLineComments() {
                return dialect.getSingleLineComments();
            }
        };
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 5];
        more[ids.length] = "org.jkiss.dbeaver.preferences.main.sqleditor";
        more[ids.length + 1] = "org.jkiss.dbeaver.preferences.main.sqlexecute";
        more[ids.length + 2] = "org.jkiss.dbeaver.preferences.main.sql.completion";
        more[ids.length + 3] = "org.jkiss.dbeaver.preferences.main.sql.format";
        more[ids.length + 4] = "org.jkiss.dbeaver.preferences.main.sql.templates";
        System.arraycopy(ids, 0, more, 0, ids.length);
        return more;
    }

    @Override
    public boolean visualizeError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error) {
        Document document = this.getDocument();
        SQLQuery query = new SQLQuery(this.getDataSource(), document.get(), 0, document.getLength());
        return this.scrollCursorToError(monitor, query, error);
    }

    protected boolean scrollCursorToError(@NotNull DBRProgressMonitor monitor, @NotNull SQLQuery query, @NotNull Throwable error) {
        try {
            DBPErrorAssistant.ErrorPosition[] positions;
            DBCExecutionContext context = this.getExecutionContext();
            boolean scrolled = false;
            DBPErrorAssistant errorAssistant = (DBPErrorAssistant)DBUtils.getAdapter(DBPErrorAssistant.class, (Object)context.getDataSource());
            if (errorAssistant != null && (positions = errorAssistant.getErrorPosition(monitor, context, query.getText(), error)) != null && positions.length > 0) {
                int queryStartOffset = query.getOffset();
                int queryLength = query.getLength();
                DBPErrorAssistant.ErrorPosition pos = positions[0];
                if (pos.line < 0) {
                    if (pos.position >= 0) {
                        this.getSelectionProvider().setSelection((ISelection)new TextSelection(queryStartOffset + pos.position, 1));
                        scrolled = true;
                    }
                } else {
                    Document document = this.getDocument();
                    if (document != null) {
                        int errorLength;
                        int startLine = document.getLineOfOffset(queryStartOffset);
                        int errorOffset = document.getLineOffset(startLine + pos.line);
                        if (pos.position >= 0) {
                            errorOffset += pos.position;
                            errorLength = 1;
                        } else {
                            errorLength = document.getLineLength(startLine + pos.line);
                        }
                        if (errorOffset < queryStartOffset) {
                            errorOffset = queryStartOffset;
                        }
                        if (errorLength > queryLength) {
                            errorLength = queryLength;
                        }
                        this.getSelectionProvider().setSelection((ISelection)new TextSelection(errorOffset, errorLength));
                        scrolled = true;
                    }
                }
            }
            return scrolled;
        }
        catch (Exception e) {
            log.warn((Object)"Error positioning on query error", (Throwable)e);
            return false;
        }
    }

    public boolean isFoldingEnabled() {
        return this.getActivePreferenceStore().getBoolean("SQLEditor.Folding.enabled");
    }
}

