/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;

public class CreateSequencePage
extends BaseObjectEditPage {
    private DBSObjectContainer container;
    private String name;
    private DBSProcedureType type;

    public CreateSequencePage(DBSObjectContainer container) {
        super(CoreMessages.dialog_struct_create_procedure_title);
        this.container = container;
    }

    @Override
    protected Control createPageContents(Composite parent) {
        Composite propsGroup = new Composite(parent, 0);
        propsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        propsGroup.setLayoutData((Object)gd);
        UIUtils.createLabelText(propsGroup, "Container", DBUtils.getObjectFullName((DBPNamedObject)this.container, (DBPEvaluationContext)DBPEvaluationContext.UI)).setEditable(false);
        final Text nameText = UIUtils.createLabelText(propsGroup, "Sequence Name", null);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSequencePage.this.name = nameText.getText();
            }
        });
        return propsGroup;
    }

    public DBSProcedureType getProcedureType() {
        return this.type;
    }

    public String getSequenceName() {
        return DBObjectNameCaseTransformer.transformName((DBPDataSource)this.container.getDataSource(), (String)this.name);
    }
}

