/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import org.eclipse.core.expressions.PropertyTester;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;

public class EntityEditorPropertyTester
extends PropertyTester {
    private static final Log log = Log.getLog(EntityEditorPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.entity";
    public static final String PROP_DIRTY = "dirty";
    public static final String PROP_CAN_UNDO = "canUndo";
    public static final String PROP_CAN_REDO = "canRedo";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block14: {
            if (!(receiver instanceof EntityEditor)) {
                return false;
            }
            EntityEditor editor = (EntityEditor)receiver;
            DBECommandContext commandContext = editor.getEditorInput().getCommandContext();
            if (commandContext == null) break block14;
            switch (property) {
                case "canUndo": {
                    return commandContext.getUndoCommand() != null;
                }
                case "canRedo": {
                    return commandContext.getRedoCommand() != null;
                }
                case "dirty": {
                    return editor.isDirty();
                }
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState("org.jkiss.dbeaver.ui.editors.entity." + propName);
    }
}

