/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.INonPersistentEditorInput;
import org.jkiss.dbeaver.ui.editors.IPersistentStorage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class StringEditorInput
implements INonPersistentEditorInput,
IStorageEditorInput {
    public static final IEditorInput EMPTY_INPUT = new StringEditorInput("<empty>", "", true, GeneralUtils.getDefaultFileEncoding());
    private String name;
    private StringBuilder buffer;
    private boolean readOnly;
    private IStorage storage;
    private Charset charset;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public StringEditorInput(String name, CharSequence value, boolean readOnly, String charset) {
        this.name = name;
        this.buffer = new StringBuilder(value);
        this.readOnly = readOnly;
        this.charset = Charset.forName(charset);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_INFO);
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        if (this.storage == null) {
            this.storage = new StringStorage();
        }
        return this.storage;
    }

    public String getToolTipText() {
        return this.name;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public void setText(String text) {
        this.buffer.setLength(0);
        this.buffer.append(text);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IStorage.class) {
            return adapter.cast(this.getStorage());
        }
        return null;
    }

    @Override
    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    private class StringStorage
    implements IPersistentStorage,
    IEncodedStorage {
        private StringStorage() {
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(StringEditorInput.this.buffer.toString().getBytes(StringEditorInput.this.charset));
        }

        public IPath getFullPath() {
            return null;
        }

        public String getName() {
            return StringEditorInput.this.name;
        }

        public boolean isReadOnly() {
            return StringEditorInput.this.readOnly;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        @Override
        public void setContents(IProgressMonitor monitor, InputStream stream) throws CoreException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtils.copyStream((InputStream)stream, (OutputStream)baos);
                StringEditorInput.this.buffer.setLength(0);
                StringEditorInput.this.buffer.append(new String(baos.toByteArray(), StringEditorInput.this.charset));
            }
            catch (IOException e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
            }
        }

        public String getCharset() throws CoreException {
            return StringEditorInput.this.charset.name();
        }
    }
}

