/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;

public abstract class AbstractToolWizardPage<WIZARD extends AbstractToolWizard>
extends WizardPage {
    protected final WIZARD wizard;
    protected Text extraCommandArgsText;

    protected AbstractToolWizardPage(WIZARD wizard, String pageName) {
        super(pageName);
        this.wizard = wizard;
    }

    public boolean isPageComplete() {
        return ((AbstractToolWizard)((Object)this.wizard)).getClientHome() != null && super.isPageComplete();
    }

    protected static void createCheckButtons(Composite buttonsPanel, Table table) {
        UIUtils.createPushButton(buttonsPanel, "All", null, (SelectionListener)new CheckListener(table, true));
        UIUtils.createPushButton(buttonsPanel, "None", null, (SelectionListener)new CheckListener(table, false));
    }

    protected void createExtraArgsInput(Composite outputGroup) {
        this.extraCommandArgsText = UIUtils.createLabelText(outputGroup, "Extra command args", ((AbstractToolWizard)((Object)this.wizard)).getExtraCommandArgs());
        this.extraCommandArgsText.setToolTipText("Set extra command args for tool executable.");
        UIUtils.installContentProposal((Control)this.extraCommandArgsText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[0]));
        this.extraCommandArgsText.addModifyListener(e -> ((AbstractToolWizard)((Object)((Object)this.wizard))).setExtraCommandArgs(this.extraCommandArgsText.getText()));
    }

    private static class CheckListener
    extends SelectionAdapter {
        private final Table table;
        private final boolean check;

        public CheckListener(Table table, boolean check) {
            this.table = table;
            this.check = check;
        }

        public void widgetSelected(SelectionEvent e) {
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(this.check);
                ++n2;
            }
        }
    }
}

