/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import java.io.File;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;

public abstract class AbstractImportExportWizard<PROCESS_ARG>
extends AbstractToolWizard<DBSObject, PROCESS_ARG>
implements IExportWizard {
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_TABLE = "table";
    public static final String VARIABLE_DATE = "date";
    public static final String VARIABLE_TIMESTAMP = "timestamp";
    protected File outputFolder = new File(DialogUtils.getCurDialogFolder());
    protected String outputFilePattern;

    protected AbstractImportExportWizard(Collection<DBSObject> objects, String title) {
        super(objects, title);
    }

    @Override
    protected boolean isSingleTimeWizard() {
        return false;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        if (outputFolder != null) {
            DialogUtils.setCurDialogFolder(outputFolder.getAbsolutePath());
        }
        this.outputFolder = outputFolder;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.task);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.logPage);
    }

    @Override
    public boolean performFinish() {
        File dir;
        if (this.isExportWizard() && !(dir = this.outputFolder).exists() && !dir.mkdirs()) {
            this.logPage.setMessage("Can't create directory '" + dir.getAbsolutePath() + "'", 3);
            this.getContainer().updateMessage();
            return false;
        }
        return super.performFinish();
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    public boolean isExportWizard() {
        return true;
    }

    @Override
    protected void startProcessHandler(DBRProgressMonitor monitor, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process) {
        this.logPage.startLogReader(processBuilder, process.getErrorStream());
    }
}

