/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.net;

import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.impl.net.SSHConstants;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class HTTPTunnelConfiguratorUI
implements IObjectPropertyConfigurator<DBWHandlerConfiguration> {
    private Text hostText;
    private Spinner portText;
    private Text userNameText;
    private Text passwordText;
    private Button savePasswordCheckbox;
    private Spinner keepAliveText;
    private Spinner tunnelTimeout;

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.hostText = UIUtils.createLabelText(composite, CoreMessages.model_ssh_configurator_label_host_ip, null);
        this.hostText.setLayoutData((Object)new GridData(768));
        this.portText = UIUtils.createLabelSpinner(composite, CoreMessages.model_ssh_configurator_label_port, 22, 0, 65535);
        this.userNameText = UIUtils.createLabelText(composite, CoreMessages.model_ssh_configurator_label_user_name, null);
        this.userNameText.setLayoutData((Object)new GridData(768));
        this.passwordText = UIUtils.createLabelText(composite, CoreMessages.model_ssh_configurator_label_password, "", 0x400800);
        UIUtils.createPlaceholder(composite, 1);
        this.savePasswordCheckbox = UIUtils.createCheckbox(composite, CoreMessages.model_ssh_configurator_checkbox_save_pass, false);
        this.keepAliveText = UIUtils.createLabelSpinner(composite, CoreMessages.model_ssh_configurator_label_keep_alive, 0, 0, Integer.MAX_VALUE);
        this.tunnelTimeout = UIUtils.createLabelSpinner(composite, CoreMessages.model_ssh_configurator_label_tunnel_timeout, 10000, 0, 300000);
    }

    @Override
    public void loadSettings(DBWHandlerConfiguration configuration) {
        String timeoutString;
        this.hostText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("host"))));
        String portString = (String)configuration.getProperties().get("port");
        if (!CommonUtils.isEmpty((String)portString)) {
            this.portText.setSelection(CommonUtils.toInt((Object)portString));
        }
        this.userNameText.setText(CommonUtils.notEmpty((String)configuration.getUserName()));
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        String authTypeName = (String)configuration.getProperties().get("authType");
        if (!CommonUtils.isEmpty((String)authTypeName)) {
            authType = SSHConstants.AuthType.valueOf((String)authTypeName);
        }
        this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getPassword()));
        this.savePasswordCheckbox.setSelection(configuration.isSavePassword());
        String kaString = (String)configuration.getProperties().get("aliveInterval");
        if (!CommonUtils.isEmpty((String)kaString)) {
            this.keepAliveText.setSelection(Integer.parseInt(kaString));
        }
        if (!CommonUtils.isEmpty((String)(timeoutString = (String)configuration.getProperties().get("sshConnectTimeout")))) {
            this.tunnelTimeout.setSelection(CommonUtils.toInt((Object)timeoutString));
        }
    }

    @Override
    public void saveSettings(DBWHandlerConfiguration configuration) {
        Map properties = configuration.getProperties();
        properties.clear();
        properties.put("host", this.hostText.getText());
        properties.put("port", this.portText.getText());
        configuration.setUserName(this.userNameText.getText());
        configuration.setPassword(this.passwordText.getText());
        configuration.setSavePassword(this.savePasswordCheckbox.getSelection());
        int kaInterval = this.keepAliveText.getSelection();
        if (kaInterval <= 0) {
            properties.remove("aliveInterval");
        } else {
            properties.put("aliveInterval", String.valueOf(kaInterval));
        }
        properties.put("sshConnectTimeout", this.tunnelTimeout.getText());
    }

    @Override
    public boolean isComplete() {
        return false;
    }
}

