/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.exec;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorResponse;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ExecutionQueueErrorJob
extends AbstractUIJob {
    private String errorName;
    private Throwable error;
    private boolean queue;
    private ExecutionQueueErrorResponse response = ExecutionQueueErrorResponse.STOP;

    public ExecutionQueueErrorJob(String errorName, Throwable error, boolean queue) {
        super("Execution Error Job");
        this.errorName = errorName;
        this.error = error;
        this.queue = queue;
    }

    @Override
    public IStatus runInUIThread(DBRProgressMonitor monitor) {
        ExecutionQueueErrorDialog dialog = new ExecutionQueueErrorDialog(DBeaverUI.getActiveWorkbenchShell(), "Execution Error", "Error occurred during " + this.errorName, GeneralUtils.makeExceptionStatus((Throwable)this.error), 7, this.queue);
        int result = dialog.open();
        switch (result) {
            case 1: 
            case 6: {
                this.response = ExecutionQueueErrorResponse.STOP;
                break;
            }
            case 5: {
                this.response = ExecutionQueueErrorResponse.IGNORE;
                break;
            }
            case 8: {
                this.response = ExecutionQueueErrorResponse.RETRY;
                break;
            }
            case 9: {
                this.response = ExecutionQueueErrorResponse.IGNORE_ALL;
                break;
            }
            default: {
                this.response = ExecutionQueueErrorResponse.STOP;
            }
        }
        return Status.OK_STATUS;
    }

    public ExecutionQueueErrorResponse getResponse() {
        return this.response;
    }

    public static ExecutionQueueErrorResponse showError(String task, Throwable error, boolean queue) {
        ExecutionQueueErrorJob errorJob = new ExecutionQueueErrorJob(task, error, queue);
        errorJob.schedule();
        try {
            errorJob.join();
        }
        catch (InterruptedException e1) {
            log.error((Object)e1);
        }
        return errorJob.getResponse();
    }
}

