/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

class EditMavenArtifactDialog
extends Dialog {
    private MavenArtifactReference artifact;
    private Text groupText;
    private Text artifactText;
    private Text classifierText;
    private Combo versionText;

    public EditMavenArtifactDialog(Shell shell, MavenArtifactReference artifact) {
        super(shell);
        this.artifact = artifact == null ? new MavenArtifactReference("", "", null, "RELEASE") : artifact;
    }

    public MavenArtifactReference getArtifact() {
        return this.artifact;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_edit_driver_edit_maven_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        this.groupText = UIUtils.createLabelText(composite, CoreMessages.dialog_edit_driver_edit_maven_group_id_label, this.artifact.getGroupId());
        this.groupText.setLayoutData((Object)gd);
        this.artifactText = UIUtils.createLabelText(composite, CoreMessages.dialog_edit_driver_edit_maven_artifact_id_label, this.artifact.getArtifactId());
        this.artifactText.setLayoutData((Object)gd);
        this.classifierText = UIUtils.createLabelText(composite, CoreMessages.dialog_edit_driver_edit_maven_classfier_label, CommonUtils.notEmpty((String)this.artifact.getClassifier()));
        this.classifierText.setLayoutData((Object)gd);
        this.versionText = UIUtils.createLabelCombo(composite, CoreMessages.dialog_edit_driver_edit_maven_version_label, 2052);
        this.versionText.setLayoutData((Object)gd);
        this.versionText.setText(this.artifact.getVersion());
        this.versionText.add("RELEASE");
        this.versionText.add("LATEST");
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditMavenArtifactDialog.this.updateButtons();
            }
        };
        this.groupText.addModifyListener(ml);
        this.artifactText.addModifyListener(ml);
        this.classifierText.addModifyListener(ml);
        this.versionText.addModifyListener(ml);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(!CommonUtils.isEmpty((String)this.groupText.getText()) && !CommonUtils.isEmpty((String)this.artifactText.getText()) && !CommonUtils.isEmpty((String)this.versionText.getText()));
    }

    protected void okPressed() {
        String classifier = this.classifierText.getText();
        this.artifact = new MavenArtifactReference(this.groupText.getText(), this.artifactText.getText(), CommonUtils.isEmpty((String)classifier) ? null : classifier, this.versionText.getText());
        super.okPressed();
    }
}

