/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageAbstract
extends DialogPage
implements IDataSourceConnectionEditor {
    protected IDataSourceConnectionEditorSite site;
    protected Text driverText;

    public IDataSourceConnectionEditorSite getSite() {
        return this.site;
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public void setSite(IDataSourceConnectionEditorSite site) {
        this.site = site;
    }

    protected boolean isCustomURL() {
        return false;
    }

    @Override
    public void loadSettings() {
        DBPDriver driver = this.site.getDriver();
        if (driver != null && this.driverText != null) {
            this.driverText.setText(CommonUtils.toString((Object)driver.getFullName()));
        }
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }

    protected void saveConnectionURL(DBPConnectionConfiguration connectionInfo) {
        if (!this.isCustomURL()) {
            connectionInfo.setUrl(this.site.getDriver().getDataSourceProvider().getConnectionURL(this.site.getDriver(), connectionInfo));
        }
    }

    protected void createDriverPanel(Composite parent) {
        int numColumns = ((GridLayout)parent.getLayout()).numColumns;
        Composite panel = UIUtils.createPlaceholder(parent, 4, 5);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        panel.setLayoutData((Object)gd);
        Composite placeholder = UIUtils.createPlaceholder(panel, 2);
        gd = new GridData(808);
        gd.horizontalSpan = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        placeholder.setLayoutData((Object)gd);
        if (DBeaverCore.getGlobalPreferenceStore().getBoolean("database.connect.processEnvVars")) {
            CLabel infoLabel = UIUtils.createInfoLabel(placeholder, CoreMessages.dialog_connection_edit_connection_settings_variables_hint_label);
            gd = new GridData(800);
            gd.grabExcessHorizontalSpace = true;
            infoLabel.setLayoutData((Object)gd);
            infoLabel.setToolTipText("You can use OS environment variables in connection parameters.\nUse ${variable} patterns.");
        }
        if (!this.site.isNew() && !this.site.getDriver().isEmbedded()) {
            Link netConfigLink = new Link(placeholder, 0);
            netConfigLink.setText("<a>" + CoreMessages.dialog_connection_edit_wizard_conn_conf_network_link + "</a>");
            netConfigLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageAbstract.this.site.openSettingsPage("networkHandlersSettings");
                }
            });
            netConfigLink.setLayoutData((Object)new GridData(128));
        }
        Label divLabel = new Label(panel, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        divLabel.setLayoutData((Object)gd);
        Label driverLabel = new Label(panel, 0);
        driverLabel.setText(CoreMessages.dialog_connection_driver);
        gd = new GridData(128);
        driverLabel.setLayoutData((Object)gd);
        this.driverText = new Text(panel, 8);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.driverText.setLayoutData((Object)gd);
        Button driverButton = new Button(panel, 8);
        driverButton.setText(CoreMessages.dialog_connection_edit_driver_button);
        gd = new GridData(128);
        driverButton.setLayoutData((Object)gd);
        driverButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ConnectionPageAbstract.this.site.openDriverEditor()) {
                    ConnectionPageAbstract.this.updateDriverInfo(ConnectionPageAbstract.this.site.getDriver());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void updateDriverInfo(DBPDriver driver) {
    }
}

