/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.utils.CommonUtils;

public class StreamValueManagerDescriptor
extends AbstractDescriptor {
    public static final String TAG_STREAM_MANAGER = "streamManager";
    private static final String ATTR_PRIMARY_MIME = "primaryMime";
    private static final String ATTR_SUPPORTED_MIME = "supportedMime";
    private String id;
    private AbstractDescriptor.ObjectType implType;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final String primaryMime;
    private final String[] supportedMime;
    private IStreamValueManager instance;

    public StreamValueManagerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.primaryMime = config.getAttribute(ATTR_PRIMARY_MIME);
        this.supportedMime = CommonUtils.notEmpty((String)config.getAttribute(ATTR_SUPPORTED_MIME)).split(",");
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String[] getSupportedMime() {
        return this.supportedMime;
    }

    public String getPrimaryMime() {
        return this.primaryMime;
    }

    @NotNull
    public IStreamValueManager getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (IStreamValueManager)this.implType.createInstance(IStreamValueManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate content value manager '" + this.id + "'", e);
            }
        }
        return this.instance;
    }

    public String toString() {
        return String.valueOf(this.id) + " (" + this.label + ")";
    }
}

