/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSConstraintEnumerable;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.editors.data.DatabaseDataEditor;
import org.jkiss.dbeaver.ui.editors.object.struct.EditDictionaryPage;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class ReferenceValueEditor {
    private static final Log log = Log.getLog(ReferenceValueEditor.class);
    private IValueController valueController;
    private IValueEditor valueEditor;
    private DBSEntityReferrer refConstraint;
    private Table editorSelector;
    private SelectorLoaderJob loaderJob = null;

    public ReferenceValueEditor(IValueController valueController, IValueEditor valueEditor) {
        this.valueController = valueController;
        this.valueEditor = valueEditor;
    }

    public boolean isReferenceValue() {
        return this.getEnumerableConstraint() != null;
    }

    @Nullable
    private DBSEntityReferrer getEnumerableConstraint() {
        if (this.valueController instanceof IAttributeController) {
            return ReferenceValueEditor.getEnumerableConstraint(((IAttributeController)this.valueController).getBinding());
        }
        return null;
    }

    public static DBSEntityReferrer getEnumerableConstraint(DBDAttributeBinding binding) {
        try {
            DBSEntityAttribute entityAttribute = binding.getEntityAttribute();
            if (entityAttribute != null) {
                DBSConstraintEnumerable refConstraint;
                DBSEntityReferrer constraint;
                List refs = DBUtils.getAttributeReferrers((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityAttribute)entityAttribute);
                DBSEntityReferrer dBSEntityReferrer = constraint = refs.isEmpty() ? null : (DBSEntityReferrer)refs.get(0);
                if (constraint instanceof DBSEntityAssociation && ((DBSEntityAssociation)constraint).getReferencedConstraint() instanceof DBSConstraintEnumerable && (refConstraint = (DBSConstraintEnumerable)((DBSEntityAssociation)constraint).getReferencedConstraint()) != null && refConstraint.supportsEnumeration()) {
                    return constraint;
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return null;
    }

    public boolean createEditorSelector(final Composite parent) {
        DBSEntityAssociation association;
        if (!(this.valueController instanceof IAttributeController) || this.valueController.isReadOnly()) {
            return false;
        }
        this.refConstraint = this.getEnumerableConstraint();
        if (this.refConstraint == null) {
            return false;
        }
        if (this.refConstraint instanceof DBSEntityAssociation && (association = (DBSEntityAssociation)this.refConstraint).getReferencedConstraint() != null) {
            final DBSEntity refTable = association.getReferencedConstraint().getParentObject();
            Composite labelGroup = UIUtils.createPlaceholder(parent, 2);
            labelGroup.setLayoutData((Object)new GridData(768));
            Link dictLabel = UIUtils.createLink(labelGroup, NLS.bind((String)CoreMessages.dialog_value_view_label_dictionary, (Object)refTable.getName()), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    final IWorkbenchWindow window = ReferenceValueEditor.this.valueController.getValueSite().getWorkbenchWindow();
                    DBeaverUI.runInUI((IRunnableContext)window, new DBRRunnableWithProgress(){

                        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            DBNDatabaseNode tableNode = NavigatorUtils.getNodeByObject(monitor, (DBSObject)refTable, true);
                            if (tableNode != null) {
                                NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)tableNode, DatabaseDataEditor.class.getName(), window);
                            }
                        }
                    });
                }
            });
            dictLabel.setLayoutData((Object)new GridData(32));
            Link hintLabel = UIUtils.createLink(labelGroup, "(<a>Define Description</a>)", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditDictionaryPage editDictionaryPage = new EditDictionaryPage("Dictionary structure", refTable);
                    if (editDictionaryPage.edit(parent.getShell())) {
                        ReferenceValueEditor.this.loaderJob.schedule();
                    }
                }
            });
            hintLabel.setLayoutData((Object)new GridData(896));
        }
        this.editorSelector = new Table(parent, 68356);
        this.editorSelector.setLinesVisible(true);
        this.editorSelector.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.editorSelector.setLayoutData((Object)gd);
        UIUtils.createTableColumn(this.editorSelector, 16384, CoreMessages.dialog_value_view_column_value);
        UIUtils.createTableColumn(this.editorSelector, 16384, CoreMessages.dialog_value_view_column_description);
        UIUtils.packColumns(this.editorSelector);
        this.editorSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = ReferenceValueEditor.this.editorSelector.getSelection();
                if (selection != null && selection.length > 0) {
                    Object value = selection[0].getData();
                    try {
                        ReferenceValueEditor.this.valueEditor.primeEditorValue(value);
                    }
                    catch (DBException e1) {
                        log.error((Object)e1);
                    }
                }
            }
        });
        Control control = this.valueEditor.getControl();
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object curEditorValue;
                try {
                    curEditorValue = ReferenceValueEditor.this.valueEditor.extractEditorValue();
                }
                catch (DBException e1) {
                    log.error((Object)e1);
                    return;
                }
                String curTextValue = ReferenceValueEditor.this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)ReferenceValueEditor.this.valueController).getBinding(), curEditorValue, DBDDisplayFormat.UI);
                boolean valueFound = false;
                TableItem[] tableItemArray = ReferenceValueEditor.this.editorSelector.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getText(0).equals(curTextValue)) {
                        ReferenceValueEditor.this.editorSelector.select(ReferenceValueEditor.this.editorSelector.indexOf(item));
                        ReferenceValueEditor.this.editorSelector.showItem(item);
                        valueFound = true;
                        break;
                    }
                    ++n2;
                }
                if (!valueFound) {
                    if (ReferenceValueEditor.this.loaderJob.getState() == 4) {
                        ReferenceValueEditor.this.loaderJob.cancel();
                        ReferenceValueEditor.this.loaderJob = new SelectorLoaderJob();
                    }
                    ReferenceValueEditor.this.loaderJob.setPattern(curEditorValue);
                    if (ReferenceValueEditor.this.loaderJob.getState() != 2) {
                        ReferenceValueEditor.this.loaderJob.schedule(100L);
                    }
                }
            }
        };
        if (control instanceof Text) {
            ((Text)control).addModifyListener(modifyListener);
        } else if (control instanceof StyledText) {
            ((StyledText)control).addModifyListener(modifyListener);
        }
        this.loaderJob = new SelectorLoaderJob();
        Object curValue = this.valueController.getValue();
        if (curValue instanceof Number) {
            this.loaderJob.setPattern(curValue);
        }
        this.loaderJob.schedule(500L);
        return true;
    }

    private void updateDictionarySelector(Map<Object, String> keyValues, DBSEntityAttributeRef keyColumn, DBDValueHandler keyHandler) {
        if (this.editorSelector == null || this.editorSelector.isDisposed()) {
            return;
        }
        this.editorSelector.setRedraw(false);
        try {
            this.editorSelector.removeAll();
            for (Map.Entry<Object, String> entry : keyValues.entrySet()) {
                TableItem discItem = new TableItem(this.editorSelector, 0);
                discItem.setText(0, keyHandler.getValueDisplayString((DBSTypedObject)keyColumn.getAttribute(), entry.getKey(), DBDDisplayFormat.UI));
                discItem.setText(1, entry.getValue());
                discItem.setData(entry.getKey());
            }
            Control editorControl = this.valueEditor.getControl();
            if (editorControl != null && !editorControl.isDisposed()) {
                try {
                    Object curValue = this.valueEditor.extractEditorValue();
                    String curTextValue = this.valueController.getValueHandler().getValueDisplayString((DBSTypedObject)((IAttributeController)this.valueController).getBinding(), curValue, DBDDisplayFormat.UI);
                    TableItem curItem = null;
                    TableItem[] tableItemArray = this.editorSelector.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getText(0).equals(curTextValue)) {
                            curItem = item;
                            break;
                        }
                        ++n2;
                    }
                    if (curItem != null) {
                        this.editorSelector.setSelection(curItem);
                        this.editorSelector.showItem(curItem);
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            }
            UIUtils.maxTableColumnsWidth(this.editorSelector);
        }
        finally {
            this.editorSelector.setRedraw(true);
        }
    }

    private class SelectorLoaderJob
    extends DataSourceJob {
        private Object pattern;

        private SelectorLoaderJob() {
            super(String.valueOf(CoreMessages.dialog_value_view_job_selector_name) + ReferenceValueEditor.this.valueController.getValueName() + " possible values", ReferenceValueEditor.this.valueController.getExecutionContext());
            this.setUser(false);
        }

        void setPattern(@Nullable Object pattern) {
            this.pattern = pattern;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            if (ReferenceValueEditor.this.editorSelector.isDisposed()) {
                return Status.OK_STATUS;
            }
            final TreeMap<Object, String> keyValues = new TreeMap<Object, String>((o1, o2) -> {
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            });
            try {
                IAttributeController attributeController = (IAttributeController)ReferenceValueEditor.this.valueController;
                DBSEntityAttribute tableColumn = attributeController.getBinding().getEntityAttribute();
                if (tableColumn == null) {
                    return Status.OK_STATUS;
                }
                final DBSEntityAttributeRef fkColumn = DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)ReferenceValueEditor.this.refConstraint, (DBSEntityAttribute)tableColumn);
                if (fkColumn == null) {
                    return Status.OK_STATUS;
                }
                if (!(ReferenceValueEditor.this.refConstraint instanceof DBSEntityAssociation)) return Status.OK_STATUS;
                DBSEntityAssociation association = (DBSEntityAssociation)ReferenceValueEditor.this.refConstraint;
                DBSEntityAttribute refColumn = DBUtils.getReferenceAttribute((DBRProgressMonitor)monitor, (DBSEntityAssociation)association, (DBSEntityAttribute)tableColumn, (boolean)false);
                if (refColumn == null) {
                    return Status.OK_STATUS;
                }
                ArrayList<DBDAttributeValue> precedingKeys = null;
                List allColumns = CommonUtils.safeList((List)ReferenceValueEditor.this.refConstraint.getAttributeReferences(monitor));
                if (allColumns.size() > 1 && allColumns.get(0) != fkColumn) {
                    DBSEntityAttributeRef precColumn;
                    List<DBDAttributeBinding> rowAttributes = attributeController.getRowController().getRowAttributes();
                    precedingKeys = new ArrayList<DBDAttributeValue>();
                    Iterator iterator = allColumns.iterator();
                    while (iterator.hasNext() && (precColumn = (DBSEntityAttributeRef)iterator.next()) != fkColumn) {
                        DBDAttributeBinding rowAttr;
                        DBSEntityAttribute precAttribute = precColumn.getAttribute();
                        if (precAttribute == null || (rowAttr = DBUtils.findBinding(rowAttributes, (DBSAttributeBase)precAttribute)) == null) continue;
                        Object precValue = attributeController.getRowController().getAttributeValue(rowAttr);
                        precedingKeys.add(new DBDAttributeValue((DBSAttributeBase)precAttribute, precValue));
                    }
                }
                DBSEntityAttribute fkAttribute = fkColumn.getAttribute();
                DBSEntityConstraint refConstraint = association.getReferencedConstraint();
                DBSConstraintEnumerable enumConstraint = (DBSConstraintEnumerable)refConstraint;
                if (fkAttribute == null) return Status.OK_STATUS;
                if (enumConstraint == null) return Status.OK_STATUS;
                Throwable throwable = null;
                Object var14_16 = null;
                try {
                    DBCSession session = this.getExecutionContext().openSession(monitor, DBCExecutionPurpose.UTIL, NLS.bind((String)CoreMessages.dialog_value_view_context_name, (Object)fkAttribute.getName()));
                    try {
                        Collection enumValues = enumConstraint.getKeyEnumeration(session, refColumn, this.pattern, precedingKeys, 200);
                        Iterator iterator = enumValues.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                if (!monitor.isCanceled()) break;
                                return Status.CANCEL_STATUS;
                            }
                            DBDLabelValuePair pair = (DBDLabelValuePair)iterator.next();
                            keyValues.put(pair.getValue(), pair.getLabel());
                        }
                        final DBDValueHandler colHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)fkAttribute);
                        DBeaverUI.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ReferenceValueEditor.this.updateDictionarySelector(keyValues, fkColumn, colHandler);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    finally {
                        if (session == null) return Status.CANCEL_STATUS;
                        session.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (DBException e) {
                log.warn((Object)e);
            }
            return Status.OK_STATUS;
        }
    }
}

