/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.math.BigDecimal;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;
import org.jkiss.utils.CommonUtils;

public class NumberInlineEditor
extends BaseValueEditor<Text> {
    private static final Log log = Log.getLog(NumberInlineEditor.class);
    private static final int MAX_NUMBER_LENGTH = 100;
    private DBDDataFormatterProfile formatterProfile;

    public NumberInlineEditor(IValueController controller) {
        super(controller);
        this.formatterProfile = this.valueController.getExecutionContext() != null ? this.valueController.getExecutionContext().getDataSource().getContainer().getDataFormatterProfile() : DataFormatterRegistry.getInstance().getGlobalProfile();
    }

    @Override
    protected Text createControl(Composite editPlaceholder) {
        boolean inline = this.valueController.getEditType() == IValueController.EditType.INLINE;
        Text editor = new Text(this.valueController.getEditPlaceholder(), inline ? 2048 : 2);
        editor.setEditable(!this.valueController.isReadOnly());
        editor.setTextLimit(100);
        Object curValue = this.valueController.getValue();
        Class type = curValue instanceof Number ? curValue.getClass() : this.valueController.getValueHandler().getValueObjectType(this.valueController.getValueType());
        Locale locale = this.formatterProfile.getLocale();
        if (type == Float.class || type == Double.class || type == BigDecimal.class) {
            editor.addVerifyListener(UIUtils.getNumberVerifyListener(locale));
        } else {
            editor.addVerifyListener(UIUtils.getIntegerVerifyListener(locale));
        }
        return editor;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        if (value != null) {
            ((Text)this.control).setText(this.valueController.getValueHandler().getValueDisplayString(this.valueController.getValueType(), value, DBDDisplayFormat.UI));
        } else {
            ((Text)this.control).setText("");
        }
        if (this.valueController.getEditType() == IValueController.EditType.INLINE) {
            ((Text)this.control).selectAll();
        }
    }

    @Override
    @Nullable
    public Object extractEditorValue() {
        String text = ((Text)this.control).getText();
        if (CommonUtils.isEmpty((String)text)) {
            return null;
        }
        Object curValue = this.valueController.getValue();
        Class hintType = curValue instanceof Number ? curValue.getClass() : this.valueController.getValueHandler().getValueObjectType(this.valueController.getValueType());
        try {
            return DBValueFormatting.convertStringToNumber((String)text, (Class)hintType, (DBDDataFormatter)this.formatterProfile.createFormatter("number", this.valueController.getValueType()));
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

