/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

public class EmptyPresentation
extends AbstractPresentation {
    private Composite placeholder;

    @Override
    public void createPresentation(final @NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine(parent);
        this.placeholder = new Canvas(parent, 0);
        this.placeholder.setLayoutData((Object)new GridData(1808));
        this.placeholder.setBackground(controller.getDefaultBackground());
        final Font normalFont = parent.getFont();
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | 1);
        fontData[0].setHeight(18);
        final Font largeFont = new Font(normalFont.getDevice(), fontData[0]);
        this.placeholder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIUtils.dispose((Resource)largeFont);
            }
        });
        this.placeholder.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (controller.isRefreshInProgress()) {
                    return;
                }
                e.gc.setFont(largeFont);
                int fontSize = largeFont.getFontData()[0].getHeight();
                UIUtils.drawMessageOverControl((Control)EmptyPresentation.this.placeholder, e, CoreMessages.sql_editor_resultset_filter_panel_control_no_data, -(fontSize / 2));
                e.gc.setFont(normalFont);
                if (controller.getDataContainer() instanceof SQLEditor.QueryResultsContainer) {
                    String execQuery = ActionUtils.findCommandDescription("org.jkiss.dbeaver.ui.editors.sql.run.statement", (IServiceLocator)controller.getSite(), true);
                    String execScript = ActionUtils.findCommandDescription("org.jkiss.dbeaver.ui.editors.sql.run.script", (IServiceLocator)controller.getSite(), true);
                    UIUtils.drawMessageOverControl((Control)EmptyPresentation.this.placeholder, e, NLS.bind((String)CoreMessages.sql_editor_resultset_filter_panel_control_execute_to_see_reslut, (Object)execQuery, (Object)execScript), fontSize + fontSize / 3);
                }
            }
        });
        this.trackPresentationControl();
    }

    @Override
    public Control getControl() {
        return this.placeholder;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return null;
    }

    @Override
    public void setCurrentAttribute(@NotNull DBDAttributeBinding attribute) {
    }

    @Override
    public Point getCursorLocation() {
        return null;
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return null;
    }

    @Override
    public void printResultSet() {
    }
}

