/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.plaintext;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class PlainTextPresentation
extends AbstractPresentation
implements IAdaptable {
    public static final int FIRST_ROW_LINE = 2;
    private StyledText text;
    private DBDAttributeBinding curAttribute;
    private StyledTextFindReplaceTarget findReplaceTarget;
    public boolean activated;
    private Color curLineColor;
    private int[] colWidths;
    private StyleRange curLineRange;
    private int totalRows = 0;
    private String curSelection;
    private Font monoFont;
    private static PrinterData fgPrinterData = null;

    @Override
    public void createPresentation(final @NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        UIUtils.createHorizontalLine(parent);
        this.text = new StyledText(parent, 778);
        this.text.setBlockSelection(true);
        this.text.setCursor(parent.getDisplay().getSystemCursor(19));
        this.text.setMargins(4, 4, 4, 4);
        this.text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addCaretListener(event -> this.onCursorChange(event.caretOffset));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlainTextPresentation.this.curSelection = PlainTextPresentation.this.text.getSelectionText();
                PlainTextPresentation.this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
            }
        });
        this.text.addDisposeListener(e -> this.dispose());
        final ScrollBar verticalBar = this.text.getVerticalBar();
        verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (verticalBar.getSelection() + verticalBar.getPageIncrement() >= verticalBar.getMaximum() && controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment") && !controller.isRecordMode() && controller.isHasMoreData()) {
                    controller.readNextSegment();
                }
            }
        });
        this.findReplaceTarget = new StyledTextFindReplaceTarget(this.text);
        UIUtils.enableHostEditorKeyBindingsSupport(controller.getSite(), (Control)this.text);
        this.applyThemeSettings();
        this.registerContextMenu();
        this.activateTextKeyBindings(controller, (Control)this.text);
        this.trackPresentationControl();
    }

    @Override
    public void dispose() {
        if (this.monoFont != null) {
            UIUtils.dispose((Resource)this.monoFont);
            this.monoFont = null;
        }
        super.dispose();
    }

    @Override
    protected void applyThemeSettings() {
        IThemeManager themeManager = this.controller.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.curLineColor = themeManager.getCurrentTheme().getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.odd.background");
        ITheme currentTheme = themeManager.getCurrentTheme();
        Font rsFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.sql.resultset.font");
        if (rsFont != null) {
            int fontHeight = rsFont.getFontData()[0].getHeight();
            Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
            FontData[] fontData = font.getFontData();
            fontData[0].setHeight(fontHeight);
            Font newFont = new Font(font.getDevice(), fontData[0]);
            this.text.setFont(newFont);
            if (this.monoFont != null) {
                UIUtils.dispose((Resource)this.monoFont);
            }
            this.monoFont = newFont;
        }
    }

    private void onCursorChange(int offset) {
        ResultSetModel model = this.controller.getModel();
        int lineNum = this.text.getLineAtOffset(offset);
        int lineOffset = this.text.getOffsetAtLine(lineNum);
        int horizontalOffset = offset - lineOffset;
        int lineCount = this.text.getLineCount();
        int rowNum = lineNum - 2;
        if (this.controller.isRecordMode()) {
            if (rowNum < 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getVisibleAttributeCount()) {
                this.curAttribute = model.getVisibleAttribute(rowNum);
            }
        } else {
            int colNum = 0;
            int horOffsetBegin = 0;
            int horOffsetEnd = 0;
            int i = 0;
            while (i < this.colWidths.length) {
                horOffsetBegin = horOffsetEnd;
                if (horizontalOffset < (horOffsetEnd += this.colWidths[i] + 1)) {
                    colNum = i;
                    break;
                }
                ++i;
            }
            if (rowNum < 0 && model.getRowCount() > 0) {
                rowNum = 0;
            }
            if (rowNum >= 0 && rowNum < model.getRowCount() && colNum >= 0 && colNum < model.getVisibleAttributeCount()) {
                this.controller.setCurrentRow(model.getRow(rowNum));
                this.curAttribute = model.getVisibleAttribute(colNum);
            }
            this.controller.updateEditControls();
            if (this.curLineRange == null || this.curLineRange.start != lineOffset + horOffsetBegin) {
                this.curLineRange = new StyleRange(lineOffset + horOffsetBegin, horOffsetEnd - horOffsetBegin - 1, null, this.curLineColor);
                DBeaverUI.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlainTextPresentation.this.text.setStyleRanges(new StyleRange[]{PlainTextPresentation.this.curLineRange});
                    }
                });
            }
            if (lineNum == lineCount - 1 && this.controller.isHasMoreData() && this.controller.getPreferenceStore().getBoolean("resultset.autofetch.next.segment")) {
                this.controller.readNextSegment();
            }
        }
        this.fireSelectionChanged((ISelection)new PlainTextSelectionImpl());
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
        this.colWidths = null;
        if (this.controller.isRecordMode()) {
            this.printRecord();
        } else {
            this.printGrid(append);
        }
    }

    private void printGrid(boolean append) {
        int firstRow;
        DBDAttributeBinding attr;
        int i;
        DBPPreferenceStore prefs = this.getController().getPreferenceStore();
        int maxColumnSize = prefs.getInt("resultset.text.max.column.size");
        boolean showNulls = prefs.getBoolean("resultset.text.show.nulls");
        boolean delimLeading = prefs.getBoolean("resultset.text.delimiter.leading");
        boolean delimTrailing = prefs.getBoolean("resultset.text.delimiter.trailing");
        DBDDisplayFormat displayFormat = DBDDisplayFormat.safeValueOf((String)prefs.getString("resultset.text.value.format"));
        StringBuilder grid = new StringBuilder(512);
        ResultSetModel model = this.controller.getModel();
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        List<ResultSetRow> allRows = model.getAllRows();
        if (this.colWidths == null) {
            this.colWidths = new int[attrs.size()];
            i = 0;
            while (i < attrs.size()) {
                attr = attrs.get(i);
                this.colWidths[i] = PlainTextPresentation.getAttributeName(attr).length();
                for (ResultSetRow row : allRows) {
                    String displayString = this.getCellString(model, attr, row, displayFormat);
                    this.colWidths[i] = Math.max(this.colWidths[i], displayString.length());
                }
                ++i;
            }
            i = 0;
            while (i < this.colWidths.length) {
                int n = i;
                this.colWidths[n] = this.colWidths[n] + 1;
                if (this.colWidths[i] > maxColumnSize) {
                    this.colWidths[i] = maxColumnSize;
                }
                ++i;
            }
        }
        if (!append) {
            if (delimLeading) {
                grid.append("|");
            }
            i = 0;
            while (i < attrs.size()) {
                if (i > 0) {
                    grid.append("|");
                }
                attr = attrs.get(i);
                String attrName = PlainTextPresentation.getAttributeName(attr);
                grid.append(attrName);
                int k = this.colWidths[i] - attrName.length();
                while (k > 0) {
                    grid.append(" ");
                    --k;
                }
                ++i;
            }
            if (delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
            if (delimLeading) {
                grid.append("|");
            }
            i = 0;
            while (i < attrs.size()) {
                if (i > 0) {
                    grid.append("|");
                }
                int k = this.colWidths[i];
                while (k > 0) {
                    grid.append("-");
                    --k;
                }
                ++i;
            }
            if (delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
        }
        int n = firstRow = append ? this.totalRows : 0;
        if (append) {
            grid.append("\n");
        }
        int i2 = firstRow;
        while (i2 < allRows.size()) {
            ResultSetRow row;
            row = allRows.get(i2);
            if (delimLeading) {
                grid.append("|");
            }
            int k = 0;
            while (k < attrs.size()) {
                DBDAttributeBinding attr2;
                String displayString;
                if (k > 0) {
                    grid.append("|");
                }
                if ((displayString = this.getCellString(model, attr2 = attrs.get(k), row, displayFormat)).length() >= this.colWidths[k] - 1) {
                    displayString = CommonUtils.truncateString((String)displayString, (int)(this.colWidths[k] - 1));
                } else if (showNulls && displayString.isEmpty() && DBUtils.isNullValue((Object)model.getCellValue(attr2, row))) {
                    displayString = "[NULL]";
                }
                grid.append(displayString);
                int j = this.colWidths[k] - displayString.length();
                while (j > 0) {
                    grid.append(" ");
                    --j;
                }
                ++k;
            }
            if (delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
            ++i2;
        }
        grid.setLength(grid.length() - 1);
        if (append) {
            this.text.append(grid.toString());
        } else {
            this.text.setText(grid.toString());
        }
        this.totalRows = allRows.size();
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }

    private String getCellString(ResultSetModel model, DBDAttributeBinding attr, ResultSetRow row, DBDDisplayFormat displayFormat) {
        String displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, model.getCellValue(attr, row), displayFormat);
        return TextUtils.getSingleLineString(displayString);
    }

    private void printRecord() {
        DBDAttributeBinding attr;
        DBPPreferenceStore prefs = this.getController().getPreferenceStore();
        boolean delimLeading = prefs.getBoolean("resultset.text.delimiter.leading");
        boolean delimTrailing = prefs.getBoolean("resultset.text.delimiter.trailing");
        DBDDisplayFormat displayFormat = DBDDisplayFormat.safeValueOf((String)prefs.getString("resultset.text.value.format"));
        StringBuilder grid = new StringBuilder(512);
        ResultSetModel model = this.controller.getModel();
        List<DBDAttributeBinding> attrs = model.getVisibleAttributes();
        String[] values = new String[attrs.size()];
        ResultSetRow currentRow = this.controller.getCurrentRow();
        int nameWidth = 4;
        int valueWidth = 5;
        int i = 0;
        while (i < attrs.size()) {
            attr = attrs.get(i);
            nameWidth = Math.max(nameWidth, PlainTextPresentation.getAttributeName(attr).length());
            values[i] = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, model.getCellValue(attr, currentRow), displayFormat);
            valueWidth = Math.max(valueWidth, values[i].length());
            ++i;
        }
        if (delimLeading) {
            grid.append("|");
        }
        grid.append("Name");
        int j = nameWidth - 4;
        while (j > 0) {
            grid.append(" ");
            --j;
        }
        grid.append("|Value");
        j = valueWidth - 5;
        while (j > 0) {
            grid.append(" ");
            --j;
        }
        if (delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        j = 0;
        while (j < nameWidth) {
            grid.append("-");
            ++j;
        }
        grid.append("|");
        j = 0;
        while (j < valueWidth) {
            grid.append("-");
            ++j;
        }
        if (delimTrailing) {
            grid.append("|");
        }
        grid.append("\n");
        i = 0;
        while (i < attrs.size()) {
            attr = attrs.get(i);
            String name = PlainTextPresentation.getAttributeName(attr);
            if (delimLeading) {
                grid.append("|");
            }
            grid.append(name);
            int j2 = nameWidth - name.length();
            while (j2 > 0) {
                grid.append(" ");
                --j2;
            }
            grid.append("|");
            grid.append(values[i]);
            j2 = valueWidth - values[i].length();
            while (j2 > 0) {
                grid.append(" ");
                --j2;
            }
            if (delimTrailing) {
                grid.append("|");
            }
            grid.append("\n");
            ++i;
        }
        grid.setLength(grid.length() - 1);
        this.text.setText(grid.toString());
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
        this.colWidths = null;
        this.curLineRange = null;
        this.totalRows = 0;
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void fillMenu(@NotNull IMenuManager menu) {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition position) {
        if (this.controller.isRecordMode()) {
            super.scrollToRow(position);
        } else {
            int lineNum;
            int caretOffset = this.text.getCaretOffset();
            if (caretOffset < 0) {
                caretOffset = 0;
            }
            if ((lineNum = this.text.getLineAtOffset(caretOffset)) < 2) {
                lineNum = 2;
            }
            int lineOffset = this.text.getOffsetAtLine(lineNum);
            int xOffset = caretOffset - lineOffset;
            int totalLines = this.text.getLineCount();
            switch (position) {
                case FIRST: {
                    lineNum = 2;
                    break;
                }
                case PREVIOUS: {
                    --lineNum;
                    break;
                }
                case NEXT: {
                    ++lineNum;
                    break;
                }
                case LAST: {
                    lineNum = totalLines - 1;
                    break;
                }
                case CURRENT: {
                    lineNum = this.controller.getCurrentRow().getVisualNumber() + 2;
                }
            }
            if (lineNum < 2 || lineNum >= totalLines) {
                return;
            }
            int newOffset = this.text.getOffsetAtLine(lineNum);
            this.text.setCaretOffset(newOffset += xOffset);
            this.text.showSelection();
        }
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.curAttribute;
    }

    @Override
    @Nullable
    public String copySelectionToString(ResultSetCopySettings settings) {
        return this.text.getSelectionText();
    }

    @Override
    public void printResultSet() {
        Shell shell = this.getControl().getShell();
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        if (Printer.getPrinterList().length == 0) {
            UIUtils.showMessageBox(shell, "No printers", "Printers not found", 1);
            return;
        }
        PrintDialog dialog = new PrintDialog(shell, 32768);
        dialog.setPrinterData(fgPrinterData);
        PrinterData data = dialog.open();
        if (data != null) {
            final Printer printer = new Printer(data);
            final Runnable styledTextPrinter = this.text.print(printer, options);
            new Thread("Printing"){

                @Override
                public void run() {
                    styledTextPrinter.run();
                    printer.dispose();
                }
            }.start();
            fgPrinterData = data;
            PlainTextPresentation.fgPrinterData.startPage = 1;
            PlainTextPresentation.fgPrinterData.endPage = 1;
            PlainTextPresentation.fgPrinterData.scope = 0;
            PlainTextPresentation.fgPrinterData.copyCount = 1;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IFindReplaceTarget.class) {
            return adapter.cast(this.findReplaceTarget);
        }
        return null;
    }

    @Override
    public ISelection getSelection() {
        return new PlainTextSelectionImpl();
    }

    private class PlainTextSelectionImpl
    implements IResultSetSelection {
        private PlainTextSelectionImpl() {
        }

        @Nullable
        public Object getFirstElement() {
            return PlainTextPresentation.this.curSelection;
        }

        public Iterator<String> iterator() {
            return this.toList().iterator();
        }

        public int size() {
            return PlainTextPresentation.this.curSelection == null ? 0 : 1;
        }

        public Object[] toArray() {
            Object[] objectArray;
            if (PlainTextPresentation.this.curSelection == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = PlainTextPresentation.this.curSelection;
            }
            return objectArray;
        }

        public List<String> toList() {
            return PlainTextPresentation.this.curSelection == null ? Collections.emptyList() : Collections.singletonList(PlainTextPresentation.this.curSelection);
        }

        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public IResultSetController getController() {
            return PlainTextPresentation.this.controller;
        }

        @Override
        @NotNull
        public Collection<DBDAttributeBinding> getSelectedAttributes() {
            if (PlainTextPresentation.this.curAttribute == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(PlainTextPresentation.this.curAttribute);
        }

        @Override
        @NotNull
        public Collection<ResultSetRow> getSelectedRows() {
            ResultSetRow currentRow = PlainTextPresentation.this.controller.getCurrentRow();
            if (currentRow == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(currentRow);
        }

        @Override
        public DBDAttributeBinding getElementAttribute(Object element) {
            return PlainTextPresentation.this.curAttribute;
        }

        @Override
        public ResultSetRow getElementRow(Object element) {
            return this.getController().getCurrentRow();
        }
    }
}

