/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.utils.CommonUtils;

public class MetaDataPanel
implements IResultSetPanel {
    private static final Log log = Log.getLog(MetaDataPanel.class);
    public static final String PANEL_ID = "results-metadata";
    private IResultSetPresentation presentation;
    private MetaDataTable attributeList;
    private List<DBDAttributeBinding> curAttributes;
    private Color colorDisabled;
    private transient boolean updateSelection = false;

    @Override
    public String getPanelTitle() {
        return "MetaData";
    }

    @Override
    public DBPImage getPanelImage() {
        return UIIcon.PANEL_METADATA;
    }

    @Override
    public String getPanelDescription() {
        return "Resultset metadata";
    }

    @Override
    public Control createContents(final IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.colorDisabled = presentation.getControl().getDisplay().getSystemColor(17);
        this.attributeList = new MetaDataTable(parent);
        this.attributeList.setFitWidth(false);
        this.attributeList.getItemsViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DBDAttributeBinding attr = MetaDataPanel.this.getSelectedAttribute();
                if (attr != null && !MetaDataPanel.this.updateSelection && MetaDataPanel.this.isAttributeVisible(attr)) {
                    MetaDataPanel.this.updateSelection = true;
                    try {
                        presentation.setCurrentAttribute(attr);
                    }
                    finally {
                        MetaDataPanel.this.updateSelection = false;
                    }
                }
            }
        });
        if (this.presentation instanceof ISelectionProvider) {
            final ISelectionChangedListener listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DBDAttributeBinding attr;
                    if (!MetaDataPanel.this.updateSelection && MetaDataPanel.this.presentation.getController().getVisiblePanel() == MetaDataPanel.this && (attr = presentation.getCurrentAttribute()) != null && attr != MetaDataPanel.this.getSelectedAttribute()) {
                        MetaDataPanel.this.updateSelection = true;
                        try {
                            MetaDataPanel.this.attributeList.getItemsViewer().setSelection((ISelection)new StructuredSelection((Object)attr));
                        }
                        finally {
                            MetaDataPanel.this.updateSelection = false;
                        }
                    }
                }
            };
            ((ISelectionProvider)this.presentation).addSelectionChangedListener(listener);
            this.attributeList.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((ISelectionProvider)presentation).removeSelectionChangedListener(listener);
                }
            });
        }
        return this.attributeList;
    }

    private DBDAttributeBinding getSelectedAttribute() {
        IStructuredSelection selection = this.attributeList.getItemsViewer().getStructuredSelection();
        if (!selection.isEmpty()) {
            return (DBDAttributeBinding)selection.getFirstElement();
        }
        return null;
    }

    private boolean isAttributeVisible(DBDAttributeBinding attr) {
        return this.presentation.getController().getModel().getVisibleAttributes().contains(attr);
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void refresh(boolean force) {
        if (this.attributeList.isLoading()) {
            return;
        }
        List<DBDAttributeBinding> newAttributes = Arrays.asList(this.presentation.getController().getModel().getAttributes());
        if (this.curAttributes != null && this.curAttributes.size() == newAttributes.size()) {
            boolean equals = true;
            int i = 0;
            while (i < this.curAttributes.size()) {
                if (this.curAttributes.get(i) != newAttributes.get(i)) {
                    equals = false;
                    break;
                }
                ++i;
            }
            if (equals) {
                return;
            }
        }
        this.curAttributes = newAttributes;
        this.attributeList.clearListData();
        this.attributeList.loadData();
    }

    @Override
    public void contributeActions(ToolBarManager manager) {
    }

    private class LoadAttributesService
    extends DatabaseLoadService<Collection<DBDAttributeBinding>> {
        protected LoadAttributesService() {
            super("Load sessions", MetaDataPanel.this.presentation.getController().getExecutionContext());
        }

        public Collection<DBDAttributeBinding> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            return MetaDataPanel.this.curAttributes;
        }
    }

    private class MetaDataTable
    extends DatabaseObjectListControl<DBDAttributeBinding> {
        protected MetaDataTable(Composite parent) {
            super(parent, 0x10000000, (IWorkbenchSite)MetaDataPanel.this.presentation.getController().getSite(), (IContentProvider)new TreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    List nested = ((DBDAttributeBinding)parentElement).getNestedBindings();
                    return nested == null ? new Object[]{} : nested.toArray(new Object[nested.size()]);
                }

                public boolean hasChildren(Object element) {
                    return !CommonUtils.isEmpty((Collection)((DBDAttributeBinding)element).getNestedBindings());
                }
            });
        }

        @Override
        protected void fillCustomActions(IContributionManager contributionManager) {
            contributionManager.add((IAction)new Action("Copy column names"){

                public void run() {
                    StringBuilder text = new StringBuilder();
                    Object[] objectArray = MetaDataTable.this.getItemsViewer().getStructuredSelection().toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item instanceof DBDAttributeBinding) {
                            if (text.length() > 0) {
                                text.append("\n");
                            }
                            text.append(((DBDAttributeBinding)item).getName());
                        }
                        ++n2;
                    }
                    UIUtils.setClipboardContents(MetaDataTable.this.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
                }
            });
        }

        @Override
        @NotNull
        protected String getListConfigId(List<Class<?>> classList) {
            DBCExecutionContext executionContext = MetaDataPanel.this.presentation.getController().getExecutionContext();
            if (executionContext == null) {
                return "MetaData";
            }
            return "MetaData/" + executionContext.getDataSource().getContainer().getDriver().getId();
        }

        @Override
        protected Object getObjectValue(DBDAttributeBinding item) {
            if (item instanceof DBDAttributeBindingMeta) {
                return item.getMetaAttribute();
            }
            return item.getAttribute();
        }

        @Override
        @Nullable
        protected DBPImage getObjectImage(DBDAttributeBinding item) {
            return DBValueFormatting.getObjectImage((DBPObject)item.getMetaAttribute());
        }

        @Override
        protected Color getObjectForeground(DBDAttributeBinding item) {
            if (item.getParentObject() == null && !MetaDataPanel.this.isAttributeVisible(item)) {
                return MetaDataPanel.this.colorDisabled;
            }
            return super.getObjectForeground(item);
        }

        @Override
        protected LoadingJob<Collection<DBDAttributeBinding>> createLoadService() {
            return LoadingJob.createService(new LoadAttributesService(), new ObjectListControl.ObjectsLoadVisualizer(this){

                @Override
                public void completeLoading(Collection<DBDAttributeBinding> items) {
                    super.completeLoading(items);
                    ((TreeViewer)MetaDataPanel.this.attributeList.getItemsViewer()).expandToLevel(2);
                }
            });
        }
    }
}

