/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.itemlist;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.utils.CommonUtils;

public abstract class ObjectSearcher<OBJECT_TYPE extends DBPNamedObject>
implements ISearchExecutor {
    private Pattern curSearchPattern;
    private int curSearchIndex;
    private Set<OBJECT_TYPE> curSearchResult = null;

    @Override
    public boolean performSearch(String searchString, int options) {
        boolean findPrev;
        boolean caseSensitiveSearch;
        boolean bl = caseSensitiveSearch = (options & 1) != 0;
        if (!CommonUtils.isEmpty((String)searchString) && this.curSearchPattern == null || !CommonUtils.equalObjects((Object)this.curSearchPattern.pattern(), (Object)SQLUtils.makeLikePattern((String)searchString))) {
            try {
                this.curSearchPattern = Pattern.compile(SQLUtils.makeLikePattern((String)searchString), caseSensitiveSearch ? 0 : 2);
            }
            catch (PatternSyntaxException e) {
                this.setInfo(e.getMessage());
                return false;
            }
            this.curSearchIndex = -1;
            Set<OBJECT_TYPE> oldSearchResult = this.curSearchResult;
            this.curSearchResult = null;
            boolean found = false;
            Collection<OBJECT_TYPE> nodes = this.getContent();
            if (!CommonUtils.isEmpty(nodes)) {
                for (DBPNamedObject node : nodes) {
                    if (!this.matchesSearch(node)) continue;
                    if (this.curSearchResult == null) {
                        this.curSearchResult = new LinkedHashSet<OBJECT_TYPE>(50);
                    }
                    this.curSearchResult.add(node);
                    this.updateObject(node);
                    if (!found) {
                        ++this.curSearchIndex;
                        this.selectObject(node);
                        this.revealObject(node);
                    }
                    found = true;
                }
            }
            if (!CommonUtils.isEmpty(oldSearchResult)) {
                for (DBPNamedObject oldNode : oldSearchResult) {
                    if (this.curSearchResult != null && this.curSearchResult.contains(oldNode)) continue;
                    this.updateObject(oldNode);
                }
            }
            return found;
        }
        boolean findNext = (options & 2) != 0;
        boolean bl2 = findPrev = (options & 4) != 0;
        if ((findNext || findPrev) && !CommonUtils.isEmpty(this.curSearchResult)) {
            if (findNext) {
                ++this.curSearchIndex;
                if (this.curSearchIndex >= this.curSearchResult.size()) {
                    this.curSearchIndex = 0;
                }
            } else {
                --this.curSearchIndex;
                if (this.curSearchIndex < 0) {
                    this.curSearchIndex = this.curSearchResult.size() - 1;
                }
            }
            int index = 0;
            for (DBPNamedObject node : this.curSearchResult) {
                if (index++ != this.curSearchIndex) continue;
                this.selectObject(node);
                this.revealObject(node);
                break;
            }
        }
        return !CommonUtils.isEmpty(this.curSearchResult);
    }

    @Override
    public void cancelSearch() {
        if (this.curSearchPattern != null) {
            this.curSearchPattern = null;
            this.curSearchIndex = 0;
            if (this.curSearchResult != null) {
                Set<OBJECT_TYPE> oldSearchResult = this.curSearchResult;
                this.curSearchResult = null;
                for (DBPNamedObject oldNode : oldSearchResult) {
                    this.updateObject(oldNode);
                }
                this.selectObject(null);
            }
        }
    }

    private boolean matchesSearch(DBPNamedObject element) {
        if (this.curSearchPattern == null) {
            return false;
        }
        return this.curSearchPattern.matcher(element.getName()).find();
    }

    public boolean hasObject(OBJECT_TYPE object) {
        return this.curSearchResult != null && this.curSearchResult.contains(object);
    }

    protected abstract void setInfo(String var1);

    protected abstract Collection<OBJECT_TYPE> getContent();

    protected abstract void selectObject(OBJECT_TYPE var1);

    protected abstract void updateObject(OBJECT_TYPE var1);

    protected abstract void revealObject(OBJECT_TYPE var1);
}

