/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;

public class NavigatorHandlerRefresh
extends AbstractHandler {
    private static final Log log = Log.getLog(NavigatorHandlerRefresh.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        INavigatorModelView navigatorView = workbenchPart instanceof INavigatorModelView ? (INavigatorModelView)workbenchPart : (INavigatorModelView)workbenchPart.getAdapter(INavigatorModelView.class);
        if (navigatorView == null) {
            if (workbenchPart instanceof IRefreshablePart) {
                ((IRefreshablePart)workbenchPart).refreshPart((Object)this, true);
            }
            return null;
        }
        ArrayList<DBNNode> refreshObjects = new ArrayList<DBNNode>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode rootNode = navigatorView.getRootNode();
        if (rootNode == null && workbenchPart instanceof IEditorPart && ((IEditorPart)workbenchPart).getEditorInput() instanceof IDatabaseEditorInput) {
            rootNode = ((IDatabaseEditorInput)((IEditorPart)workbenchPart).getEditorInput()).getNavigatorNode();
        }
        if (rootNode != null && rootNode.getParentNode() instanceof DBNDatabaseNode) {
            refreshObjects.add(rootNode);
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            for (Object object : structSelection) {
                if (!(object instanceof DBNNode)) continue;
                refreshObjects.add((DBNNode)object);
            }
        }
        if (!refreshObjects.isEmpty()) {
            NavigatorHandlerRefresh.refreshNavigator(refreshObjects);
        }
        return null;
    }

    public static void refreshNavigator(final Collection<? extends DBNNode> refreshObjects) {
        AbstractJob refreshJob = new AbstractJob("Refresh navigator object(s)"){
            public Throwable error;

            protected IStatus run(DBRProgressMonitor monitor) {
                this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (error != null) {
                            DBUserInterface.getInstance().showError("Refresh", "Error refreshing node", error);
                        }
                    }
                });
                HashSet<DBNNode> refreshedSet = new HashSet<DBNNode>();
                for (DBNNode node : refreshObjects) {
                    IEditorPart nodeEditor;
                    if (node.isDisposed() || node.isLocked()) continue;
                    if (!refreshedSet.isEmpty()) {
                        boolean skip = false;
                        for (DBNNode refreshed : refreshedSet) {
                            if (node != refreshed && !node.isChildOf(refreshed)) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    if (node instanceof DBNDatabaseFolder && !(node.getParentNode() instanceof DBNDatabaseFolder) && node.getParentNode() instanceof DBNDatabaseNode) {
                        node = node.getParentNode();
                    }
                    if ((nodeEditor = NavigatorHandlerObjectOpen.findEntityEditor(DBeaverUI.getActiveWorkbenchWindow(), node)) != null && nodeEditor.isDirty() && !((Boolean)new UIConfirmation(){

                        @Override
                        protected Boolean runTask() {
                            if (ConfirmationDialog.showConfirmDialog(null, "entity_revert", 3, nodeEditor.getTitle()) == 2) {
                                return true;
                            }
                            return false;
                        }
                    }.execute()).booleanValue()) continue;
                    this.setName("Refresh '" + node.getNodeName() + "'...");
                    try {
                        DBNNode refreshed;
                        refreshed = node.refreshNode(monitor, DBNEvent.FORCE_REFRESH);
                        if (refreshed == null) continue;
                        refreshedSet.add(refreshed);
                    }
                    catch (Throwable ex) {
                        this.error = ex;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setUser(true);
        refreshJob.schedule();
    }
}

