/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.resources.bookmarks.BookmarksHandlerImpl;

public class NavigatorHandlerAddBookmark
extends NavigatorHandlerObjectBase {
    private IFolder targetFolder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBNNode node;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (node = NavigatorUtils.getSelectedNode(selection)) instanceof DBNDatabaseNode) {
            try {
                AddBookmarkDialog dialog = new AddBookmarkDialog(activeShell, (DBNDatabaseNode)node);
                String title = dialog.chooseName();
                if (title != null) {
                    BookmarksHandlerImpl.createBookmark((DBNDatabaseNode)node, title, dialog.getTargetFolder());
                }
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError(CoreMessages.actions_navigator_bookmark_error_title, CoreMessages.actions_navigator_bookmark_error_message, (Throwable)e);
            }
        }
        return null;
    }

    private class AddBookmarkDialog
    extends EnterNameDialog {
        private DBNDatabaseNode node;

        public AddBookmarkDialog(Shell parentShell, DBNDatabaseNode node) {
            super(parentShell, CoreMessages.actions_navigator_bookmark_title, node.getNodeName());
            this.node = node;
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            DBNResource bookmarksFolderNode;
            IFolder bookmarksFolder;
            Control area = super.createDialogArea(parent);
            IProject project = this.node.getOwnerProject();
            if (project != null && (bookmarksFolder = BookmarksHandlerImpl.getBookmarksFolder(project, false)) != null && (bookmarksFolderNode = this.node.getModel().getNodeByResource((IResource)bookmarksFolder)) != null) {
                DBNResource targetNode;
                UIUtils.createControlLabel((Composite)area, "Bookmark folder");
                DatabaseNavigatorTree foldersNavigator = new DatabaseNavigatorTree((Composite)area, (DBNNode)bookmarksFolderNode, 2052, true);
                GridData gd = new GridData(1808);
                gd.widthHint = 200;
                gd.heightHint = 200;
                foldersNavigator.setLayoutData(gd);
                TreeViewer treeViewer = foldersNavigator.getViewer();
                if (NavigatorHandlerAddBookmark.this.targetFolder != null && NavigatorHandlerAddBookmark.this.targetFolder.exists() && (targetNode = this.node.getModel().getNodeByResource((IResource)NavigatorHandlerAddBookmark.this.targetFolder)) != null) {
                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)targetNode));
                }
                treeViewer.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof DBNResource && ((DBNResource)element).getResource() instanceof IFolder;
                    }
                });
                treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Object object;
                        IStructuredSelection structSel = (IStructuredSelection)event.getSelection();
                        Object object2 = object = structSel.isEmpty() ? null : structSel.getFirstElement();
                        if (object instanceof DBNResource && ((DBNResource)object).getResource() instanceof IFolder) {
                            NavigatorHandlerAddBookmark.this.targetFolder = (IFolder)((DBNResource)object).getResource();
                        }
                    }
                });
                treeViewer.expandAll();
            }
            return area;
        }

        public IFolder getTargetFolder() {
            return NavigatorHandlerAddBookmark.this.targetFolder;
        }
    }
}

