/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SortedMap;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIConfirmation;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomNumberCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.CustomTextCellEditor;
import org.jkiss.dbeaver.ui.controls.StyledTextFindReplaceTarget;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class UIUtils {
    private static final Log log = Log.getLog(UIUtils.class);
    public static final String INLINE_WIDGET_EDITOR_ID = "org.jkiss.dbeaver.ui.InlineWidgetEditor";

    public static VerifyListener getIntegerVerifyListener(Locale locale) {
        final DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    char ch = e.text.charAt(i);
                    if (!Character.isDigit(ch) && ch != symbols.getMinusSign() && ch != symbols.getGroupingSeparator()) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                e.doit = true;
            }
        };
    }

    public static VerifyListener getNumberVerifyListener(Locale locale) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        final char[] allowedChars = new char[]{symbols.getDecimalSeparator(), symbols.getGroupingSeparator(), symbols.getMinusSign(), symbols.getZeroDigit(), symbols.getMonetaryDecimalSeparator(), '+', '.', ','};
        final String exponentSeparator = symbols.getExponentSeparator();
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i = 0;
                while (i < e.text.length()) {
                    char ch = e.text.charAt(i);
                    if (!Character.isDigit(ch) && !ArrayUtils.contains((char[])allowedChars, (char)ch) && exponentSeparator.indexOf(ch) == -1) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
                e.doit = true;
            }
        };
    }

    public static VerifyListener getLongVerifyListener(final Text text) {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldS = text.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                boolean isLong = true;
                try {
                    Long.parseLong(newS);
                }
                catch (NumberFormatException ex) {
                    isLong = false;
                }
                if (!isLong) {
                    e.doit = false;
                }
            }
        };
    }

    public static void createToolBarSeparator(ToolBar toolBar, int style) {
        Label label = new Label((Composite)toolBar, 0);
        label.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.DRAG_HANDLE));
        new ToolItem(toolBar, 2).setControl((Control)label);
    }

    public static TableColumn createTableColumn(Table table, int style, String text) {
        TableColumn column = new TableColumn(table, style);
        column.setText(text);
        return column;
    }

    public static TreeColumn createTreeColumn(Tree tree, int style, String text) {
        TreeColumn column = new TreeColumn(tree, style);
        column.setText(text);
        return column;
    }

    public static void packColumns(Table table) {
        UIUtils.packColumns(table, false);
    }

    public static void packColumns(Table table, boolean fit) {
        table.setRedraw(false);
        try {
            int n;
            int n2;
            TableColumn[] tableColumnArray;
            TableColumn[] columns;
            int totalWidth = 0;
            TableColumn[] tableColumnArray2 = columns = table.getColumns();
            int n3 = columns.length;
            int n4 = 0;
            while (n4 < n3) {
                TableColumn column = tableColumnArray2[n4];
                column.pack();
                totalWidth += column.getWidth();
                ++n4;
            }
            Rectangle clientArea = table.getBounds();
            if (clientArea.width > 0 && totalWidth > clientArea.width) {
                TableColumn[] tableColumnArray3 = columns;
                int n5 = columns.length;
                n3 = 0;
                while (n3 < n5) {
                    TableColumn column = tableColumnArray3[n3];
                    int colWidth = column.getWidth();
                    if (colWidth > totalWidth / 3) {
                        column.setWidth(totalWidth / 3);
                        totalWidth -= colWidth;
                        totalWidth += column.getWidth();
                    }
                    ++n3;
                }
                int extraSpace = totalWidth - clientArea.width;
                GC gc = new GC((Drawable)table);
                try {
                    tableColumnArray = columns;
                    n2 = columns.length;
                    n = 0;
                    while (n < n2) {
                        TableColumn tc = tableColumnArray[n];
                        double ratio = (double)tc.getWidth() / (double)totalWidth;
                        int newWidth = (int)((double)tc.getWidth() - (double)extraSpace * ratio);
                        int minWidth = gc.stringExtent((String)tc.getText()).x;
                        if (newWidth < (minWidth += 5)) {
                            newWidth = minWidth;
                        }
                        tc.setWidth(newWidth);
                        ++n;
                    }
                }
                finally {
                    gc.dispose();
                }
            }
            if (fit && totalWidth < clientArea.width) {
                int sbWidth = 0;
                if (table.getVerticalBar() != null) {
                    sbWidth = table.getVerticalBar().getSize().x;
                }
                if (columns.length > 0) {
                    float extraSpace = (clientArea.width - totalWidth - sbWidth) / columns.length;
                    tableColumnArray = columns;
                    n2 = columns.length;
                    n = 0;
                    while (n < n2) {
                        TableColumn tc = tableColumnArray[n];
                        tc.setWidth((int)((float)tc.getWidth() + extraSpace));
                        ++n;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static void packColumns(@NotNull Tree tree) {
        UIUtils.packColumns(tree, false, null);
    }

    public static void packColumns(@NotNull Tree tree, boolean fit, @Nullable float[] ratios) {
        block23: {
            tree.setRedraw(false);
            try {
                TreeColumn tc2;
                int n;
                TreeColumn[] columns;
                TreeItem[] treeItemArray = tree.getItems();
                int n2 = treeItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem item = treeItemArray[n3];
                    if (item.isDisposed()) {
                        return;
                    }
                    ++n3;
                }
                TreeColumn[] treeColumnArray = columns = tree.getColumns();
                int n4 = columns.length;
                n2 = 0;
                while (n2 < n4) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                Rectangle clientArea = tree.getClientArea();
                if (clientArea.isEmpty()) {
                    return;
                }
                int totalWidth = 0;
                TreeColumn[] treeColumnArray2 = columns;
                int n5 = columns.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeColumn column = treeColumnArray2[n6];
                    int colWidth = column.getWidth();
                    if (colWidth > clientArea.width) {
                        colWidth = clientArea.width;
                        column.setWidth(colWidth);
                    }
                    totalWidth += colWidth;
                    ++n6;
                }
                if (!fit) break block23;
                int areaWidth = clientArea.width;
                if (totalWidth > areaWidth) {
                    GC gc = new GC((Drawable)tree);
                    try {
                        int extraSpace = totalWidth - areaWidth;
                        TreeColumn[] treeColumnArray3 = columns;
                        int n7 = columns.length;
                        n = 0;
                        while (n < n7) {
                            tc2 = treeColumnArray3[n];
                            double ratio = (double)tc2.getWidth() / (double)totalWidth;
                            int newWidth = (int)((double)tc2.getWidth() - (double)extraSpace * ratio);
                            int minWidth = gc.stringExtent((String)tc2.getText()).x;
                            if (newWidth < (minWidth += 5)) {
                                newWidth = minWidth;
                            }
                            tc2.setWidth(newWidth);
                            ++n;
                        }
                        break block23;
                    }
                    finally {
                        gc.dispose();
                    }
                }
                if (totalWidth < areaWidth) {
                    float extraSpace = areaWidth - totalWidth;
                    if (columns.length > 0) {
                        if (ratios == null || ratios.length < columns.length) {
                            extraSpace /= (float)columns.length;
                            extraSpace -= 1.0f;
                            TreeColumn[] treeColumnArray4 = columns;
                            n = columns.length;
                            int tc2 = 0;
                            while (tc2 < n) {
                                TreeColumn tc3 = treeColumnArray4[tc2];
                                tc3.setWidth((int)((float)tc3.getWidth() + extraSpace));
                                ++tc2;
                            }
                        } else {
                            int i = 0;
                            while (i < columns.length) {
                                tc2 = columns[i];
                                tc2.setWidth((int)((float)tc2.getWidth() + extraSpace * ratios[i]));
                                ++i;
                            }
                        }
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    public static void maxTableColumnsWidth(Table table) {
        table.setRedraw(false);
        try {
            int columnCount = table.getColumnCount();
            if (columnCount > 0) {
                TableColumn[] columns;
                int totalWidth = 0;
                TableColumn[] tableColumnArray = columns = table.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tc = tableColumnArray[n2];
                    tc.pack();
                    totalWidth += tc.getWidth();
                    ++n2;
                }
                Rectangle clientArea = table.getClientArea();
                if (totalWidth < clientArea.width) {
                    int extraSpace = clientArea.width - totalWidth;
                    extraSpace /= columnCount;
                    TableColumn[] tableColumnArray2 = columns;
                    int n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TableColumn tc = tableColumnArray2[n4];
                        tc.setWidth(tc.getWidth() + extraSpace);
                        ++n4;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static int getColumnAtPos(TableItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getColumnAtPos(TreeItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static TableItem getNextTableItem(Table table, TableItem item) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static TreeItem getNextTreeItem(Tree tree, TreeItem item) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            try {
                widget.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"widget dispose error", (Throwable)e);
            }
        }
    }

    public static void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            try {
                resource.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"Resource dispose error", (Throwable)e);
            }
        }
    }

    public static void showMessageBox(final Shell shell, final String title, final String info, final int messageType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = shell != null ? shell : DBeaverUI.getActiveWorkbenchShell();
                MessageBox messageBox = new MessageBox(activeShell, messageType | 0x20);
                messageBox.setMessage(info);
                messageBox.setText(title);
                messageBox.open();
            }
        };
        DBeaverUI.syncExec(runnable);
    }

    public static boolean confirmAction(String title, String question) {
        return UIUtils.confirmAction(null, title, question);
    }

    public static boolean confirmAction(final Shell shell, final String title, final String question) {
        return new UIConfirmation(){

            @Override
            public Boolean runTask() {
                Shell activeShell = shell != null ? shell : DBeaverUI.getActiveWorkbenchShell();
                MessageBox messageBox = new MessageBox(activeShell, 196);
                messageBox.setMessage(question);
                messageBox.setText(title);
                int response = messageBox.open();
                if (response == 64) {
                    return true;
                }
                return false;
            }
        }.confirm();
    }

    public static int getFontHeight(Control control) {
        return UIUtils.getFontHeight(control.getFont());
    }

    public static int getFontHeight(Font font) {
        FontData[] fontData = font.getFontData();
        if (fontData.length == 0) {
            return 20;
        }
        return fontData[0].getHeight();
    }

    public static Font makeBoldFont(Font normalFont) {
        return UIUtils.modifyFont(normalFont, 1);
    }

    public static Font modifyFont(Font normalFont, int style) {
        FontData[] fontData = normalFont.getFontData();
        fontData[0].setStyle(fontData[0].getStyle() | style);
        return new Font(normalFont.getDevice(), fontData[0]);
    }

    public static Group createControlGroup(Composite parent, String label, int columns, int layoutStyle, int widthHint) {
        Group group = new Group(parent, 0);
        group.setText(label);
        GridData gd = new GridData(layoutStyle);
        if (widthHint > 0) {
            gd.widthHint = widthHint;
        }
        group.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(columns, false);
        group.setLayout((Layout)gl);
        return group;
    }

    public static Label createControlLabel(Composite parent, String label) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(String.valueOf(label) + ": ");
        textLabel.setLayoutData((Object)new GridData(4));
        return textLabel;
    }

    public static Label createLabel(Composite parent, String label) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(label);
        return textLabel;
    }

    public static Label createLabel(Composite parent, @NotNull DBPImage image) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(DBeaverIcons.getImage(image));
        return imageLabel;
    }

    public static CLabel createInfoLabel(Composite parent, String text) {
        CLabel tipLabel = new CLabel(parent, 0);
        tipLabel.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        tipLabel.setText(text);
        return tipLabel;
    }

    public static Text createLabelText(Composite parent, String label, String value) {
        return UIUtils.createLabelText(parent, label, value, 2048);
    }

    public static Text createLabelText(Composite parent, String label, String value, int style) {
        return UIUtils.createLabelText(parent, label, value, style, new GridData(768));
    }

    @NotNull
    public static Text createLabelText(@NotNull Composite parent, @NotNull String label, @Nullable String value, int style, @Nullable Object layoutData) {
        UIUtils.createControlLabel(parent, label);
        Text text = new Text(parent, style);
        UIUtils.fixReadonlyTextBackground(text);
        if (value != null) {
            text.setText(value);
        }
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, int value, int minimum, int maximum) {
        Label l = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        return UIUtils.createSpinner(parent, tooltip, value, minimum, maximum);
    }

    @NotNull
    public static Spinner createSpinner(Composite parent, String tooltip, int value, int minimum, int maximum) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        spinner.setSelection(value);
        if (tooltip != null) {
            spinner.setToolTipText(tooltip);
        }
        return spinner;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, int value, int minimum, int maximum) {
        return UIUtils.createLabelSpinner(parent, label, null, value, minimum, maximum);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, null, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, String tooltip, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, tooltip, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, boolean checked, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        final Button button = new Button(parent, 0x20 | style);
        if (checked) {
            button.setSelection(true);
        }
        labelControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!button.isDisposed() && button.isVisible() && button.isEnabled()) {
                    button.setSelection(!button.getSelection());
                    button.notifyListeners(13, new Event());
                }
            }
        });
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static Button createCheckbox(Composite parent, String label, String tooltip, boolean checked, int hSpan) {
        Button checkbox = UIUtils.createCheckbox(parent, label, checked);
        if (tooltip != null) {
            checkbox.setToolTipText(tooltip);
        }
        if (hSpan > 1) {
            GridData gd = new GridData(32);
            gd.horizontalSpan = hSpan;
            checkbox.setLayoutData((Object)gd);
        }
        return checkbox;
    }

    public static Button createCheckbox(Composite parent, String label, boolean checked) {
        Button button = new Button(parent, 32);
        button.setText(label);
        if (checked) {
            button.setSelection(true);
        }
        return button;
    }

    public static Combo createLabelCombo(Composite parent, String label, int style) {
        return UIUtils.createLabelCombo(parent, label, null, style);
    }

    public static Combo createLabelCombo(Composite parent, String label, String tooltip, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)new GridData(768));
        if (tooltip != null) {
            combo.setToolTipText(tooltip);
        }
        return combo;
    }

    public static Button createToolButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static void updateContributionItems(IContributionManager manager) {
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.update();
            ++n2;
        }
    }

    @Nullable
    public static Shell getActiveShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        return workbench == null ? null : UIUtils.getShell((IShellProvider)workbench.getActiveWorkbenchWindow());
    }

    @Nullable
    public static Shell getShell(IShellProvider provider) {
        return provider == null ? null : provider.getShell();
    }

    @Nullable
    public static Shell getShell(IWorkbenchPart part) {
        return part == null ? null : UIUtils.getShell((IShellProvider)part.getSite());
    }

    @Nullable
    public static Integer getTextInteger(Text text) {
        String str = text.getText();
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Nullable
    public static IHandlerActivation registerKeyBinding(IServiceLocator serviceLocator, IAction action) {
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        if (handlerService != null) {
            return handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        return null;
    }

    public static Composite createPlaceholder(Composite parent, int columns) {
        return UIUtils.createPlaceholder(parent, columns, 0);
    }

    public static Composite createPlaceholder(Composite parent, int columns, int spacing) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.verticalSpacing = spacing;
        gl.horizontalSpacing = spacing;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        ph.setLayout((Layout)gl);
        return ph;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setGridSpan(Control control, int horizontalSpan, int verticalSpan) {
        GridData gd;
        Object layoutData = control.getLayoutData();
        if (layoutData == null) {
            if (!(control.getParent().getLayout() instanceof GridLayout)) {
                log.debug((Object)("Can't set grid span for layout: " + control.getParent().getLayout()));
                return;
            }
            gd = new GridData();
            control.setLayoutData((Object)gd);
        } else {
            if (!(layoutData instanceof GridData)) {
                log.debug((Object)("Can't set grid span for non-grid layout: " + layoutData.getClass().getName()));
                return;
            }
            gd = (GridData)layoutData;
        }
        gd.horizontalSpan = horizontalSpan;
        gd.verticalSpan = verticalSpan;
    }

    public static Label createHorizontalLine(Composite parent) {
        Label horizontalLine = new Label(parent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        return horizontalLine;
    }

    @Nullable
    public static String getComboSelection(Combo combo) {
        int selectionIndex = combo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return combo.getItem(selectionIndex);
    }

    public static boolean setComboSelection(Combo combo, String value) {
        if (value == null) {
            return false;
        }
        int count = combo.getItemCount();
        int i = 0;
        while (i < count) {
            if (value.equals(combo.getItem(i))) {
                combo.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Combo createEncodingCombo(Composite parent, @Nullable String curCharset) {
        Combo encodingCombo = new Combo(parent, 4);
        encodingCombo.setVisibleItemCount(30);
        SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
        int index = 0;
        int defIndex = -1;
        for (String csName : charsetMap.keySet()) {
            Charset charset = (Charset)charsetMap.get(csName);
            encodingCombo.add(charset.displayName());
            if (curCharset != null) {
                if (charset.displayName().equalsIgnoreCase(curCharset)) {
                    defIndex = index;
                }
                if (defIndex < 0) {
                    for (String alias : charset.aliases()) {
                        if (!alias.equalsIgnoreCase(curCharset)) continue;
                        defIndex = index;
                    }
                }
            }
            ++index;
        }
        if (defIndex >= 0) {
            encodingCombo.select(defIndex);
        } else if (curCharset != null) {
            log.warn((Object)("Charset '" + curCharset + "' is not recognized"));
        }
        return encodingCombo;
    }

    @NotNull
    public static SashForm createPartDivider(IWorkbenchPart workbenchPart, Composite parent, int style) {
        CustomSashForm sash = new CustomSashForm(parent, style);
        return sash;
    }

    @NotNull
    public static String formatMessage(@Nullable String message, Object ... args) {
        if (message == null) {
            return "";
        }
        return MessageFormat.format(message, args);
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image) {
        return UIUtils.createPushButton(parent, label, image, null);
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        if (label != null) {
            button.setText(label);
        }
        if (image != null) {
            button.setImage(image);
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static void setHelp(Control control, String pluginId, String helpContextID) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, String.valueOf(pluginId) + "." + helpContextID);
    }

    public static void setHelp(Control control, String helpContextID) {
        UIUtils.setHelp(control, "org.jkiss.dbeaver.core", helpContextID);
    }

    public static String makeAnchor(String text) {
        return "<a>" + text + "</a>";
    }

    @Nullable
    public static <T> T findView(IWorkbenchWindow workbenchWindow, Class<T> viewClass) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (view != null && viewClass.isAssignableFrom(view.getClass())) {
                return viewClass.cast(view);
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static IViewPart findView(IWorkbenchWindow workbenchWindow, String viewId) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(viewId)) {
                return ref.getView(false);
            }
            ++n2;
        }
        return null;
    }

    public static void setClipboardContents(Display display, Transfer transfer, Object contents) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{contents}, new Transfer[]{transfer});
        clipboard.dispose();
    }

    public static void showPreferencesFor(Shell shell, Object element, String ... defPageID) {
        PreferenceDialog propDialog = element == null ? PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)defPageID[0], (String[])defPageID, null, (int)0) : PreferencesUtil.createPropertyDialogOn((Shell)shell, (Object)element, (String)defPageID[0], null, null, (int)0);
        if (propDialog != null) {
            propDialog.open();
        }
    }

    public static void addFocusTracker(IServiceLocator serviceLocator, String controlID, Control control) {
        IFocusService focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker(control, controlID);
        } else {
            log.debug((Object)("Focus service not found in " + serviceLocator));
        }
    }

    public static void removeFocusTracker(IServiceLocator serviceLocator, Control control) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        IFocusService focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        if (focusService != null) {
            focusService.removeFocusTracker(control);
        } else {
            log.debug((Object)("Focus service not found in " + serviceLocator));
        }
    }

    public static void addDefaultEditActionsSupport(final IServiceLocator site, final Control control) {
        UIUtils.addFocusTracker(site, INLINE_WIDGET_EDITOR_ID, control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIUtils.removeFocusTracker(site, control);
            }
        });
    }

    @NotNull
    public static IDialogSettings getDialogSettings(@NotNull String dialogId) {
        IDialogSettings workbenchSettings = DBeaverActivator.getInstance().getDialogSettings();
        return UIUtils.getSettingsSection(workbenchSettings, dialogId);
    }

    @NotNull
    public static IDialogSettings getSettingsSection(@NotNull IDialogSettings parent, @NotNull String sectionId) {
        IDialogSettings section = parent.getSection(sectionId);
        if (section == null) {
            section = parent.addNewSection(sectionId);
        }
        return section;
    }

    public static void putSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key, Object value) {
        if (value == null) {
            dialogSettings.put(key, null);
            return;
        }
        if (value instanceof Double) {
            dialogSettings.put(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            dialogSettings.put(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            dialogSettings.put(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            dialogSettings.put(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            dialogSettings.put(key, (String)value);
        } else if (value instanceof Boolean) {
            dialogSettings.put(key, ((Boolean)value).booleanValue());
        }
        dialogSettings.put(String.valueOf(key) + "_type", value.getClass().getSimpleName());
    }

    public static Object getSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key) {
        block22: {
            String type = dialogSettings.get(String.valueOf(key) + "_type");
            if (type == null) break block22;
            switch (type) {
                case "Double": {
                    return dialogSettings.getDouble(key);
                }
                case "Float": {
                    return Float.valueOf(dialogSettings.getFloat(key));
                }
                case "Integer": {
                    return dialogSettings.getInt(key);
                }
                case "Long": {
                    return dialogSettings.getLong(key);
                }
                case "String": {
                    return dialogSettings.get(key);
                }
                case "Boolean": {
                    return dialogSettings.getBoolean(key);
                }
            }
        }
        return dialogSettings.get(key);
    }

    @Nullable
    public static IWorkbenchPartSite getWorkbenchPartSite(IServiceLocator serviceLocator) {
        IWorkbenchPartSite partSite = (IWorkbenchPartSite)serviceLocator.getService(IWorkbenchPartSite.class);
        if (partSite == null) {
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null && (workbenchWindow = DBeaverUI.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null) {
                activePart = activePage.getActivePart();
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        return partSite;
    }

    public static boolean isContextActive(String contextId) {
        Collection contextIds = ((IContextService)DBeaverUI.getActiveWorkbenchWindow().getService(IContextService.class)).getActiveContextIds();
        for (Object id : contextIds) {
            if (!contextId.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ISelectionProvider getSelectionProvider(IServiceLocator serviceLocator) {
        ISelectionProvider selectionProvider = (ISelectionProvider)serviceLocator.getService(ISelectionProvider.class);
        if (selectionProvider != null) {
            return selectionProvider;
        }
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite(serviceLocator);
        if (partSite == null) {
            IWorkbenchWindow activeWindow;
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null && (activeWindow = DBeaverUI.getActiveWorkbenchWindow()) != null) {
                activePart = activeWindow.getActivePage().getActivePart();
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        if (partSite != null) {
            return partSite.getSelectionProvider();
        }
        return null;
    }

    public static void enableWithChildren(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    UIUtils.enableWithChildren(child, enable);
                } else {
                    child.setEnabled(enable);
                }
                ++n2;
            }
        }
    }

    public static boolean hasFocus(Control control) {
        Control focusControl = control.getDisplay().getFocusControl();
        if (focusControl == null) {
            return false;
        }
        Control fc = focusControl;
        while (fc != null) {
            if (fc == control) {
                return true;
            }
            fc = fc.getParent();
        }
        return false;
    }

    @Deprecated
    public static void enableHostEditorKeyBindings(IWorkbenchPartSite partSite, boolean enable) {
        IWorkbenchPart part = partSite.getPart();
        if (part instanceof AbstractTextEditor) {
            StyledText textWidget;
            AbstractTextEditor hostEditor = (AbstractTextEditor)part;
            if (hostEditor instanceof BaseTextEditor && ((textWidget = ((BaseTextEditor)hostEditor).getTextViewer().getTextWidget()) == null || textWidget.isDisposed())) {
                return;
            }
            try {
                Method activatorMethod = AbstractTextEditor.class.getDeclaredMethod("setActionActivation", Boolean.TYPE);
                activatorMethod.setAccessible(true);
                activatorMethod.invoke((Object)hostEditor, enable);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                log.warn((Object)"Can't disable text editor action activations", e);
            }
        }
    }

    public static void enableHostEditorKeyBindingsSupport(final IWorkbenchPartSite partSite, Control control) {
        if (!(partSite.getPart() instanceof AbstractTextEditor)) {
            return;
        }
        final boolean[] activated = new boolean[1];
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!activated[0]) {
                    UIUtils.enableHostEditorKeyBindings(partSite, false);
                    activated[0] = true;
                }
            }

            public void focusLost(FocusEvent e) {
                if (activated[0]) {
                    UIUtils.enableHostEditorKeyBindings(partSite, true);
                    activated[0] = false;
                }
            }
        });
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (activated[0]) {
                    UIUtils.enableHostEditorKeyBindings(partSite, true);
                    activated[0] = false;
                }
            }
        });
    }

    public static CTabItem getTabItem(CTabFolder tabFolder, Object data) {
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static void disposeControlOnItemDispose(final CTabItem tabItem) {
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control control = tabItem.getControl();
                if (!control.isDisposed()) {
                    control.dispose();
                }
            }
        });
    }

    public static TreeItem getTreeItem(Tree tree, Object data) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = UIUtils.blend(c1.red, c2.red, ratio);
        int g = UIUtils.blend(c1.green, c2.green, ratio);
        int b = UIUtils.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static boolean isParent(Control parent, Control child) {
        Control c = child;
        while (c != null) {
            if (c == parent) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static boolean isInDialog(Control control) {
        return control.getShell().getData() instanceof Dialog;
    }

    public static Link createLink(Composite parent, String text, SelectionListener listener) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addSelectionListener(listener);
        return link;
    }

    public static CellEditor createPropertyEditor(IServiceLocator serviceLocator, Composite parent, DBPPropertySource source, DBPPropertyDescriptor property, int style) {
        if (source == null) {
            return null;
        }
        Object object = source.getEditableValue();
        if (!property.isEditable(object)) {
            return null;
        }
        CellEditor cellEditor = UIUtils.createCellEditor(parent, object, property, style);
        if (cellEditor != null) {
            Control editorControl = cellEditor.getControl();
            UIUtils.addDefaultEditActionsSupport(serviceLocator, editorControl);
        }
        return cellEditor;
    }

    public static CellEditor createCellEditor(Composite parent, Object object, DBPPropertyDescriptor property, int style) {
        IPropertyValueListProvider listProvider;
        Object[] items;
        if (property instanceof IPropertyValueListProvider && (items = (listProvider = (IPropertyValueListProvider)property).getPossibleValues(object)) != null) {
            String[] strings = new String[items.length];
            int i = 0;
            int itemsLength = items.length;
            while (i < itemsLength) {
                strings[i] = items[i] instanceof DBPNamedObject ? ((DBPNamedObject)items[i]).getName() : CommonUtils.toString((Object)items[i]);
                ++i;
            }
            CustomComboBoxCellEditor editor = new CustomComboBoxCellEditor(parent, strings, 4 | (listProvider.allowCustomValue() ? 0 : 8));
            return editor;
        }
        Class propertyType = property.getDataType();
        if (propertyType == null || CharSequence.class.isAssignableFrom(propertyType)) {
            return new CustomTextCellEditor(parent);
        }
        if (BeanUtils.isNumericType((Class)propertyType)) {
            return new CustomNumberCellEditor(parent, propertyType);
        }
        if (BeanUtils.isBooleanType((Type)propertyType)) {
            return new CustomCheckboxCellEditor(parent, style);
        }
        if (propertyType.isEnum()) {
            T[] enumConstants = propertyType.getEnumConstants();
            String[] strings = new String[enumConstants.length];
            int i = 0;
            int itemsLength = enumConstants.length;
            while (i < itemsLength) {
                strings[i] = ((Enum)enumConstants[i]).name();
                ++i;
            }
            return new CustomComboBoxCellEditor(parent, strings, 12);
        }
        log.warn((Object)("Unsupported property type: " + propertyType.getName()));
        return null;
    }

    public static void postEvent(Control ownerControl, final Event event) {
        final Display display = ownerControl.getDisplay();
        DBeaverUI.asyncExec(new Runnable(){

            @Override
            public void run() {
                display.post(event);
            }
        });
    }

    public static void drawMessageOverControl(Control control, PaintEvent e, String message, int offset) {
        Rectangle bounds = control.getBounds();
        Point ext = e.gc.textExtent(message);
        e.gc.drawText(message, (bounds.width - ext.x) / 2, bounds.height / 3 + offset);
    }

    public static boolean launchProgram(String path) {
        return Program.launch((String)path);
    }

    public static void fillDefaultStyledTextContextMenu(final StyledText text) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UIUtils.fillDefaultStyledTextContextMenu(manager, text);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        text.setMenu(menuMgr.createContextMenu((Control)text));
    }

    public static void fillDefaultStyledTextContextMenu(IMenuManager menu, StyledText text) {
        Point selectionRange = text.getSelectionRange();
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.copy", selectionRange.y > 0, text, 17039369));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.paste", text.getEditable(), text, 16908297));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.cut", selectionRange.y > 0, text, 131199));
        menu.add((IAction)new StyledTextAction("org.eclipse.ui.edit.selectAll", true, text, 262209));
        StyledTextFindReplaceTarget stFindReplaceTarget = new StyledTextFindReplaceTarget(text);
        menu.add((IAction)new FindReplaceAction(ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages"), "Editor.FindReplace.", text.getShell(), (IFindReplaceTarget)stFindReplaceTarget));
        menu.add((IContributionItem)new GroupMarker("styled_text_additions"));
    }

    public static void fillDefaultTableContextMenu(IMenuManager menu, final Table table) {
        menu.add((IAction)new Action(CoreMessages.controls_itemlist_action_copy){

            public void run() {
                StringBuilder text = new StringBuilder();
                int columnCount = table.getColumnCount();
                TableItem[] tableItemArray = table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    int i = 0;
                    while (i < columnCount) {
                        if (i > 0) {
                            text.append("\t");
                        }
                        text.append(item.getText(i));
                        ++i;
                    }
                    ++n2;
                }
                UIUtils.setClipboardContents(table.getDisplay(), (Transfer)TextTransfer.getInstance(), text.toString());
            }
        });
    }

    public static void addFileOpenOverlay(Text text, SelectionListener listener) {
        final Image browseImage = DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOLDER);
        final Rectangle iconBounds = browseImage.getBounds();
        text.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle bounds = ((Text)e.widget).getBounds();
                e.gc.drawImage(browseImage, bounds.width - iconBounds.width - 2, 0);
            }
        });
    }

    public static Combo createDelimiterCombo(Composite group, String label, String[] options, String defDelimiter, boolean multiDelims) {
        UIUtils.createControlLabel(group, label);
        Combo combo = new Combo(group, 2052);
        combo.setLayoutData((Object)new GridData(768));
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            combo.add(CommonUtils.escapeDisplayString((String)option));
            ++n2;
        }
        if (!multiDelims) {
            if (!ArrayUtils.contains((Object[])options, (Object)defDelimiter)) {
                combo.add(CommonUtils.escapeDisplayString((String)defDelimiter));
            }
            String[] items = combo.getItems();
            int i = 0;
            int itemsLength = items.length;
            while (i < itemsLength) {
                String delim = CommonUtils.unescapeDisplayString((String)items[i]);
                if (delim.equals(defDelimiter)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            combo.setText(CommonUtils.escapeDisplayString((String)defDelimiter));
        }
        return combo;
    }

    @Nullable
    public static Color getSharedColor(@Nullable String rgbString) {
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return DBeaverUI.getSharedTextColors().getColor(rgbString);
    }

    public static Color getConnectionColor(DBPConnectionConfiguration connectionInfo) {
        String rgbString = connectionInfo.getConnectionColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            rgbString = connectionInfo.getConnectionType().getColor();
        }
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        Color connectionColor = DBeaverUI.getSharedTextColors().getColor(rgbString);
        if (connectionColor.getBlue() == 255 && connectionColor.getRed() == 255 && connectionColor.getGreen() == 255) {
            return null;
        }
        return connectionColor;
    }

    public static Color getConnectionTypeColor(DBPConnectionType connectionType) {
        String rgbString = connectionType.getColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return DBeaverUI.getSharedTextColors().getColor(StringConverter.asRGB((String)rgbString));
    }

    public static Shell createCenteredShell(Shell parent) {
        Rectangle bounds = parent.getBounds();
        int x = bounds.x + bounds.width / 2 - 120;
        int y = bounds.y + bounds.height / 2 - 170;
        Shell shell = new Shell(parent);
        shell.setBounds(x, y, 0, 0);
        return shell;
    }

    public static Image getShardImage(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(id);
    }

    public static ImageDescriptor getShardImageDescriptor(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(id);
    }

    public static void installContentProposal(Control control, IControlContentAdapter contentAdapter, IContentProposalProvider provider) {
        UIUtils.installContentProposal(control, contentAdapter, provider, false, true);
    }

    public static void installContentProposal(Control control, IControlContentAdapter contentAdapter, IContentProposalProvider provider, boolean autoActivation, boolean insertAfter) {
        try {
            KeyStroke keyStroke = autoActivation ? null : KeyStroke.getInstance((String)"Ctrl+Space");
            ContentProposalAdapter proposalAdapter = new ContentProposalAdapter(control, contentAdapter, provider, keyStroke, autoActivation ? ".abcdefghijklmnopqrstuvwxyz_$(".toCharArray() : ".(".toCharArray());
            proposalAdapter.setProposalAcceptanceStyle(insertAfter ? 1 : 2);
            proposalAdapter.setPopupSize(new Point(300, 200));
        }
        catch (ParseException e) {
            log.error((Object)"Error installing filters content assistant");
        }
    }

    public static void setContentProposalToolTip(Control control, String toolTip, String ... variables) {
        StringBuilder varsTip = new StringBuilder();
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            if (varsTip.length() > 0) {
                varsTip.append(",\n");
            }
            varsTip.append("\t").append(GeneralUtils.variablePattern((String)var));
            ++n2;
        }
        varsTip.append(".");
        control.setToolTipText(String.valueOf(toolTip) + ". Allowed variables:\n" + varsTip);
    }

    public static CoolItem createCoolItem(CoolBar coolBar, Control control) {
        CoolItem item = new CoolItem(coolBar, 0);
        item.setControl(control);
        Point size = control.computeSize(-1, -1);
        Point preferred = item.computeSize(size.x, size.y);
        item.setPreferredSize(preferred);
        return item;
    }

    public static void resizeShell(Shell shell) {
        Point shellSize = shell.getSize();
        Point compSize = shell.computeSize(-1, -1);
        compSize.y += 20;
        if (shellSize.y < compSize.y) {
            shell.setSize(compSize);
            shell.layout(true);
        }
    }

    public static void waitJobCompletion(AbstractJob job) {
        Display display = Display.getCurrent();
        while (!job.isFinished()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.update();
    }

    public static void fixReadonlyTextBackground(Text textField) {
        if ((textField.getStyle() & 8) != 8) {
            textField.setBackground(null);
        }
    }

    public static ColorRegistry getColorRegistry() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
    }

    public static Color getGlobalColor(String colorName) {
        return UIUtils.getColorRegistry().get(colorName);
    }

    private static class StyledTextAction
    extends Action {
        private final StyledText styledText;
        private final int action;

        public StyledTextAction(String actionId, boolean enabled, StyledText styledText, int action) {
            super(ActionUtils.findCommandName(actionId));
            this.setActionDefinitionId(actionId);
            this.setEnabled(enabled);
            this.styledText = styledText;
            this.action = action;
        }

        public void run() {
            this.styledText.invokeAction(this.action);
        }
    }
}

