/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TrayIconHandler {
    private static final Log log = Log.getLog(TrayIconHandler.class);
    private TrayIcon trayItem;

    public void show() {
        File logoFile;
        if (this.trayItem != null) {
            return;
        }
        try {
            logoFile = RuntimeUtils.getPlatformFile((String)UIIcon.DBEAVER_LOGO.getLocation());
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        this.trayItem = new TrayIcon(Toolkit.getDefaultToolkit().getImage(logoFile.getAbsolutePath()));
        this.trayItem.setImageAutoSize(true);
        PopupMenu popupMenu = new PopupMenu();
        MenuItem showItem = new MenuItem("Show DBeaver");
        showItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrayIconHandler.this.showMainWindow();
            }
        });
        popupMenu.add(showItem);
        this.trayItem.setPopupMenu(popupMenu);
        this.trayItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.trayItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TrayIconHandler.this.showMainWindow();
                }
            }
        });
        this.trayItem.setToolTip(GeneralUtils.getProductTitle());
        try {
            SystemTray.getSystemTray().add(this.trayItem);
        }
        catch (AWTException e) {
            log.error((Object)e);
        }
    }

    private void showMainWindow() {
        DBeaverUI.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell activeShell = DBeaverUI.getActiveWorkbenchShell();
                if (activeShell != null) {
                    if (activeShell.getMinimized()) {
                        activeShell.setMinimized(false);
                    }
                    activeShell.forceActive();
                }
            }
        });
    }

    public void hide() {
        if (this.trayItem != null) {
            SystemTray.getSystemTray().remove(this.trayItem);
            this.trayItem = null;
        }
    }

    public void notify(String message, int status) {
        TrayIcon.MessageType type;
        if (this.trayItem == null) {
            try {
                this.show();
            }
            catch (Exception e) {
                log.warn((Object)"Can't show tray item", (Throwable)e);
                return;
            }
        }
        switch (status) {
            case 1: {
                type = TrayIcon.MessageType.INFO;
                break;
            }
            case 4: {
                type = TrayIcon.MessageType.ERROR;
                break;
            }
            case 2: {
                type = TrayIcon.MessageType.WARNING;
                break;
            }
            default: {
                type = TrayIcon.MessageType.NONE;
            }
        }
        this.trayItem.displayMessage(GeneralUtils.getProductTitle(), message, type);
    }
}

