/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 16;
    static final int DEFAULT_HEIGHT = 16;
    private Point imageSize = null;
    private ImageData baseImageData;
    private ImageDescriptor[] topLeft;
    private ImageDescriptor[] topRight;
    private ImageDescriptor[] bottomLeft;
    private ImageDescriptor[] bottomRight;

    public OverlayImageDescriptor(ImageData baseImageData) {
        this.baseImageData = baseImageData;
        this.imageSize = new Point(baseImageData.width, baseImageData.height);
    }

    public void setTopLeft(ImageDescriptor[] topLeft) {
        this.topLeft = topLeft;
    }

    public void setTopRight(ImageDescriptor[] topRight) {
        this.topRight = topRight;
    }

    public void setBottomLeft(ImageDescriptor[] bottomLeft) {
        this.bottomLeft = bottomLeft;
    }

    public void setBottomRight(ImageDescriptor[] bottomRight) {
        this.bottomRight = bottomRight;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData base = this.baseImageData;
        this.drawImage(base, 0, 0);
        if (this.topRight != null) {
            this.drawTopRight(this.topRight);
        }
        if (this.bottomRight != null) {
            this.drawBottomRight(this.bottomRight);
        }
        if (this.bottomLeft != null) {
            this.drawBottomLeft(this.bottomLeft);
        }
        if (this.topLeft != null) {
            this.drawTopLeft(this.topLeft);
        }
    }

    protected Point getSize() {
        return this.imageSize;
    }

    protected void drawTopLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                ImageData id = overlays[i].getImageData();
                this.drawImage(id, x, 0);
                x += id.width;
            }
            ++i;
        }
    }

    protected void drawTopRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                ImageData id = overlays[i].getImageData();
                this.drawImage(id, x -= id.width, 0);
            }
            --i;
        }
    }

    protected void drawBottomLeft(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = 0;
        int i = 0;
        while (i < 3) {
            if (i < length && overlays[i] != null) {
                ImageData id = overlays[i].getImageData();
                this.drawImage(id, x, this.getSize().y - id.height);
                x += id.width;
            }
            ++i;
        }
    }

    protected void drawBottomRight(ImageDescriptor[] overlays) {
        if (overlays == null) {
            return;
        }
        int length = overlays.length;
        int x = this.getSize().x;
        int i = 2;
        while (i >= 0) {
            if (i < length && overlays[i] != null) {
                ImageData id = overlays[i].getImageData();
                this.drawImage(id, x -= id.width, this.getSize().y - id.height);
            }
            --i;
        }
    }
}

