/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorJob;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorResponse;
import org.jkiss.utils.CommonUtils;

public class DatabaseTransferConsumer
implements IDataTransferConsumer<DatabaseConsumerSettings, IDataTransferProcessor> {
    private static final Log log = Log.getLog(DatabaseTransferConsumer.class);
    private DBSDataContainer sourceObject;
    private DBSDataManipulator targetObject;
    private DatabaseConsumerSettings settings;
    private DatabaseMappingContainer containerMapping;
    private ColumnMapping[] columnMappings;
    private DBCExecutionContext targetContext;
    private DBCSession targetSession;
    private DBSDataManipulator.ExecuteBatch executeBatch;
    private long rowsExported = 0L;
    private boolean ignoreErrors = false;
    private List<DBSEntityAttribute> targetAttributes;

    public DatabaseTransferConsumer() {
    }

    public DatabaseTransferConsumer(DBSDataManipulator targetObject) {
        this.targetObject = targetObject;
    }

    public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
        this.initExporter(session.getProgressMonitor());
        DBCResultSetMetaData metaData = resultSet.getMeta();
        List rsAttributes = metaData.getAttributes();
        this.columnMappings = new ColumnMapping[rsAttributes.size()];
        this.targetAttributes = new ArrayList<DBSEntityAttribute>(this.columnMappings.length);
        int i = 0;
        while (i < rsAttributes.size()) {
            ColumnMapping columnMapping = new ColumnMapping((DBCAttributeMetaData)rsAttributes.get(i));
            columnMapping.targetAttr = this.containerMapping.getAttributeMapping((DBSAttributeBase)columnMapping.sourceAttr);
            if (columnMapping.targetAttr == null) {
                throw new DBCException("Can't find target attribute [" + columnMapping.sourceAttr.getName() + "]");
            }
            columnMapping.sourceValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)columnMapping.sourceAttr);
            this.columnMappings[i] = columnMapping;
            if (columnMapping.targetAttr.getMappingType() != DatabaseMappingType.skip) {
                if (columnMapping.targetAttr.getTarget() == null) {
                    throw new DBCException("Target attribute for [" + columnMapping.sourceAttr.getName() + "] wasn't resolved");
                }
                columnMapping.targetValueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)columnMapping.targetAttr.getTarget());
                columnMapping.targetIndex = this.targetAttributes.size();
                this.targetAttributes.add(this.columnMappings[i].targetAttr.getTarget());
            }
            ++i;
        }
        this.executeBatch = this.containerMapping.getTarget().insertData(this.targetSession, this.targetAttributes.toArray(new DBSAttributeBase[this.targetAttributes.size()]), null, (DBCExecutionSource)new AbstractExecutionSource(this.sourceObject, this.targetContext, (Object)this));
    }

    public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
        Object[] rowValues = new Object[this.targetAttributes.size()];
        int i = 0;
        while (i < this.columnMappings.length) {
            ColumnMapping column = this.columnMappings[i];
            if (column.targetIndex >= 0) {
                Object attrValue = column.sourceValueHandler.fetchValueObject(session, resultSet, (DBSTypedObject)column.sourceAttr, i);
                rowValues[column.targetIndex] = column.targetValueHandler.getValueFromObject(session, (DBSTypedObject)column.targetAttr.getTarget(), attrValue, false);
            }
            ++i;
        }
        this.executeBatch.add(rowValues);
        ++this.rowsExported;
        this.insertBatch(false);
    }

    private void insertBatch(boolean force) throws DBCException {
        DBCTransactionManager txnManager;
        boolean needCommit;
        boolean bl = needCommit = force || this.rowsExported % (long)this.settings.getCommitAfterRows() == 0L;
        if (needCommit && this.executeBatch != null) {
            boolean retryInsert;
            do {
                retryInsert = false;
                try {
                    this.executeBatch.execute(this.targetSession);
                }
                catch (Throwable e) {
                    log.error((Object)"Error inserting row", e);
                    if (this.ignoreErrors) continue;
                    ExecutionQueueErrorResponse response = ExecutionQueueErrorJob.showError(String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)this.containerMapping.getTarget(), (DBPEvaluationContext)DBPEvaluationContext.UI)) + " data load", e, true);
                    switch (response) {
                        case STOP: {
                            throw new DBCException("Can't insert row", e);
                        }
                        case RETRY: {
                            retryInsert = true;
                            break;
                        }
                        case IGNORE: {
                            retryInsert = false;
                            break;
                        }
                        case IGNORE_ALL: {
                            this.ignoreErrors = true;
                            retryInsert = false;
                        }
                    }
                }
            } while (retryInsert);
        }
        if (this.settings.isUseTransactions() && needCommit && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null && !txnManager.isAutoCommit()) {
            txnManager.commit(this.targetSession);
        }
    }

    public void fetchEnd(DBCSession session, DBCResultSet resultSet) throws DBCException {
        if (this.rowsExported > 0L) {
            this.insertBatch(true);
        }
        if (this.executeBatch != null) {
            this.executeBatch.close();
            this.executeBatch = null;
        }
        this.closeExporter();
    }

    public void close() {
    }

    private void initExporter(DBRProgressMonitor monitor) throws DBCException {
        DBCTransactionManager txnManager;
        this.containerMapping = this.settings.getDataMapping(this.sourceObject);
        if (this.containerMapping == null) {
            throw new DBCException("Can't find container mapping for " + DBUtils.getObjectFullName((DBPNamedObject)this.sourceObject, (DBPEvaluationContext)DBPEvaluationContext.UI));
        }
        DBPDataSource dataSource = this.containerMapping.getTarget().getDataSource();
        assert (dataSource != null);
        try {
            this.targetContext = this.settings.isOpenNewConnections() ? dataSource.openIsolatedContext(monitor, "Data transfer consumer") : dataSource.getDefaultContext(false);
        }
        catch (DBException e) {
            throw new DBCException("Error opening new connection", (Throwable)e);
        }
        this.targetSession = this.targetContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Data load");
        this.targetSession.enableLogging(false);
        if (this.settings.isUseTransactions() && (txnManager = DBUtils.getTransactionManager((DBCExecutionContext)this.targetSession.getExecutionContext())) != null) {
            txnManager.setAutoCommit(monitor, false);
        }
    }

    private void closeExporter() {
        if (this.targetSession != null) {
            this.targetSession.close();
            this.targetSession = null;
        }
        if (this.targetContext != null && this.settings.isOpenNewConnections()) {
            this.targetContext.close();
            this.targetContext = null;
        }
    }

    @Override
    public void initTransfer(DBSObject sourceObject, DatabaseConsumerSettings settings, IDataTransferProcessor processor, Map<Object, Object> processorProperties) {
        this.sourceObject = (DBSDataContainer)sourceObject;
        this.settings = settings;
    }

    @Override
    public void startTransfer(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Create necessary database objects", 1);
        try {
            DBSObjectContainer container = this.settings.getContainer();
            if (container == null) {
                throw new DBException("No target datasource");
            }
            boolean hasNewObjects = false;
            DBPDataSource dataSource = container.getDataSource();
            Throwable throwable = null;
            Iterator<DatabaseMappingContainer> iterator = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (String)"Create target metadata");){
                block16: for (DatabaseMappingContainer containerMapping : this.settings.getDataMappings().values()) {
                    switch (containerMapping.getMappingType()) {
                        case create: {
                            this.createTargetTable(session, containerMapping);
                            hasNewObjects = true;
                            break;
                        }
                        case existing: {
                            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                                this.createTargetAttribute(session, attr);
                                hasNewObjects = true;
                            }
                            continue block16;
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (hasNewObjects) {
                monitor.subTask("Refresh navigator model");
                this.settings.getContainerNode().refreshNode(monitor, (Object)this);
                block18: for (DatabaseMappingContainer containerMapping : this.settings.getDataMappings().values()) {
                    switch (containerMapping.getMappingType()) {
                        case create: {
                            DBSObject newTarget = container.getChild(monitor, containerMapping.getTargetName());
                            if (newTarget == null) {
                                throw new DBCException("New table " + containerMapping.getTargetName() + " not found in container " + DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.UI));
                            }
                            if (!(newTarget instanceof DBSDataManipulator)) {
                                throw new DBCException("New table " + DBUtils.getObjectFullName((DBPNamedObject)newTarget, (DBPEvaluationContext)DBPEvaluationContext.UI) + " doesn't support data manipulation");
                            }
                            containerMapping.setTarget((DBSDataManipulator)newTarget);
                            containerMapping.setMappingType(DatabaseMappingType.existing);
                        }
                        case existing: {
                            for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
                                if (attr.getMappingType() != DatabaseMappingType.create) continue;
                                attr.updateMappingType(monitor);
                                if (attr.getTarget() != null) continue;
                                throw new DBCException("Can't find target attribute '" + attr.getTargetName() + "' in '" + containerMapping.getTargetName() + "'");
                            }
                            continue block18;
                        }
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createTargetTable(DBCSession session, DatabaseMappingContainer containerMapping) throws DBException {
        DBSObjectContainer schema = this.settings.getContainer();
        if (schema == null) {
            throw new DBException("No target container selected");
        }
        String sql = DatabaseTransferConsumer.generateTargetTableDDL(session.getProgressMonitor(), session.getDataSource(), schema, containerMapping);
        try {
            this.executeDDL(session, sql);
        }
        catch (DBCException e) {
            throw new DBCException("Can't create target table:\n" + sql, (Throwable)e);
        }
    }

    public static String generateTargetTableDDL(DBRProgressMonitor monitor, DBPDataSource dataSource, DBSObjectContainer schema, DatabaseMappingContainer containerMapping) throws DBException {
        Collection identifier;
        monitor.subTask("Create table " + containerMapping.getTargetName());
        StringBuilder sql = new StringBuilder(500);
        if (!(dataSource instanceof SQLDataSource)) {
            throw new DBException("Data source doesn't support SQL");
        }
        SQLDataSource targetDataSource = (SQLDataSource)dataSource;
        String tableName = DBObjectNameCaseTransformer.transformName((DBPDataSource)targetDataSource, (String)containerMapping.getTargetName());
        containerMapping.setTargetName(tableName);
        sql.append("CREATE TABLE ");
        if (schema instanceof DBSSchema || schema instanceof DBSCatalog) {
            sql.append(DBUtils.getQuotedIdentifier((DBSObject)schema));
            sql.append(targetDataSource.getSQLDialect().getCatalogSeparator());
        }
        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)targetDataSource, (String)tableName)).append("(\n");
        HashMap<DBSAttributeBase, DatabaseMappingAttribute> mappedAttrs = new HashMap<DBSAttributeBase, DatabaseMappingAttribute>();
        for (DatabaseMappingAttribute attr : containerMapping.getAttributeMappings(monitor)) {
            if (attr.getMappingType() != DatabaseMappingType.create) continue;
            if (!mappedAttrs.isEmpty()) {
                sql.append(",\n");
            }
            DatabaseTransferConsumer.appendAttributeClause(dataSource, sql, attr);
            mappedAttrs.put(attr.getSource(), attr);
        }
        if (containerMapping.getSource() instanceof DBSEntity && !CommonUtils.isEmpty((Collection)(identifier = DBUtils.getBestTableIdentifier((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)containerMapping.getSource()))))) {
            boolean idMapped = true;
            for (DBSEntityAttribute idAttr : identifier) {
                if (mappedAttrs.containsKey(idAttr)) continue;
                idMapped = false;
                break;
            }
            if (idMapped) {
                sql.append(",\nPRIMARY KEY (");
                boolean hasAttr = false;
                for (DBSEntityAttribute idAttr : identifier) {
                    DatabaseMappingAttribute mappedAttr = (DatabaseMappingAttribute)mappedAttrs.get(idAttr);
                    if (hasAttr) {
                        sql.append(",");
                    }
                    sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)mappedAttr.getTargetName()));
                    hasAttr = true;
                }
                sql.append(")\n");
            }
        }
        sql.append(")");
        return sql.toString();
    }

    private static void appendAttributeClause(DBPDataSource dataSource, StringBuilder sql, DatabaseMappingAttribute attr) {
        sql.append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)attr.getTargetName())).append(" ").append(attr.getTargetType(dataSource));
        if (SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource).supportsNullability() && attr.source.isRequired()) {
            sql.append(" NOT NULL");
        }
    }

    private void createTargetAttribute(DBCSession session, DatabaseMappingAttribute attribute) throws DBCException {
        session.getProgressMonitor().subTask("Create column " + DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + attribute.getTargetName());
        StringBuilder sql = new StringBuilder(500);
        sql.append("ALTER TABLE ").append(DBUtils.getObjectFullName((DBPNamedObject)attribute.getParent().getTarget(), (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" ADD ");
        DatabaseTransferConsumer.appendAttributeClause(session.getDataSource(), sql, attribute);
        try {
            this.executeDDL(session, sql.toString());
        }
        catch (DBCException e) {
            throw new DBCException("Can't create target column:\n" + sql, (Throwable)e);
        }
    }

    private void executeDDL(DBCSession session, String sql) throws DBCException {
        try (DBCStatement dbStat = DBUtils.makeStatement((DBCSession)session, (String)sql, (boolean)false);){
            dbStat.executeStatement();
        }
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
        if (txnManager != null && !txnManager.isAutoCommit()) {
            txnManager.commit(session);
        }
    }

    @Override
    public void finishTransfer(DBRProgressMonitor monitor, boolean last) {
        if (!last && this.settings.isOpenTableOnFinish() && this.containerMapping != null && this.containerMapping.getTarget() != null) {
            DBeaverUI.syncExec(new Runnable(){

                @Override
                public void run() {
                    NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)DatabaseTransferConsumer.this.containerMapping.getTarget());
                }
            });
        }
    }

    public DBSDataManipulator getTargetObject() {
        return this.targetObject;
    }

    @Override
    public String getTargetName() {
        if (this.targetObject != null) {
            return DBUtils.getObjectFullName((DBPNamedObject)this.targetObject, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        DatabaseMappingContainer dataMapping = this.settings.getDataMapping(this.sourceObject);
        if (dataMapping == null) {
            return "?";
        }
        switch (dataMapping.getMappingType()) {
            case create: {
                return String.valueOf(dataMapping.getTargetName()) + " [Create]";
            }
            case existing: {
                return String.valueOf(dataMapping.getTargetName()) + " [Insert]";
            }
            case skip: {
                return "[Skip]";
            }
        }
        return "?";
    }

    private static class ColumnMapping {
        DBCAttributeMetaData sourceAttr;
        DatabaseMappingAttribute targetAttr;
        DBDValueHandler sourceValueHandler;
        DBDValueHandler targetValueHandler;
        int targetIndex = -1;

        private ColumnMapping(DBCAttributeMetaData sourceAttr) {
            this.sourceAttr = sourceAttr;
        }
    }
}

