/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseProducerPageExtractSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final int EXTRACT_TYPE_SINGLE_QUERY = 0;
    private static final int EXTRACT_TYPE_SEGMENTS = 1;
    private Spinner threadsNumText;
    private Combo rowsExtractType;
    private Label segmentSizeLabel;
    private Text segmentSizeText;
    private Button newConnectionCheckbox;
    private Button rowCountCheckbox;

    public DatabaseProducerPageExtractSettings() {
        super("Extraction settings");
        this.setTitle("Extraction settings");
        this.setDescription("Database table(s) extraction settings");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        boolean hasSelection;
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final DatabaseProducerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        Group generalSettings = UIUtils.createControlGroup(composite, CoreMessages.data_transfer_wizard_output_group_progress, 4, 768, 0);
        Label threadsNumLabel = UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_max_threads);
        this.threadsNumText = new Spinner((Composite)generalSettings, 2048);
        this.threadsNumText.setMinimum(1);
        this.threadsNumText.setMaximum(10);
        this.threadsNumText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ((DataTransferWizard)((Object)DatabaseProducerPageExtractSettings.this.getWizard())).getSettings().setMaxJobCount(Integer.parseInt(DatabaseProducerPageExtractSettings.this.threadsNumText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        if (((DataTransferWizard)((Object)this.getWizard())).getSettings().getDataPipes().size() < 2) {
            threadsNumLabel.setEnabled(false);
            this.threadsNumText.setEnabled(false);
        }
        this.threadsNumText.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_extract_type);
        this.rowsExtractType = new Combo((Composite)generalSettings, 12);
        this.rowsExtractType.setItems(new String[]{CoreMessages.data_transfer_wizard_output_combo_extract_type_item_single_query, CoreMessages.data_transfer_wizard_output_combo_extract_type_item_by_segments});
        this.rowsExtractType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (DatabaseProducerPageExtractSettings.this.rowsExtractType.getSelectionIndex()) {
                    case 1: {
                        settings.setExtractType(DatabaseProducerSettings.ExtractType.SEGMENTS);
                        break;
                    }
                    case 0: {
                        settings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    }
                }
                DatabaseProducerPageExtractSettings.this.updatePageCompletion();
            }
        });
        this.segmentSizeLabel = UIUtils.createControlLabel((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_label_segment_size);
        this.segmentSizeLabel.setLayoutData((Object)new GridData(128, 2, false, false, 1, 1));
        this.segmentSizeText = new Text((Composite)generalSettings, 2048);
        this.segmentSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    settings.setSegmentSize(Integer.parseInt(DatabaseProducerPageExtractSettings.this.segmentSizeText.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.segmentSizeText.setLayoutData((Object)new GridData(128, 2, false, false, 1, 1));
        this.newConnectionCheckbox = UIUtils.createCheckbox((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_checkbox_new_connection, null, true, 4);
        this.newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(DatabaseProducerPageExtractSettings.this.newConnectionCheckbox.getSelection());
            }
        });
        this.rowCountCheckbox = UIUtils.createCheckbox((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_checkbox_select_row_count, null, true, 4);
        this.rowCountCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setQueryRowCount(DatabaseProducerPageExtractSettings.this.rowCountCheckbox.getSelection());
            }
        });
        IStructuredSelection curSelection = ((DataTransferWizard)((Object)this.getWizard())).getCurrentSelection();
        boolean bl = hasSelection = curSelection != null && !curSelection.isEmpty() && curSelection.getFirstElement() instanceof GridPos;
        if (hasSelection) {
            final Button selectedColumnsOnlyCheckbox = UIUtils.createCheckbox((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_checkbox_selected_columns_only, null, false, 4);
            selectedColumnsOnlyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setSelectedColumnsOnly(selectedColumnsOnlyCheckbox.getSelection());
                }
            });
            final Button selectedRowsOnlyCheckbox = UIUtils.createCheckbox((Composite)generalSettings, CoreMessages.data_transfer_wizard_output_checkbox_selected_rows_only, null, false, 4);
            selectedRowsOnlyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    settings.setSelectedRowsOnly(selectedRowsOnlyCheckbox.getSelection());
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selection = selectedColumnsOnlyCheckbox.getSelection() || selectedRowsOnlyCheckbox.getSelection();
                    DatabaseProducerPageExtractSettings.this.newConnectionCheckbox.setEnabled(!selection);
                }
            };
            selectedColumnsOnlyCheckbox.addSelectionListener((SelectionListener)listener);
            selectedRowsOnlyCheckbox.addSelectionListener((SelectionListener)listener);
        }
        this.setControl((Control)composite);
    }

    @Override
    public void activatePage() {
        DatabaseProducerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, DatabaseProducerSettings.class);
        this.newConnectionCheckbox.setSelection(settings.isOpenNewConnections());
        this.rowCountCheckbox.setSelection(settings.isQueryRowCount());
        if (this.segmentSizeText != null) {
            this.segmentSizeText.setText(String.valueOf(settings.getSegmentSize()));
            switch (settings.getExtractType()) {
                case SINGLE_QUERY: {
                    this.rowsExtractType.select(0);
                    break;
                }
                case SEGMENTS: {
                    this.rowsExtractType.select(1);
                }
            }
        }
        this.updatePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        if (this.rowsExtractType != null) {
            int selectionIndex = this.rowsExtractType.getSelectionIndex();
            if (selectionIndex == 1) {
                this.segmentSizeLabel.setVisible(true);
                this.segmentSizeText.setVisible(true);
            } else {
                this.segmentSizeLabel.setVisible(false);
                this.segmentSizeText.setVisible(false);
            }
        }
        return true;
    }
}

