/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

public class DatabaseConsumerPageLoadSettings
extends ActiveWizardPage<DataTransferWizard> {
    public DatabaseConsumerPageLoadSettings() {
        super("Data load");
        this.setTitle("Data load settings");
        this.setDescription("Configuration of table data load");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        final DatabaseConsumerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
        Group performanceSettings = UIUtils.createControlGroup(composite, "Performance", 4, 768, 0);
        final Button newConnectionCheckbox = UIUtils.createLabelCheckbox((Composite)performanceSettings, CoreMessages.data_transfer_wizard_output_checkbox_new_connection, settings.isOpenNewConnections());
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        newConnectionCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        final Button useTransactionsCheck = UIUtils.createLabelCheckbox((Composite)performanceSettings, "Use transactions", settings.isUseTransactions());
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        useTransactionsCheck.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        final Spinner commitAfterEdit = UIUtils.createLabelSpinner((Composite)performanceSettings, "Commit after insert of ", settings.getCommitAfterRows(), 1, Integer.MAX_VALUE);
        commitAfterEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCommitAfterRows(commitAfterEdit.getSelection());
            }
        });
        commitAfterEdit.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        Group generalSettings = UIUtils.createControlGroup(composite, "General", 4, 768, 0);
        final Button showTableCheckbox = UIUtils.createLabelCheckbox((Composite)generalSettings, "Open table editor on finish", settings.isOpenTableOnFinish());
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        showTableCheckbox.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        this.setControl((Control)composite);
    }

    @Override
    public void activatePage() {
        DatabaseConsumerSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
        this.updatePageCompletion();
    }

    @Override
    protected boolean determinePageCompletion() {
        return true;
    }
}

