/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.runtime.sql.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLQueryParameterBindDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.SQLQueryParameterBindDialog";
    private List<SQLQueryParameter> parameters;
    private final Map<String, List<SQLQueryParameter>> dupParameters = new HashMap<String, List<SQLQueryParameter>>();
    private static Map<String, SQLQueryParameterRegistry.ParameterInfo> savedParamValues = new HashMap<String, SQLQueryParameterRegistry.ParameterInfo>();

    protected SQLQueryParameterBindDialog(Shell shell, List<SQLQueryParameter> parameters) {
        super(shell);
        this.parameters = parameters;
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameter param : this.parameters) {
            SQLQueryParameterRegistry.ParameterInfo paramInfo;
            if (!param.isNamed() || param.getValue() != null || (paramInfo = registry.getParameter(param.getName())) == null) continue;
            param.setValue(paramInfo.value);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings(DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Bind parameter(s)");
        Composite composite = (Composite)super.createDialogArea(parent);
        final Table paramTable = new Table(composite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        paramTable.setLayoutData((Object)gd);
        paramTable.setHeaderVisible(true);
        paramTable.setLinesVisible(true);
        TableColumn indexColumn = UIUtils.createTableColumn(paramTable, 16384, "#");
        indexColumn.setWidth(40);
        TableColumn nameColumn = UIUtils.createTableColumn(paramTable, 16384, "Name");
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn(paramTable, 16384, "Value");
        valueColumn.setWidth(200);
        for (SQLQueryParameter param : this.parameters) {
            if (param.getPrevious() != null) {
                List<SQLQueryParameter> dups = this.dupParameters.get(param.getName());
                if (dups == null) {
                    dups = new ArrayList<SQLQueryParameter>();
                    this.dupParameters.put(param.getName(), dups);
                }
                dups.add(param);
                continue;
            }
            TableItem item = new TableItem(paramTable, 0);
            item.setData((Object)param);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ATTRIBUTE));
            item.setText(0, String.valueOf(param.getOrdinalPosition() + 1));
            item.setText(1, param.getTitle());
            item.setText(2, CommonUtils.notEmpty((String)param.getValue()));
        }
        final CustomTableEditor tableEditor = new CustomTableEditor(paramTable){
            {
                this.firstTraverseIndex = 2;
                this.lastTraverseIndex = 2;
                this.editOnEnter = false;
            }

            @Override
            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 2) {
                    return null;
                }
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                Text editor = new Text((Composite)table, 2048);
                editor.setText(CommonUtils.notEmpty((String)param.getValue()));
                editor.selectAll();
                return editor;
            }

            @Override
            protected void saveEditorValue(Control control, int index, TableItem item) {
                List dups;
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                String newValue = ((Text)control).getText();
                item.setText(2, newValue);
                param.setValue(newValue);
                if (param.isNamed() && (dups = (List)SQLQueryParameterBindDialog.this.dupParameters.get(param.getName())) != null) {
                    for (SQLQueryParameter dup : dups) {
                        dup.setValue(newValue);
                    }
                }
                savedParamValues.put(param.getName().toUpperCase(Locale.ENGLISH), new SQLQueryParameterRegistry.ParameterInfo(param.getName(), newValue));
            }
        };
        if (!this.parameters.isEmpty()) {
            DBeaverUI.asyncExec(new Runnable(){

                @Override
                public void run() {
                    paramTable.select(0);
                    tableEditor.showEditor(paramTable.getItem(0), 2);
                }
            });
        }
        this.updateStatus(GeneralUtils.makeInfoStatus((String)"Use Tab to switch. String values must be quoted. You can use expressions in values"));
        return composite;
    }

    protected void okPressed() {
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameterRegistry.ParameterInfo param : savedParamValues.values()) {
            registry.setParameter(param.name, param.value);
        }
        registry.save();
        super.okPressed();
    }
}

